/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.BytesInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.StringInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;

public abstract class H2TreeIndexBase
extends GridH2IndexBase {
    static final int IGNITE_VARIABLE_TYPE_DEFAULT_INDEX_SIZE = 10;
    static final Pattern STRING_WITH_LENGTH_SQL_PATTERN = Pattern.compile("\\w+\\((\\d+)\\)");

    protected H2TreeIndexBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        super(tbl, name, cols, type);
    }

    public abstract int inlineSize();

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        long rowCnt = this.getRowCountApproximation(ses);
        double baseCost = this.costRangeIndex(ses, masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    static int computeInlineSize(String name, List<InlineIndexColumn> inlineIdxs, int cfgInlineSize, int cfgMaxInlineSize, IgniteLogger log) {
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(inlineIdxs)) {
            return 0;
        }
        boolean fixedSize = true;
        int maxInlineSize = H2TreeIndexBase.maxInlineSize(cfgMaxInlineSize, name, log);
        if (maxInlineSize == 0) {
            return 0;
        }
        int computedInlineSize = 0;
        for (InlineIndexColumn idxHelper : inlineIdxs) {
            Matcher m;
            String sql;
            int sizeInc = idxHelper.size() < 0 ? 10 : idxHelper.size() + 1;
            fixedSize &= idxHelper.size() != -1;
            if ((idxHelper instanceof StringInlineIndexColumn || idxHelper instanceof BytesInlineIndexColumn) && (sql = idxHelper.columnSql()) != null && (m = STRING_WITH_LENGTH_SQL_PATTERN.matcher(sql)).find()) {
                sizeInc = Integer.parseInt(m.group(1)) + 3;
            }
            if ((computedInlineSize += sizeInc) <= maxInlineSize) continue;
            computedInlineSize = maxInlineSize;
        }
        if (cfgInlineSize != -1) {
            if (fixedSize && computedInlineSize < cfgInlineSize) {
                U.warn((IgniteLogger)log, (Object)("Explicit INLINE_SIZE for fixed size index item is too big. This will lead to wasting of space inside index pages. Ignoring [index=" + name + ", explicitInlineSize=" + cfgInlineSize + ", realInlineSize=" + computedInlineSize + ']'));
                return computedInlineSize;
            }
            if (cfgInlineSize > 427) {
                U.warn((IgniteLogger)log, (Object)("Explicit INLINE_SIZE exceeds maximum size. Ignoring [index=" + name + ", explicitInlineSize=" + cfgInlineSize + ", maxInlineSize=" + 427 + ']'));
            }
            return Math.min(cfgInlineSize, 427);
        }
        return computedInlineSize;
    }

    static List<InlineIndexColumn> getAvailableInlineColumns(boolean affinityKey, String cacheName, String idxName, IgniteLogger log, boolean pk, Table tbl, IndexColumn[] cols, InlineIndexColumnFactory factory, boolean inlineObjHashSupported) {
        ArrayList<InlineIndexColumn> res = new ArrayList<InlineIndexColumn>(cols.length);
        for (IndexColumn col : cols) {
            if (!InlineIndexColumnFactory.typeSupported(col.column.getType().getValueType())) {
                String idxType = pk ? "PRIMARY KEY" : (affinityKey ? "AFFINITY KEY (implicit)" : "SECONDARY");
                U.warn((IgniteLogger)log, (Object)("Column cannot be inlined into the index because it's type doesn't support inlining, index access may be slow due to additional page reads (change column type if possible) [cacheName=" + cacheName + ", tableName=" + tbl.getName() + ", idxName=" + idxName + ", idxType=" + idxType + ", colName=" + col.columnName + ", columnType=" + InlineIndexColumnFactory.nameTypeByCode(col.column.getType().getValueType()) + ']'));
                res.trimToSize();
                break;
            }
            res.add(factory.createInlineHelper(col.column, inlineObjHashSupported));
        }
        return res;
    }

    private static int maxInlineSize(int cfgMaxInlineSize, String name, IgniteLogger log) {
        if (cfgMaxInlineSize != -1) {
            if (cfgMaxInlineSize > 427) {
                U.warn((IgniteLogger)log, (Object)("Cache sqlIdxMaxInlineSize exceeds maximum allowed size. Ignoring[index=" + name + ", maxInlineSize=" + cfgMaxInlineSize + ", maxAllowedInlineSize=" + 427 + ']'));
                return 427;
            }
            return cfgMaxInlineSize;
        }
        int propSize = IgniteSystemProperties.getInteger((String)"IGNITE_MAX_INDEX_PAYLOAD_SIZE", (int)64);
        if (propSize > 427) {
            U.warn((IgniteLogger)log, (Object)("System property IGNITE_MAX_INDEX_PAYLOAD_SIZE exceeds maximum allowed size. Ignoring[index=" + name + ", propertySize=" + propSize + ", maxAllowedInlineSize=" + 427 + ']'));
            return 427;
        }
        return propSize;
    }
}

