/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.query.h2.DistributedSqlConfiguration;
import org.gridgain.internal.h2.expression.function.Function;
import org.gridgain.internal.h2.expression.function.FunctionInfo;

public class FunctionsManager<T extends Set<String> & Serializable>
implements DistributePropertyListener<T> {
    private static Map<String, FunctionInfo> origFuncs;
    private static Map<String, FunctionInfo> funcs;

    public FunctionsManager() {
        assert (Objects.nonNull(funcs));
        assert (Objects.nonNull(origFuncs));
    }

    public void onUpdate(String s, T oldFuncs, T newFuncs) {
        FunctionsManager.removeFunctions(newFuncs != null ? newFuncs : DistributedSqlConfiguration.DFLT_DISABLED_FUNCS);
    }

    private static void removeFunctions(Set<String> funcNames) {
        funcs.putAll(origFuncs);
        funcs.keySet().removeAll(funcNames);
    }

    static {
        try {
            Field fldFUNCTIONS = Function.class.getDeclaredField("FUNCTIONS");
            fldFUNCTIONS.setAccessible(true);
            funcs = (Map)fldFUNCTIONS.get(Class.class);
            origFuncs = new HashMap<String, FunctionInfo>(funcs);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

