/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.cache.CacheException;
import javax.cache.event.CacheEntryEvent;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceContext;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.util.KillCommandsSQLTest;
import org.junit.Assert;

class KillCommandsTests {
    public static final String SVC_NAME = "my-svc";
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final int PAGE_SZ = 5;
    public static final int PAGES_CNT = 1000;
    public static final int TIMEOUT = 10000;
    private static CountDownLatch computeLatch;

    KillCommandsTests() {
    }

    public static void doTestScanQueryCancel(IgniteEx cli, List<IgniteEx> srvs, Consumer<T3<UUID, String, Long>> qryCanceler) {
        int i;
        IgniteCache cache = cli.cache(DEFAULT_CACHE_NAME);
        QueryCursor qry1 = cache.query((Query)new ScanQuery().setPageSize(5));
        Iterator iter1 = qry1.iterator();
        Assert.assertNotNull(iter1.next());
        List<List<?>> scanQries0 = KillCommandsSQLTest.execute((Ignite)srvs.get(0), "SELECT ORIGIN_NODE_ID, CACHE_NAME, QUERY_ID FROM SYS.SCAN_QUERIES", new Object[0]);
        Assert.assertEquals((long)1L, (long)scanQries0.size());
        UUID originNodeId = (UUID)scanQries0.get(0).get(0);
        String cacheName = (String)scanQries0.get(0).get(1);
        long qryId = (Long)scanQries0.get(0).get(2);
        QueryCursor qry2 = cache.query((Query)new ScanQuery().setPageSize(5));
        Iterator iter2 = qry2.iterator();
        Assert.assertNotNull(iter2.next());
        qryCanceler.accept((T3<UUID, String, Long>)new T3((Object)originNodeId, (Object)cacheName, (Object)qryId));
        for (i = 0; i < 5 * srvs.size() - 1; ++i) {
            Assert.assertNotNull(iter1.next());
        }
        GridTestUtils.assertThrowsWithCause(iter1::next, IgniteCheckedException.class);
        for (i = 0; i < 24; ++i) {
            Assert.assertNotNull(iter2.next());
        }
        for (i = 0; i < srvs.size(); ++i) {
            IgniteEx ignite = srvs.get(i);
            int cacheId = CU.cacheId((String)DEFAULT_CACHE_NAME);
            GridCacheContext ctx = ignite.context().cache().context().cacheContext(cacheId);
            ConcurrentMap qryIters = ctx.queries().queryIterators();
            Assert.assertTrue((qryIters.size() <= 1 ? 1 : 0) != 0);
            if (qryIters.isEmpty()) {
                return;
            }
            GridCacheQueryManager.RequestFutureMap futs = (GridCacheQueryManager.RequestFutureMap)qryIters.get(cli.localNode().id());
            Assert.assertNotNull((Object)futs);
            Assert.assertFalse((boolean)futs.containsKey((Object)qryId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTestCancelComputeTask(IgniteEx cli, List<IgniteEx> srvs, Consumer<String> qryCanceler) throws Exception {
        computeLatch = new CountDownLatch(1);
        IgniteFuture fut = cli.compute().broadcastAsync((IgniteCallable & Serializable)() -> {
            computeLatch.await();
            return 1;
        });
        try {
            String[] id = new String[1];
            boolean res = GridTestUtils.waitForCondition(() -> {
                for (IgniteEx srv : srvs) {
                    List<List<?>> tasks = KillCommandsSQLTest.execute((Ignite)srv, "SELECT SESSION_ID FROM SYS.JOBS", new Object[0]);
                    if (tasks.size() == 1) {
                        id[0] = (String)tasks.get(0).get(0);
                        continue;
                    }
                    return false;
                }
                return true;
            }, (long)10000L);
            Assert.assertTrue((boolean)res);
            qryCanceler.accept(id[0]);
            for (IgniteEx srv : srvs) {
                res = GridTestUtils.waitForCondition(() -> {
                    List<List<?>> tasks = KillCommandsSQLTest.execute((Ignite)srv, "SELECT SESSION_ID FROM SYS.JOBS", new Object[0]);
                    return tasks.isEmpty();
                }, (long)10000L);
                Assert.assertTrue((String)srv.configuration().getIgniteInstanceName(), (boolean)res);
            }
            GridTestUtils.assertThrowsWithCause(() -> (Collection)fut.get(10000L), IgniteException.class);
        }
        finally {
            computeLatch.countDown();
        }
    }

    public static void doTestCancelTx(IgniteEx cli, List<IgniteEx> srvs, Consumer<String> txCanceler) {
        IgniteCache cache = cli.cache(DEFAULT_CACHE_NAME);
        int testKey = 5042;
        try (Transaction tx = cli.transactions().txStart();){
            cache.put((Object)testKey, (Object)1);
            List<List<?>> txs = KillCommandsSQLTest.execute((Ignite)cli, "SELECT xid FROM SYS.TRANSACTIONS", new Object[0]);
            Assert.assertEquals((long)1L, (long)txs.size());
            String xid = (String)txs.get(0).get(0);
            txCanceler.accept(xid);
            GridTestUtils.assertThrowsWithCause(() -> ((Transaction)tx).commit(), IgniteException.class);
            for (int i = 0; i < srvs.size(); ++i) {
                txs = KillCommandsSQLTest.execute((Ignite)srvs.get(i), "SELECT xid FROM SYS.TRANSACTIONS", new Object[0]);
                Assert.assertEquals((long)0L, (long)txs.size());
            }
        }
        Assert.assertNull((Object)cache.get((Object)testKey));
    }

    public static void doTestCancelService(IgniteEx startCli, IgniteEx killCli, IgniteEx srv, Consumer<String> svcCanceler) throws Exception {
        ServiceConfiguration scfg = new ServiceConfiguration();
        scfg.setName(SVC_NAME);
        scfg.setMaxPerNodeCount(1);
        scfg.setNodeFilter(srv.cluster().predicate());
        scfg.setService((Service)new TestServiceImpl());
        startCli.services().deploy(scfg);
        SystemView svcView = srv.context().systemView().view("services");
        SystemView killCliSvcView = killCli.context().systemView().view("services");
        boolean res = GridTestUtils.waitForCondition(() -> svcView.size() == 1 && killCliSvcView.size() == 1, (long)10000L);
        Assert.assertTrue((boolean)res);
        TestService svc = (TestService)startCli.services().serviceProxy(SVC_NAME, TestService.class, true);
        Assert.assertNotNull((Object)svc);
        svcCanceler.accept(SVC_NAME);
        res = GridTestUtils.waitForCondition(() -> svcView.size() == 0, (long)10000L);
        Assert.assertTrue((boolean)res);
    }

    public static void doTestCancelSQLQuery(IgniteEx cli, Consumer<String> qryCanceler) {
        String qryStr = "SELECT * FROM \"default\".Integer";
        SqlFieldsQuery qry = new SqlFieldsQuery(qryStr).setPageSize(5);
        Iterator iter = AbstractSchemaSelfTest.queryProcessor((Ignite)cli).querySqlFields(qry, true).iterator();
        Assert.assertNotNull(iter.next());
        List<List<?>> sqlQries = KillCommandsSQLTest.execute((Ignite)cli, "SELECT * FROM SYS.SQL_QUERIES ORDER BY START_TIME", new Object[0]);
        Assert.assertEquals((long)2L, (long)sqlQries.size());
        String qryId = (String)sqlQries.get(0).get(0);
        Assert.assertEquals((Object)qryStr, sqlQries.get(0).get(1));
        qryCanceler.accept(qryId);
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull(iter.next());
        }
        GridTestUtils.assertThrowsWithCause(iter::next, CacheException.class);
    }

    public static void doTestCancelContinuousQuery(IgniteEx cli, List<IgniteEx> srvs, BiConsumer<UUID, UUID> qryCanceler) throws Exception {
        int i;
        IgniteCache cache = cli.cache(DEFAULT_CACHE_NAME);
        ContinuousQuery cq = new ContinuousQuery();
        AtomicInteger cntr = new AtomicInteger();
        cq.setInitialQuery((Query)new ScanQuery());
        cq.setTimeInterval(1000L);
        cq.setPageSize(5);
        cq.setLocalListener(events -> {
            for (CacheEntryEvent e : events) {
                Assert.assertNotNull((Object)e);
                cntr.incrementAndGet();
            }
        });
        cache.query((Query)cq);
        for (int i2 = 0; i2 < 25; ++i2) {
            cache.put((Object)i2, (Object)i2);
        }
        boolean res = GridTestUtils.waitForCondition(() -> cntr.get() == 25, (long)10000L);
        Assert.assertTrue((boolean)res);
        List<List<?>> cqQries = KillCommandsSQLTest.execute((Ignite)cli, "SELECT NODE_ID, ROUTINE_ID FROM SYS.CONTINUOUS_QUERIES", new Object[0]);
        Assert.assertEquals((long)1L, (long)cqQries.size());
        UUID nodeId = (UUID)cqQries.get(0).get(0);
        UUID routineId = (UUID)cqQries.get(0).get(1);
        qryCanceler.accept(nodeId, routineId);
        long cnt = cntr.get();
        for (i = 0; i < 25; ++i) {
            cache.put((Object)i, (Object)i);
        }
        res = GridTestUtils.waitForCondition(() -> (long)cntr.get() > cnt, (long)10000L);
        Assert.assertFalse((boolean)res);
        for (i = 0; i < srvs.size(); ++i) {
            IgniteEx srv = srvs.get(i);
            res = GridTestUtils.waitForCondition(() -> KillCommandsSQLTest.execute((Ignite)srv, "SELECT ROUTINE_ID FROM SYS.CONTINUOUS_QUERIES", new Object[0]).isEmpty(), (long)10000L);
            Assert.assertTrue((String)srv.configuration().getIgniteInstanceName(), (boolean)res);
        }
    }

    public static void doTestCancelClientConnection(List<IgniteEx> srvs, BiConsumer<UUID, Long> cliCanceler) {
        ClientConfiguration cfg = new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:" + srvs.get(0).localNode().attribute("clientListenerPort")}).setAffinityAwarenessEnabled(false);
        IgniteClient cli0 = Ignition.startClient((ClientConfiguration)cfg);
        IgniteClient cli1 = Ignition.startClient((ClientConfiguration)cfg);
        IgniteClient cli2 = Ignition.startClient((ClientConfiguration)cfg);
        IgniteClient cli3 = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:" + srvs.get(1).localNode().attribute("clientListenerPort")}).setAffinityAwarenessEnabled(false));
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli0.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli1.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli2.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli3.cluster().state());
        List<List<?>> conns = KillCommandsSQLTest.execute((Ignite)srvs.get(0), "SELECT CONNECTION_ID FROM SYS.CLIENT_CONNECTIONS ORDER BY 1", new Object[0]);
        cliCanceler.accept(srvs.get(0).localNode().id(), (Long)conns.get(0).get(0));
        Predicate<IgniteClient> checker = cli -> {
            try {
                return GridTestUtils.waitForCondition(() -> {
                    try {
                        cli.cluster().state();
                        return false;
                    }
                    catch (ClientConnectionException e) {
                        return true;
                    }
                }, (long)10000L);
            }
            catch (Exception e) {
                return false;
            }
        };
        Assert.assertTrue((boolean)checker.test(cli0));
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli1.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli2.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli3.cluster().state());
        cliCanceler.accept(srvs.get(0).localNode().id(), null);
        Assert.assertTrue((boolean)checker.test(cli1));
        Assert.assertTrue((boolean)checker.test(cli2));
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli3.cluster().state());
        cliCanceler.accept(null, null);
        Assert.assertTrue((boolean)checker.test(cli3));
    }

    public static class TestServiceImpl
    implements TestService {
        public void cancel(ServiceContext ctx) {
        }

        public void init(ServiceContext ctx) {
        }

        public void execute(ServiceContext ctx) {
        }

        @Override
        public void doTheJob() {
        }
    }

    public static interface TestService
    extends Service {
        public void doTheJob();
    }
}

