/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqltests;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.sqltests.BaseSqlTest;
import org.junit.Test;

public class PartitionedSqlTest
extends BaseSqlTest {
    @Override
    protected void setupData() {
        super.createTables("template=partitioned");
        this.fillCommonData();
    }

    @Test
    public void testInnerDistributedJoin() {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Department d INNER JOIN Address a ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(PartitionedSqlTest.distributedJoinQry(forceOrder, "SELECT d.id, d.name, a.address FROM Department d INNER JOIN Address a ON d.%s = a.%s", "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(PartitionedSqlTest.distributedJoinQry(true, "SELECT d.id, d.name, a.address FROM Department d INNER JOIN Address a ON d.%s = a.%s", "idNoidx", "depId"), (Ignite)node);
            List exp = PartitionedSqlTest.doInnerJoin(node.cache("SQL_PUBLIC_DEPARTMENT"), node.cache("SQL_PUBLIC_ADDRESS"), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, addr) -> PartitionedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(dep, addr) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
        }));
    }

    @Test
    public void testInnerDistJoinMissedIndex() {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Department d INNER JOIN Address a ON d.%s = a.%s";
            this.assertDistJoinHasIncorrectIndex(() -> this.executeFrom(PartitionedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node));
            this.assertDistJoinHasIncorrectIndex(() -> this.executeFrom(PartitionedSqlTest.distributedJoinQry(true, qryTpl, "id", "depIdNoidx"), (Ignite)node));
        }));
    }

    @Test
    public void testLeftDistributedJoin() {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.depId, a.address FROM Department d LEFT JOIN Address a ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(PartitionedSqlTest.distributedJoinQry(forceOrder, "SELECT d.id, d.name, a.depId, a.address FROM Department d LEFT JOIN Address a ON d.%s = a.%s", "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOffOn = this.executeFrom(PartitionedSqlTest.distributedJoinQry(true, "SELECT d.id, d.name, a.depId, a.address FROM Department d LEFT JOIN Address a ON d.%s = a.%s", "idNoidx", "depId"), (Ignite)node);
            List exp = PartitionedSqlTest.doLeftJoin(node.cache("SQL_PUBLIC_DEPARTMENT"), node.cache("SQL_PUBLIC_ADDRESS"), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, addr) -> PartitionedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(dep, addr) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("DEPID"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'noidx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOffOn.values(), exp);
        }));
    }

    @Test
    public void testLeftDistributedJoinMissedIndex() {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Department d LEFT JOIN Address a ON d.%s = a.%s";
            this.assertDistJoinHasIncorrectIndex(() -> this.executeFrom(PartitionedSqlTest.distributedJoinQry(forceOrder, qryTpl, "id", "depIdNoidx"), (Ignite)node));
            this.assertDistJoinHasIncorrectIndex(() -> this.executeFrom(PartitionedSqlTest.distributedJoinQry(true, qryTpl, "idNoIdx", "depIdNoidx"), (Ignite)node));
        }));
    }

    @Test
    public void testRightDistributedJoin() {
        PartitionedSqlTest.setExplain(true);
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Department d RIGHT JOIN Address a ON d.%s = a.%s";
            BaseSqlTest.Result actIdxOnOn = this.executeFrom(PartitionedSqlTest.distributedJoinQry(forceOrder, "SELECT d.id, d.name, a.address FROM Department d RIGHT JOIN Address a ON d.%s = a.%s", "id", "depId"), (Ignite)node);
            BaseSqlTest.Result actIdxOnOff = this.executeFrom(PartitionedSqlTest.distributedJoinQry(true, "SELECT d.id, d.name, a.address FROM Department d RIGHT JOIN Address a ON d.%s = a.%s", "id", "depIdNoidx"), (Ignite)node);
            List exp = PartitionedSqlTest.doRightJoin(node.cache("SQL_PUBLIC_DEPARTMENT"), node.cache("SQL_PUBLIC_ADDRESS"), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, addr) -> PartitionedSqlTest.sqlEq(dep.get("ID"), addr.get("DEPID")), (IgniteBiClosure & Serializable)(dep, addr) -> Arrays.asList(dep.get("ID"), dep.get("NAME"), addr.get("ADDRESS")));
            this.assertContainsEq("Distributed join on 'idx = idx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOn.values(), exp);
            this.assertContainsEq("Distributed join on 'idx = noidx' returned unexpected result. Preserve join order = " + forceOrder + ".", actIdxOnOff.values(), exp);
        }));
    }

    @Test
    public void testRightDistributedJoinMissedIndex() {
        Arrays.asList(true, false).forEach(forceOrder -> this.testAllNodes(node -> {
            String qryTpl = "SELECT d.id, d.name, a.address FROM Department d RIGHT JOIN Address a ON d.%s = a.%s";
            this.assertDistJoinHasIncorrectIndex(() -> this.executeFrom(PartitionedSqlTest.distributedJoinQry(forceOrder, qryTpl, "idNoidx", "depIdNoidx"), (Ignite)node));
            this.assertDistJoinHasIncorrectIndex(() -> this.executeFrom(PartitionedSqlTest.distributedJoinQry(true, qryTpl, "idNoidx", "depId"), (Ignite)node));
        }));
    }
}

