/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.function.Predicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class SqlStatisticsCommandTests
extends StatisticsAbstractTest {
    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(2);
        this.grid(0).getOrCreateCache("default");
        this.sql("DROP TABLE IF EXISTS TEST");
        this.sql("DROP TABLE IF EXISTS TEST2");
        this.clearStat();
        this.testStatistics("PUBLIC", "TEST", true);
        this.testStatistics("PUBLIC", "TEST2", true);
        this.sql("CREATE TABLE TEST(id int primary key, name varchar)");
        this.sql("CREATE TABLE TEST2(id int primary key, name varchar)");
        this.sql("CREATE INDEX TEXT_NAME ON TEST(NAME);");
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.clearStat();
    }

    @Test
    public void testAnalyze() throws IgniteCheckedException {
        this.sql("ANALYZE TEST");
        this.testStatistics("PUBLIC", "TEST", false);
        this.sql("ANALYZE PUBLIC.TEST2(name)");
        this.testStatistics("PUBLIC", "TEST2", false);
        this.clearStat();
        this.testStatistics("PUBLIC", "TEST", true);
        this.testStatistics("PUBLIC", "TEST2", true);
        this.sql("ANALYZE PUBLIC.TEST, test2");
        this.testStatistics("PUBLIC", "TEST", false);
        this.testStatistics("PUBLIC", "TEST2", false);
    }

    @Test
    public void testRefreshStatistics() throws IgniteCheckedException {
        this.testStatistics("PUBLIC", "TEST", true);
        this.testStatistics("PUBLIC", "TEST2", true);
        this.sql("ANALYZE PUBLIC.TEST, test2");
        this.testStatistics("PUBLIC", "TEST", false);
        this.testStatistics("PUBLIC", "TEST2", false);
        long testVer = this.sumStatisticsVersion("PUBLIC", "TEST");
        long test2Ver = this.sumStatisticsVersion("PUBLIC", "TEST2");
        this.sql("REFRESH STATISTICS PUBLIC.TEST, test2");
        this.testStatisticsVersion("PUBLIC", "TEST", newVer -> newVer > testVer);
        this.testStatisticsVersion("PUBLIC", "TEST2", newVer -> newVer > test2Ver);
    }

    @Test
    public void testRefreshNotExistStatistics() throws IgniteInterruptedCheckedException {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("REFRESH STATISTICS PUBLIC.TEST"), IgniteSQLException.class, (String)"Statistic doesn't exist for [schema=PUBLIC, obj=TEST]");
        this.sql("ANALYZE PUBLIC.TEST(id)");
        this.testStatistics("PUBLIC", "TEST", false);
        long testVer = this.sumStatisticsVersion("PUBLIC", "TEST");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("REFRESH STATISTICS PUBLIC.TEST (id, name)"), IgniteSQLException.class, (String)"Statistic doesn't exist for [schema=PUBLIC, obj=TEST, col=NAME]");
        this.testStatisticsVersion("PUBLIC", "TEST", newVer -> newVer == testVer);
    }

    @Test
    public void testDropStatistics() throws IgniteInterruptedCheckedException {
        this.sql("ANALYZE PUBLIC.TEST, test2");
        this.testStatistics("PUBLIC", "TEST", false);
        this.testStatistics("PUBLIC", "TEST2", false);
        this.sql("DROP STATISTICS PUBLIC.TEST(name);");
        this.testStatistics("PUBLIC", "TEST", false);
        this.testStatistics("PUBLIC", "TEST2", false);
        U.sleep((long)3000L);
        this.sql("DROP STATISTICS PUBLIC.TEST;");
        this.testStatistics("PUBLIC", "TEST", true);
        this.testStatistics("PUBLIC", "TEST2", false);
        this.sql("ANALYZE PUBLIC.TEST, test2");
        this.testStatistics("PUBLIC", "TEST", false);
        this.testStatistics("PUBLIC", "TEST2", false);
        this.sql("DROP STATISTICS PUBLIC.TEST, test2");
        this.testStatistics("PUBLIC", "TEST", true);
        this.testStatistics("PUBLIC", "TEST2", true);
    }

    @Test
    public void testDropNotExistStatistics() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("DROP STATISTICS PUBLIC.TEST"), IgniteSQLException.class, (String)"Statistic doesn't exist for [schema=PUBLIC, obj=TEST]");
        this.sql("ANALYZE PUBLIC.TEST(id)");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("DROP STATISTICS PUBLIC.TEST (id, name)"), IgniteSQLException.class, (String)"Statistic doesn't exist for [schema=PUBLIC, obj=TEST, col=NAME]");
    }

    @Test
    public void statisticsLexemaTest() throws IgniteInterruptedCheckedException {
        this.sql("CREATE TABLE STATISTICS(id int primary key, statistics varchar)");
        this.sql("CREATE INDEX STATISTICS_STATISTICS ON STATISTICS(STATISTICS);");
        this.testStatistics("PUBLIC", "STATISTICS", true);
        this.sql("ANALYZE PUBLIC.STATISTICS(STATISTICS)");
        this.testStatistics("PUBLIC", "STATISTICS", false);
        this.sql("REFRESH STATISTICS PUBLIC.STATISTICS(STATISTICS)");
        this.testStatistics("PUBLIC", "STATISTICS", false);
        U.sleep((long)3000L);
        this.sql("DROP STATISTICS PUBLIC.STATISTICS(STATISTICS)");
        this.testStatistics("PUBLIC", "STATISTICS", true);
    }

    private void clearStat() throws IgniteCheckedException {
        this.statisticsMgr(0).dropAll();
    }

    private void testStatistics(String schema, String obj, boolean isNull) throws IgniteInterruptedCheckedException {
        SqlStatisticsCommandTests.assertTrue((String)("Unable to wait statistics by " + schema + "." + obj + " if null=" + isNull), (boolean)GridTestUtils.waitForCondition(() -> {
            for (Ignite node : G.allGrids()) {
                IgniteH2Indexing indexing = (IgniteH2Indexing)((IgniteEx)node).context().query().getIndexing();
                ObjectStatistics localStat = indexing.statsManager().getLocalStatistics(new StatisticsKey(schema, obj));
                if (isNull == (localStat == null)) continue;
                return false;
            }
            return true;
        }, (long)3000L));
    }

    private void testStatisticsVersion(String schema, String obj, Predicate<Long> verChecker) throws IgniteInterruptedCheckedException {
        SqlStatisticsCommandTests.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (Ignite node : G.allGrids()) {
                IgniteH2Indexing indexing = (IgniteH2Indexing)((IgniteEx)node).context().query().getIndexing();
                ObjectStatisticsImpl localStat = (ObjectStatisticsImpl)indexing.statsManager().getLocalStatistics(new StatisticsKey(schema, obj));
                long sumVer = localStat.columnsStatistics().values().stream().mapToLong(ColumnStatistics::version).sum();
                if (verChecker.test(sumVer)) continue;
                return false;
            }
            return true;
        }, (long)3000L));
    }

    long sumStatisticsVersion(String schema, String obj) {
        ObjectStatisticsImpl localStat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(new StatisticsKey(schema, obj));
        if (localStat == null) {
            return -1L;
        }
        return localStat.columnsStatistics().values().stream().mapToLong(ColumnStatistics::version).sum();
    }
}

