/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.testframework.junits.multijvm.IgniteProcessProxy;
import org.junit.Test;

public class OOMLeadsTest
extends GridCommonAbstractTest {
    private Statement stmt;
    private Connection conn;
    private static final String URL = "jdbc:ignite:thin://127.0.0.1:10800..10850/";

    protected List<String> additionalRemoteJvmArgs() {
        return Arrays.asList("-Xmx64m", "-Xms64m");
    }

    protected boolean isMultiJvm() {
        return true;
    }

    protected void beforeTest() throws Exception {
        this.startGrids(2);
        this.stopGrid(0);
        this.connect(URL);
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
        this.stopAllGrids();
        IgniteProcessProxy.killAll();
        super.afterTest();
    }

    private void connect(String url) throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = DriverManager.getConnection(url);
        this.conn.setSchema("PUBLIC");
        this.stmt = this.conn.createStatement();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setFailureHandler((FailureHandler)new StopNodeFailureHandler());
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(false).setSqlGlobalMemoryQuota("0"));
        return cfg;
    }

    @Test
    public void testOOMQueryHandling() throws Exception {
        this.stmt.execute("select x, space(100+x) as av from system_range(1, 1) group by av");
        GridTestUtils.assertThrows(null, () -> this.stmt.execute("select x, space(10000000+x) as av from system_range(1, 1000) group by av"), SQLException.class, (String)"Out of memory");
        OOMLeadsTest.assertTrue((boolean)((IgniteProcessProxy)this.grid(1)).getProcess().getProcess().isAlive());
        this.stmt.execute("select x, space(100+x) as av from system_range(1, 1) group by av");
        this.stmt.execute("create table t(ID INT PRIMARY KEY, VAL INT)");
        this.stmt.execute("insert into t values(1, 1)");
        ResultSet res = this.stmt.executeQuery("select count(*) from t");
        OOMLeadsTest.assertTrue((boolean)res.next());
        OOMLeadsTest.assertEquals((int)1, (int)res.getInt(1));
    }
}

