/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class MemoryTrackerOnReducerTest
extends GridCommonAbstractTest {
    private static final int BIG_TBL_SIZE = 20000;
    private static final AtomicLong maxReserved = new AtomicLong();

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(3);
        this.createSchema();
        this.populateData();
        GridTestUtils.setFieldValue((Object)this.grid(0).context().query().getIndexing(), (String)"memoryMgr", (Object)new QueryMemoryManager(this.grid(0).context()){

            public boolean reserve(long size) {
                boolean res = super.reserve(size);
                maxReserved.set(Math.max(maxReserved.get(), this.reserved()));
                return res;
            }
        });
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        maxReserved.set(0L);
    }

    @Test
    public void plainQueryWithoutMemoryTracker() {
        Iterator it = this.query("select * from TEST", true).iterator();
        int cnt = 0;
        while (it.hasNext()) {
            it.next();
            ++cnt;
        }
        MemoryTrackerOnReducerTest.assertEquals((long)0L, (long)maxReserved.get());
        MemoryTrackerOnReducerTest.assertEquals((int)20000, (int)cnt);
    }

    @Test
    public void reduceQueryAndTrackReducedBuffers() {
        Iterator it = this.query("select * from TEST T0, (SELECT DISTINCT id, name from TEST) T1 WHERE T0.id = T1.id", true).iterator();
        QueryMemoryManager memMgr = ((IgniteH2Indexing)this.grid(0).context().query().getIndexing()).memoryManager();
        int cnt = 0;
        while (it.hasNext()) {
            it.next();
            if (++cnt <= 1 || cnt >= 19999) continue;
            MemoryTrackerOnReducerTest.assertTrue((memMgr.reserved() > 0L ? 1 : 0) != 0);
        }
        MemoryTrackerOnReducerTest.assertTrue((maxReserved.get() > 0L ? 1 : 0) != 0);
        MemoryTrackerOnReducerTest.assertEquals((long)0L, (long)memMgr.reserved());
        MemoryTrackerOnReducerTest.assertEquals((int)20000, (int)cnt);
    }

    private void populateData() {
        for (int i = 0; i < 20000; ++i) {
            this.execSql("insert into TEST VALUES (?, ?, ?)", i, i % 100, UUID.randomUUID().toString());
        }
    }

    private void createSchema() {
        this.execSql("create table TEST (id int primary key, ref_key int, name varchar)", new Object[0]);
    }

    private void execSql(String sql, Object ... args) {
        this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false).getAll();
    }

    FieldsQueryCursor<List<?>> query(String sql, boolean lazy) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQueryEx(sql, null).setLazy(lazy).setEnforceJoinOrder(true).setPageSize(100), false);
    }
}

