/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class ExplainSelfTest
extends AbstractIndexingCommonTest {
    private static IgniteEx ignite;
    private static IgniteCache<?, ?> cache;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        ignite = this.startGrid(1);
        cache = ignite.getOrCreateCache("testTableCache");
        this.execute("CREATE TABLE PUBLIC.TEST (ID LONG PRIMARY KEY, VAL LONG) WITH \"template=replicated\";", false);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        ignite = null;
        cache = null;
        super.afterTestsStopped();
    }

    @Test
    public void testComplex() {
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (1, 2);", false);
        this.assertNotSupported("EXPLAIN UPDATE PUBLIC.TEST SET VAL = VAL + 1;", false);
        this.assertNotSupported("EXPLAIN MERGE INTO PUBLIC.TEST (ID, VAL) VALUES (1, 2);", false);
        this.assertNotSupported("EXPLAIN DELETE FROM PUBLIC.TEST;", false);
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (1, 2);", true);
        this.assertNotSupported("EXPLAIN UPDATE PUBLIC.TEST SET VAL = VAL + 1;", true);
        this.assertNotSupported("EXPLAIN MERGE INTO PUBLIC.TEST (ID, VAL) VALUES (1, 2);", true);
        this.assertNotSupported("EXPLAIN DELETE FROM PUBLIC.TEST;", true);
    }

    @Test
    public void test2InsertsLocalLast() {
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (1, 2);", false);
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (1, 2);", true);
    }

    @Test
    public void test2InsertsLocalFirst() {
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (3, 4);", true);
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (3, 4);", false);
    }

    @Test
    public void test2LocalInserts() {
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (5, 6);", true);
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (5, 6);", true);
    }

    @Test
    public void test2NonLocalInserts() {
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (7, 8);", false);
        this.assertNotSupported("EXPLAIN INSERT INTO PUBLIC.TEST VALUES (7, 8);", false);
    }

    @Test
    public void testExplainSelect() {
        this.execute("EXPLAIN SELECT * FROM PUBLIC.TEST;", false);
        this.execute("EXPLAIN SELECT * FROM PUBLIC.TEST;", true);
    }

    private List<List<?>> execute(String sql, boolean local) {
        return cache.query(new SqlFieldsQuery(sql).setLocal(local)).getAll();
    }

    private void assertNotSupported(String explainQry, boolean local) {
        Throwable exc = GridTestUtils.assertThrows((IgniteLogger)ignite.log(), () -> cache.query(new SqlFieldsQuery(explainQry).setLocal(local)).getAll(), IgniteSQLException.class, (String)"Explains of update queries are not supported.");
        IgniteSQLException sqlExc = (IgniteSQLException)exc;
        ExplainSelfTest.assertEquals((String)"Operation error code is not correct.", (int)1002, (int)sqlExc.statusCode());
    }
}

