/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.processors.query.h2.TableStatisticsAbstractTest;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RowCountTableStatisticsUsageTest
extends TableStatisticsAbstractTest {
    @Parameterized.Parameter(value=0)
    public CacheMode cacheMode;

    @Parameterized.Parameters(name="cacheMode={0}")
    public static Collection parameters() {
        return Arrays.asList({CacheMode.REPLICATED}, {CacheMode.PARTITIONED});
    }

    protected void beforeTestsStarted() throws Exception {
        Ignite node = this.startGridsMultiThreaded(2);
        node.getOrCreateCache("default");
    }

    protected void beforeTest() throws Exception {
        int i;
        this.runSql("DROP TABLE IF EXISTS big");
        this.runSql("DROP TABLE IF EXISTS med");
        this.runSql("DROP TABLE IF EXISTS small");
        this.runSql("CREATE TABLE big (a INT PRIMARY KEY, b INT, c INT) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.runSql("CREATE TABLE med (a INT PRIMARY KEY, b INT, c INT) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.runSql("CREATE TABLE small (a INT PRIMARY KEY, b INT, c INT) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.runSql("CREATE INDEX big_b ON big(b)");
        this.runSql("CREATE INDEX med_b ON med(b)");
        this.runSql("CREATE INDEX small_b ON small(b)");
        this.runSql("CREATE INDEX big_c ON big(c)");
        this.runSql("CREATE INDEX med_c ON med(c)");
        this.runSql("CREATE INDEX small_c ON small(c)");
        for (i = 0; i < 1000; ++i) {
            this.runSql("INSERT INTO big(a, b, c) VALUES(" + i + "," + i + "," + i % 10 + ")");
        }
        for (i = 0; i < 500; ++i) {
            this.runSql("INSERT INTO med(a, b, c) VALUES(" + i + "," + i + "," + i % 10 + ")");
        }
        for (i = 0; i < 100; ++i) {
            this.runSql("INSERT INTO small(a, b, c) VALUES(" + i + "," + i + "," + i % 10 + ")");
        }
    }

    @Test
    public void compareJoinsWithConditionsOnBothTables() {
        String sql = "SELECT COUNT(*) FROM t1 JOIN t2 ON t1.c = t2.c WHERE t1.b >= 0 AND t2.b >= 0";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "big");
    }

    @Test
    public void compareJoinsWithoutConditions() {
        String sql = "SELECT COUNT(*) FROM t1 JOIN t2 ON t1.c = t2.c";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "big", "small");
    }

    @Test
    public void compareJoinsConditionSingleTable() {
        String sql = "SELECT * FROM t1 JOIN t2 ON t1.c = t2.c WHERE t1.b >= 0";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), "SELECT * FROM t1 JOIN t2 ON t1.c = t2.c WHERE t1.b >= 0", "big", "small");
    }

    @Test
    public void compareJoinsThreeTablesNoConditions() {
        String sql = "SELECT * FROM t1 JOIN t2 ON t1.c = t2.c JOIN t3 ON t3.c = t2.c ";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "big", "med", "small");
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "big", "med");
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "med", "big");
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "med", "big", "small");
    }

    @Test
    public void compareJoinsThreeTablesConditionsOnAllTables() {
        String sql = "SELECT * FROM t1 JOIN t2 ON t1.c = t2.c JOIN t3 ON t3.c = t2.c  WHERE t1.b >= 0 AND t2.b >= 0 AND t3.b >= 0";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "big", "med", "small");
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "big", "med");
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "med", "big");
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "med", "big", "small");
    }

    @Test
    public void checkUpdateStatisticsOnTableSizeChange() {
        String sql = "SELECT COUNT(*) FROM t2 JOIN t1 ON t1.c = t2.c WHERE t1.b > 0 AND t2.b > 0";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "big");
        for (int i = 100; i < 2000; ++i) {
            this.runSql("INSERT INTO small(a, b, c) VALUES(" + i + "," + i + "," + i % 10 + ")");
        }
        sql = "SELECT COUNT(*) FROM t1 JOIN t2 ON t1.c = t2.c WHERE t1.b > 0 AND t2.b > 0";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "big");
    }

    @Test
    public void testStatisticsAfterRebalance() throws Exception {
        String sql = "SELECT COUNT(*) FROM t1 JOIN t2 ON t1.c = t2.c";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "big", "small");
        this.startGrid(3);
        try {
            this.awaitPartitionMapExchange();
            this.grid(3).context().cache().context().cacheContext(CU.cacheId((String)"SQL_PUBLIC_BIG")).preloader().rebalanceFuture().get(10000L);
            this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(1), sql, "big", "small");
            this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "big", "small");
        }
        finally {
            this.stopGrid(3);
        }
    }
}

