/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class SqlIllegalSchemaSelfTest
extends AbstractIndexingCommonTest {
    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testBadCacheName() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        String invalidCache = QueryUtils.sysSchemaName();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(invalidCache)});
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)("SQL schema name derived from cache name is reserved (please set explicit SQL schema name through CacheConfiguration.setSqlSchema() or choose another cache name) [cacheName=" + invalidCache + ", schemaName=null]"));
    }

    @Test
    public void testBadCacheNameDynamic() throws Exception {
        String invalidCache = QueryUtils.sysSchemaName();
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName(invalidCache));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name derived from cache name is reserved (please set explicit SQL schema name through CacheConfiguration.setSqlSchema() or choose another cache name) [cacheName=" + invalidCache + ", schemaName=null]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    @Test
    public void testBadSchemaLower() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        String invalidSchema = QueryUtils.sysSchemaName().toLowerCase();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("CACHE").setSqlSchema(invalidSchema)});
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)("SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=" + invalidSchema + "]"));
    }

    @Test
    public void testBadSchemaLowerDynamic() throws Exception {
        String invalidSchema = QueryUtils.sysSchemaName().toLowerCase();
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName("CACHE").setSqlSchema(invalidSchema));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=" + invalidSchema + "]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    @Test
    public void testBadSchemaUpper() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        String invalidSchema = QueryUtils.sysSchemaName().toUpperCase();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("CACHE").setSqlSchema(invalidSchema)});
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)("SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=" + invalidSchema + "]"));
    }

    @Test
    public void testBadSchemaUpperDynamic() throws Exception {
        String invalidSchema = QueryUtils.sysSchemaName().toUpperCase();
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName("CACHE").setSqlSchema(invalidSchema));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=" + invalidSchema + "]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    @Test
    public void testBadSchemaQuoted() throws Exception {
        final IgniteConfiguration cfg = this.getConfiguration();
        String invalidSchema = QueryUtils.sysSchemaName().toUpperCase();
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("CACHE").setSqlSchema("\"" + invalidSchema + "\"")});
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Ignition.start((IgniteConfiguration)cfg);
                return null;
            }
        }, IgniteException.class, (String)("SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=\"" + invalidSchema + "\"]"));
    }

    @Test
    public void testBadSchemaQuotedDynamic() throws Exception {
        String invalidSchema = QueryUtils.sysSchemaName().toUpperCase();
        this.doubleConsumerAccept(node -> {
            try {
                node.getOrCreateCache(new CacheConfiguration().setName("CACHE").setSqlSchema("\"" + invalidSchema + "\""));
            }
            catch (CacheException e) {
                SqlIllegalSchemaSelfTest.assertTrue((boolean)this.hasCause(e, IgniteCheckedException.class, "SQL schema name is reserved (please choose another one) [cacheName=CACHE, schemaName=\"" + invalidSchema + "\"]"));
                return;
            }
            catch (Throwable e) {
                SqlIllegalSchemaSelfTest.fail((String)("Exception class is not as expected [expected=" + CacheException.class + ", actual=" + e.getClass() + ']'));
            }
            SqlIllegalSchemaSelfTest.fail((String)"Exception has not been thrown.");
        });
    }

    private void doubleConsumerAccept(Consumer<Ignite> cons) throws Exception {
        IgniteEx node = this.startGrid();
        cons.accept((Ignite)node);
        cons.accept((Ignite)node);
    }

    private boolean hasCause(@Nullable Throwable t, Class<?> cls, String msg) {
        if (t == null) {
            return false;
        }
        assert (cls != null);
        for (Throwable th = t; th != null; th = th.getCause()) {
            if (cls.isAssignableFrom(th.getClass()) && F.eq((Object)th.getMessage(), (Object)msg)) {
                return true;
            }
            for (Throwable n : th.getSuppressed()) {
                if (!this.hasCause(n, cls, msg)) continue;
                return true;
            }
            if (th.getCause() == th) break;
        }
        return false;
    }
}

