/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class KillQueryErrorOnCancelTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGridsMultiThreaded(2);
        for (int i = 0; i < 1000; ++i) {
            this.grid(1).cache("default").put((Object)i, (Object)i);
        }
        this.awaitPartitionMapExchange();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids(true);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = GridAbstractTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(0);
        cache.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(IP_FINDER);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
                Message gridMsg;
                if (GridIoMessage.class.isAssignableFrom(msg.getClass()) && (gridMsg = ((GridIoMessage)msg).message()) instanceof GridQueryCancelRequest) {
                    throw new RuntimeException("Fake network error");
                }
                super.sendMessage(node, msg, ackC);
            }
        });
        return cfg;
    }

    @Test
    public void testCancelAfterIteratorObtainedLazy() throws Exception {
        IgniteEx node = this.grid(0);
        FieldsQueryCursor cur = node.context().query().querySqlFields(new SqlFieldsQuery("select * from \"default\".Integer ORDER BY _val").setLazy(true).setPageSize(1), false);
        Iterator it = cur.iterator();
        it.next();
        Long qryId = ((GridRunningQueryInfo)node.context().query().runningQueries(-1L).iterator().next()).id();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> node.context().query().querySqlFields(this.createKillQuery(node.context().localNodeId(), qryId, false), false).getAll(), IgniteException.class, (String)"Fake network error");
        List runningQueries = (List)node.context().query().runningQueries(-1L);
        KillQueryErrorOnCancelTest.assertTrue((String)("runningQueries=" + runningQueries), (boolean)runningQueries.isEmpty());
        this.ensureMapQueriesHasFinished(this.grid(0));
        this.ensureMapQueriesHasFinished(this.grid(1));
    }

    private void ensureMapQueriesHasFinished(IgniteEx node) throws Exception {
        boolean noTasksInQryPool = GridTestUtils.waitForCondition(() -> this.queryPoolIsEmpty(node), (long)5000L);
        Assert.assertTrue((String)("Node " + node.localNode().id() + " has not finished its tasks in the query pool"), (boolean)noTasksInQryPool);
    }

    private boolean queryPoolIsEmpty(IgniteEx node) {
        ThreadPoolExecutor qryPool = (ThreadPoolExecutor)node.context().pools().getQueryExecutorService();
        return qryPool.getQueue().isEmpty() && qryPool.getActiveCount() == 0;
    }

    private SqlFieldsQuery createKillQuery(UUID nodeId, long qryId, boolean async) {
        return new SqlFieldsQuery("KILL QUERY" + (async ? " ASYNC" : "") + " '" + nodeId + "_" + qryId + "'");
    }
}

