/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.fifo.FifoEvictionPolicy;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Ignore;
import org.junit.Test;

public class IgniteSqlSegmentedIndexSelfTest
extends AbstractIndexingCommonTest {
    private static final String ORG_CACHE_NAME = "org";
    private static final String PERSON_CAHE_NAME = "pers";
    private static final int ORG_CACHE_SIZE = 500;
    private static final int PERSON_CACHE_SIZE = 1000;
    private static final int ORPHAN_ROWS = 10;
    private static final int QRY_PARALLELISM_LVL = 97;

    protected int nodesCount() {
        return 1;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(this.nodesCount());
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid(0).destroyCaches(Arrays.asList(PERSON_CAHE_NAME, ORG_CACHE_NAME));
    }

    protected <K, V> CacheConfiguration<K, V> cacheConfig(String name, boolean partitioned, Class<?> ... idxTypes) {
        return new CacheConfiguration().setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setQueryParallelism(partitioned ? 97 : 1).setAtomicityMode(CacheAtomicityMode.ATOMIC).setIndexedTypes((Class[])idxTypes);
    }

    @Test
    public void testSegmentedIndex() {
        this.ignite(0).createCache(this.cacheConfig(PERSON_CAHE_NAME, true, PersonKey.class, Person.class));
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, OrgKey.class, Organization.class));
        this.fillCache();
        this.checkDistributedQueryWithSegmentedIndex();
        this.checkLocalQueryWithSegmentedIndex();
        this.checkLocalSizeQueryWithSegmentedIndex();
    }

    @Test
    public void testMissedSegmentWithSortedReducer() {
        IgniteCache cache = this.ignite(0).createCache(this.cacheConfig(PERSON_CAHE_NAME, true, PersonKey.class, Person.class));
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, OrgKey.class, Organization.class));
        String joinOrdered = "SELECT p.name, p.id FROM \"pers\".Person p INNER JOIN \"org\".Organization o ON p.orgId = o.id WHERE p.orgId in (3, 4) ORDER BY p.id";
        List res = cache.query(new SqlFieldsQuery(joinOrdered).setDistributedJoins(true)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertTrue((boolean)res.isEmpty());
        res = cache.query(new SqlFieldsQuery(joinOrdered)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertTrue((boolean)res.isEmpty());
        this.fillCachesLinear();
        res = cache.query(new SqlFieldsQuery(joinOrdered).setDistributedJoins(true)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertEquals((int)2, (int)res.size());
        res = cache.query(new SqlFieldsQuery(joinOrdered)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertEquals((int)2, (int)res.size());
    }

    @Test
    public void testSegmentedIndexReproducableResults() {
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class));
        IgniteCache cache = this.ignite(0).cache(ORG_CACHE_NAME);
        int expSize = this.nodesCount() * 97 * 3 / 2;
        for (int i = 0; i < expSize; ++i) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
        }
        String select0 = "select * from \"org\".Organization o";
        for (int i = 0; i < 10; ++i) {
            List res = cache.query(new SqlFieldsQuery(select0)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((int)expSize, (int)res.size());
        }
    }

    @Test
    public void testSegmentedIndexSizeReproducableResults() {
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class));
        IgniteCache cache = this.ignite(0).cache(ORG_CACHE_NAME);
        long expSize = this.nodesCount() * 97 * 3 / 2;
        int i = 0;
        while ((long)i < expSize) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
            ++i;
        }
        String select0 = "select count(*) from \"org\".Organization o";
        for (int i2 = 0; i2 < 10; ++i2) {
            List res = cache.query(new SqlFieldsQuery(select0)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((Object)expSize, ((List)res.get(0)).get(0));
        }
    }

    @Test
    public void testSegmentedIndexWithEvictionPolicy() {
        IgniteCache cache = this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class).setEvictionPolicy((EvictionPolicy)new FifoEvictionPolicy(10)).setOnheapCacheEnabled(true));
        long SIZE = 20L;
        int i = 0;
        while ((long)i < 20L) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
            ++i;
        }
        String select0 = "select name from \"org\".Organization";
        List res = cache.query(new SqlFieldsQuery(select0)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertEquals((long)20L, (long)res.size());
    }

    @Test
    public void testSizeOnSegmentedIndexWithEvictionPolicy() {
        IgniteCache cache = this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, true, Integer.class, Organization.class).setEvictionPolicy((EvictionPolicy)new FifoEvictionPolicy(10)).setOnheapCacheEnabled(true));
        long SIZE = 20L;
        int i = 0;
        while ((long)i < 20L) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
            ++i;
        }
        String select0 = "select count(*) from \"org\".Organization";
        List res = cache.query(new SqlFieldsQuery(select0)).getAll();
        IgniteSqlSegmentedIndexSelfTest.assertEquals((Object)20L, ((List)res.get(0)).get(0));
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-11839")
    @Test
    public void testSegmentedPartitionedWithReplicated() throws Exception {
        this.ignite(0).createCache(this.cacheConfig(PERSON_CAHE_NAME, true, PersonKey.class, Person.class));
        this.ignite(0).createCache(this.cacheConfig(ORG_CACHE_NAME, false, Integer.class, Organization.class));
        this.fillCache();
        this.checkDistributedQueryWithSegmentedIndex();
        this.checkLocalQueryWithSegmentedIndex();
        this.checkLocalSizeQueryWithSegmentedIndex();
    }

    public void checkDistributedQueryWithSegmentedIndex() {
        for (int i = 0; i < this.nodesCount(); ++i) {
            IgniteCache c1 = this.ignite(i).cache(PERSON_CAHE_NAME);
            long expPersons = 0L;
            for (Cache.Entry e : c1) {
                Integer orgId = ((PersonKey)e.getKey()).orgId;
                if (10 > orgId || orgId >= 500) continue;
                ++expPersons;
            }
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id";
            List res = c1.query(new SqlFieldsQuery(select0).setDistributedJoins(true)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((long)expPersons, (long)res.size());
        }
    }

    public void checkLocalQueryWithSegmentedIndex() {
        for (int i = 0; i < this.nodesCount(); ++i) {
            IgniteEx node = this.ignite(i);
            IgniteCache c1 = node.cache(PERSON_CAHE_NAME);
            IgniteCache c2 = node.cache(ORG_CACHE_NAME);
            HashSet<Integer> locOrgIds = new HashSet<Integer>();
            for (Cache.Entry e : c2.localEntries(new CachePeekMode[0])) {
                locOrgIds.add(((OrgKey)e.getKey()).id);
            }
            long expPersons = 0L;
            for (Cache.Entry e : c1.localEntries(new CachePeekMode[0])) {
                Integer orgId = ((PersonKey)e.getKey()).orgId;
                if (!locOrgIds.contains(orgId)) continue;
                ++expPersons;
            }
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id";
            List res = c1.query(new SqlFieldsQuery(select0).setLocal(true)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((long)expPersons, (long)res.size());
        }
    }

    public void checkLocalSizeQueryWithSegmentedIndex() {
        for (int i = 0; i < this.nodesCount(); ++i) {
            IgniteEx node = this.ignite(i);
            IgniteCache c1 = node.cache(PERSON_CAHE_NAME);
            IgniteCache c2 = node.cache(ORG_CACHE_NAME);
            HashSet<Integer> locOrgIds = new HashSet<Integer>();
            for (Object e : c2.localEntries(new CachePeekMode[0])) {
                locOrgIds.add(((OrgKey)e.getKey()).id);
            }
            int expPersons = 0;
            for (Cache.Entry e : c1.localEntries(new CachePeekMode[0])) {
                Integer orgId = ((PersonKey)e.getKey()).orgId;
                if (!locOrgIds.contains(orgId)) continue;
                ++expPersons;
            }
            String select0 = "select count(*) from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id";
            List res = c1.query(new SqlFieldsQuery(select0).setLocal(true)).getAll();
            IgniteSqlSegmentedIndexSelfTest.assertEquals((Object)expPersons, ((List)res.get(0)).get(0));
        }
    }

    private void fillCache() {
        IgniteCache c1 = this.ignite(0).cache(PERSON_CAHE_NAME);
        IgniteCache c2 = this.ignite(0).cache(ORG_CACHE_NAME);
        for (int i = 0; i < 500; ++i) {
            c2.put((Object)new OrgKey(i), (Object)new Organization("org-" + i));
        }
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int orgID = 10 + random.nextInt(510);
            c1.put((Object)new PersonKey(i, orgID), (Object)new Person("pers-" + i));
        }
    }

    private void fillCachesLinear() {
        IgniteCache c1 = this.ignite(0).cache(PERSON_CAHE_NAME);
        IgniteCache c2 = this.ignite(0).cache(ORG_CACHE_NAME);
        for (int i = 0; i < 500; ++i) {
            c1.put((Object)new PersonKey(i, i), (Object)new Person("pers-" + i));
            c2.put((Object)new OrgKey(i), (Object)new Organization("org-" + i));
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        String name;

        public Organization() {
        }

        public Organization(String name) {
            this.name = name;
        }
    }

    private static class OrgKey {
        @AffinityKeyMapped
        @QuerySqlField
        int id;

        public OrgKey(int id) {
            this.id = id;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        String name;

        public Person(String name) {
            this.name = name;
        }
    }

    private static class PersonKey {
        @QuerySqlField(index=true)
        int id;
        @AffinityKeyMapped
        @QuerySqlField
        Integer orgId;

        public PersonKey(int id, Integer orgId) {
            this.id = id;
            this.orgId = orgId;
        }
    }
}

