/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class DmlBatchSizeDeadlockTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 1000;
    private static final int TEST_TIME = 20000;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testDeadlockOnDmlAtomic() throws IgniteCheckedException {
        this.checkDeadlockOnDml(CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testDeadlockOnDmlTransactional() throws IgniteCheckedException {
        this.checkDeadlockOnDml(CacheAtomicityMode.TRANSACTIONAL);
    }

    public void checkDeadlockOnDml(CacheAtomicityMode mode) throws IgniteCheckedException {
        IgniteInternalFuture futCache;
        IgniteInternalFuture futDesc;
        boolean deadlock;
        IgniteCache<Long, Long> cache = this.createCache(mode);
        long tEnd = U.currentTimeMillis() + 20000L;
        IgniteInternalFuture futAsc = GridTestUtils.runAsync(() -> {
            while (U.currentTimeMillis() < tEnd) {
                try {
                    this.sql("UPDATE test SET val = 2 ORDER BY id ASC", new Object[0]);
                }
                catch (Exception e) {
                    IgniteSQLException esql = (IgniteSQLException)X.cause((Throwable)e, IgniteSQLException.class);
                    if (esql != null && esql.getMessage().contains("Failed to update some keys because they had been modified concurrently")) continue;
                    throw e;
                }
            }
        });
        boolean bl = deadlock = !GridTestUtils.waitForCondition(() -> DmlBatchSizeDeadlockTest.lambda$checkDeadlockOnDml$3(futAsc, futDesc = GridTestUtils.runAsync(() -> {
            while (U.currentTimeMillis() < tEnd) {
                while (U.currentTimeMillis() < tEnd) {
                    try {
                        this.sql("UPDATE test SET val = 3 ORDER BY id DESC", new Object[0]);
                    }
                    catch (Exception e) {
                        IgniteSQLException esql = (IgniteSQLException)X.cause((Throwable)e, IgniteSQLException.class);
                        if (esql != null && esql.getMessage().contains("Failed to update some keys because they had been modified concurrently")) continue;
                        throw e;
                    }
                }
            }
        }), futCache = GridTestUtils.runAsync(() -> {
            while (U.currentTimeMillis() < tEnd) {
                LinkedHashMap<Long, Long> map = new LinkedHashMap<Long, Long>();
                for (long i = 999L; i >= 0L; --i) {
                    map.put(i, i);
                }
                cache.putAll(map);
            }
        })), (long)25000L);
        if (deadlock) {
            futAsc.cancel();
            futDesc.cancel();
            futCache.cancel();
            DmlBatchSizeDeadlockTest.fail((String)"Deadlock on DML");
        }
    }

    private IgniteCache<Long, Long> createCache(CacheAtomicityMode mode) {
        IgniteCache c = this.grid().createCache(new CacheConfiguration().setName("test").setSqlSchema("TEST").setAtomicityMode(mode).setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)));
        for (long i = 0L; i < 1000L; ++i) {
            c.put((Object)i, (Object)i);
        }
        return c;
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid().context().query().querySqlFields(new SqlFieldsQuery(sql).setSchema("TEST").setUpdateBatchSize(1).setArgs(args), false);
    }

    private static /* synthetic */ boolean lambda$checkDeadlockOnDml$3(IgniteInternalFuture futAsc, IgniteInternalFuture futDesc, IgniteInternalFuture futCache) {
        return futAsc.isDone() && futDesc.isDone() && futCache.isDone();
    }
}

