/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class AbstractQueryTableLockAndConnectionPoolSelfTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 500;
    private static final int BASE_QRY_ARG = 50;
    private static final int PAGE_SIZE_SMALL = 12;
    private static final long TEST_DUR = GridTestUtils.SF.applyLB((int)10000, (int)3000);
    private static boolean local = false;

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testSingleNode() throws Exception {
        this.checkSingleNode(1);
    }

    @Test
    public void testSingleNodeWithParallelism() throws Exception {
        this.checkSingleNode(4);
    }

    @Test
    public void testMultipleNodes() throws Exception {
        this.checkMultipleNodes(1);
    }

    @Test
    public void testMultipleNodesWithParallelism() throws Exception {
        this.checkMultipleNodes(4);
    }

    @Test
    public void testSingleNodeTablesLockQueryAndDDLMultithreaded() throws Exception {
        IgniteEx srv = this.startGrid(0);
        AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)srv, 1);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)srv);
        this.checkTablesLockQueryAndDropColumnMultithreaded((Ignite)srv);
    }

    @Test
    public void testSingleNodeTablesLockQueryLocalAndDDLMultithreaded() throws Exception {
        local = true;
        try {
            IgniteEx srv = this.startGrid(0);
            AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)srv, 1);
            this.checkTablesLockQueryAndDDLMultithreaded((Ignite)srv);
            this.checkTablesLockQueryAndDropColumnMultithreaded((Ignite)srv);
        }
        finally {
            local = false;
        }
    }

    @Test
    public void testSingleNodeWithParallelismTablesLockQueryAndDDLMultithreaded() throws Exception {
        IgniteEx srv = this.startGrid(0);
        AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)srv, 4);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)srv);
        this.checkTablesLockQueryAndDropColumnMultithreaded((Ignite)srv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleNodesWithTablesLockQueryAndDDLMultithreaded() throws Exception {
        IgniteEx cli;
        IgniteEx srv0 = this.startGrid(0);
        IgniteEx srv1 = this.startGrid(1);
        this.startGrid(2);
        try {
            Ignition.setClientMode((boolean)true);
            cli = this.startGrid(3);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
        AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)srv0, 1);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)srv0);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)srv1);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)cli);
        this.checkTablesLockQueryAndDropColumnMultithreaded((Ignite)srv0);
        this.checkTablesLockQueryAndDropColumnMultithreaded((Ignite)srv1);
    }

    @Test
    public void testMultipleNodesWithTablesLockQueryAndTableDrop() throws Exception {
        IgniteEx srv0 = this.startGrid(0);
        IgniteEx srv1 = this.startGrid(1);
        this.startGrid(2);
        this.checkTablesLockQueryAndDropTable((Ignite)srv0);
        this.checkTablesLockQueryAndDropTable((Ignite)srv1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleNodesWithParallelismTablesLockQueryAndDDLMultithreaded() throws Exception {
        IgniteEx cli;
        IgniteEx srv0 = this.startGrid(0);
        IgniteEx srv1 = this.startGrid(1);
        this.startGrid(2);
        try {
            Ignition.setClientMode((boolean)true);
            cli = this.startGrid(3);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
        AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)srv0, 4);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)srv0);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)srv1);
        this.checkTablesLockQueryAndDDLMultithreaded((Ignite)cli);
        this.checkTablesLockQueryAndDropColumnMultithreaded((Ignite)srv0);
        this.checkTablesLockQueryAndDropColumnMultithreaded((Ignite)srv1);
    }

    @Test
    public void testReleasePartitionReservationSeveralPagesResults() throws Exception {
        this.checkReleasePartitionReservation(12);
    }

    @Test
    public void testReleasePartitionReservationOnePageResults() throws Exception {
        this.checkReleasePartitionReservation(500);
    }

    @Test
    public void testFetchFromRemovedTable() throws Exception {
        IgniteEx srv = this.startGrid(0);
        this.execute((Ignite)srv, "CREATE TABLE TEST (id int primary key, val int)");
        for (int i = 0; i < 10; ++i) {
            this.execute((Ignite)srv, "INSERT INTO TEST VALUES (" + i + ", " + i + ")");
        }
        FieldsQueryCursor<List<?>> cur = this.execute((Ignite)srv, new SqlFieldsQuery("SELECT * from TEST").setPageSize(1));
        Iterator it = cur.iterator();
        it.next();
        this.execute((Ignite)srv, "DROP TABLE TEST");
        try {
            while (it.hasNext()) {
                it.next();
            }
            if (this.lazy()) {
                AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"Retry exception must be thrown");
            }
        }
        catch (Exception e) {
            if (!this.lazy()) {
                log.error("In lazy=false mode the query must be finished successfully", (Throwable)e);
                AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"In lazy=false mode the query must be finished successfully");
            }
            AbstractQueryTableLockAndConnectionPoolSelfTest.assertNotNull((Object)X.cause((Throwable)e, QueryRetryException.class));
        }
    }

    private void checkTablesLockQueryAndDDLMultithreaded(final Ignite node) throws Exception {
        final AtomicBoolean end = new AtomicBoolean(false);
        int qryThreads = 10;
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                while (!end.get()) {
                    try {
                        FieldsQueryCursor cursor = AbstractQueryTableLockAndConnectionPoolSelfTest.this.execute(node, new SqlFieldsQueryEx("SELECT pers.id, pers.name FROM (SELECT DISTINCT p.id, p.name FROM \"pers\".PERSON as p) as pers JOIN \"pers\".PERSON p on p.id = pers.id JOIN (SELECT t.persId as persId, SUM(t.time) totalTime FROM \"persTask\".PersonTask as t GROUP BY t.persId) as task ON task.persId = pers.id", Boolean.valueOf(true)).setLazy(AbstractQueryTableLockAndConnectionPoolSelfTest.this.lazy()).setLocal(local).setPageSize(12));
                        cursor.getAll();
                    }
                    catch (Exception e) {
                        if (X.cause((Throwable)e, QueryRetryException.class) == null) {
                            log.error("Unexpected exception", (Throwable)e);
                            AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)("Unexpected exception. " + e));
                            continue;
                        }
                        if (AbstractQueryTableLockAndConnectionPoolSelfTest.this.lazy()) continue;
                        log.error("Unexpected exception", (Throwable)e);
                        AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"Unexpected QueryRetryException.");
                    }
                }
            }
        }, (int)10, (String)"usr-qry");
        long tEnd = U.currentTimeMillis() + TEST_DUR;
        while (U.currentTimeMillis() < tEnd) {
            this.execute(node, new SqlFieldsQuery("CREATE INDEX \"pers\".PERSON_NAME ON \"pers\".Person (name asc)")).getAll();
            this.execute(node, new SqlFieldsQuery("DROP INDEX \"pers\".PERSON_NAME")).getAll();
        }
        end.set(true);
        fut.get();
        this.checkConnectionLeaks(Ignition.allGrids().size());
    }

    private void checkTablesLockQueryAndDropColumnMultithreaded(final Ignite node) throws Exception {
        final AtomicBoolean end = new AtomicBoolean(false);
        int qryThreads = 10;
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                while (!end.get()) {
                    try {
                        FieldsQueryCursor cursor = AbstractQueryTableLockAndConnectionPoolSelfTest.this.execute(node, new SqlFieldsQuery("SELECT pers.id, pers.name FROM \"pers\".PERSON").setLazy(AbstractQueryTableLockAndConnectionPoolSelfTest.this.lazy()).setPageSize(12));
                        cursor.getAll();
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("Failed to parse query. Column \"PERS.ID\" not found")) continue;
                        if (X.cause((Throwable)e, QueryRetryException.class) == null) {
                            log.error("Unexpected exception", (Throwable)e);
                            AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)("Unexpected exception. " + e));
                            continue;
                        }
                        if (AbstractQueryTableLockAndConnectionPoolSelfTest.this.lazy()) continue;
                        log.error("Unexpected exception", (Throwable)e);
                        AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"Unexpected QueryRetryException.");
                    }
                }
            }
        }, (int)10, (String)"usr-qry");
        long tEnd = U.currentTimeMillis() + TEST_DUR;
        while (U.currentTimeMillis() < tEnd) {
            this.execute(node, new SqlFieldsQuery("ALTER TABLE \"pers\".Person DROP COLUMN name")).getAll();
            this.execute(node, new SqlFieldsQuery("ALTER TABLE \"pers\".Person ADD  COLUMN name varchar")).getAll();
        }
        end.set(true);
        fut.get();
        this.checkConnectionLeaks(Ignition.allGrids().size());
    }

    private void checkTablesLockQueryAndDropTable(final Ignite node) throws Exception {
        this.execute(node, new SqlFieldsQuery("CREATE TABLE IF NOT EXISTS TEST (ID INT PRIMARY KEY, VAL INT)")).getAll();
        final AtomicBoolean end = new AtomicBoolean(false);
        int qryThreads = 10;
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                while (!end.get()) {
                    try {
                        FieldsQueryCursor cursor = AbstractQueryTableLockAndConnectionPoolSelfTest.this.execute(node, new SqlFieldsQuery("SELECT * FROM TEST").setLazy(AbstractQueryTableLockAndConnectionPoolSelfTest.this.lazy()));
                        cursor.getAll();
                    }
                    catch (Exception e) {
                        String msg = e.getMessage();
                        if (msg.contains("Failed to find cache") || msg.contains("Failed to perform cache operation (cache is stopped)") || msg.contains("Failed to parse query. Table \"TEST\" not found") || msg.contains("Cache not found on local node (was concurrently destroyed?)") || msg.contains("Getting affinity for too old topology version that is already out of history") || msg.contains("Failed to find partitioned cache") || msg.contains("Table \"TEST\" not found") || msg.contains("Table not found") || msg.contains("Table PUBLIC.TEST already destroyed") || X.cause((Throwable)e, IgniteInterruptedCheckedException.class) != null) continue;
                        if (X.cause((Throwable)e, QueryRetryException.class) == null) {
                            log.error("Unexpected exception", (Throwable)e);
                            AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)("Unexpected exception. " + e));
                            continue;
                        }
                        if (AbstractQueryTableLockAndConnectionPoolSelfTest.this.lazy()) continue;
                        log.error("Unexpected exception", (Throwable)e);
                        AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"Unexpected QueryRetryException.");
                    }
                }
            }
        }, (int)10, (String)"usr-qry");
        long tEnd = U.currentTimeMillis() + TEST_DUR;
        while (U.currentTimeMillis() < tEnd) {
            this.execute(node, new SqlFieldsQuery("DROP TABLE TEST")).getAll();
            U.sleep((long)10L);
            this.execute(node, new SqlFieldsQuery("CREATE TABLE TEST (ID INT PRIMARY KEY, VAL INT)")).getAll();
        }
        end.set(true);
        fut.get();
        this.checkConnectionLeaks(Ignition.allGrids().size());
    }

    public void checkReleasePartitionReservation(int pageSize) throws Exception {
        IgniteEx srv1 = this.startGrid(1);
        this.startGrid(2);
        AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)srv1, 1);
        FieldsQueryCursor<List<?>> cursor = this.execute((Ignite)srv1, AbstractQueryTableLockAndConnectionPoolSelfTest.query(0L).setPageSize(pageSize));
        cursor.getAll();
        this.startGrid(3);
        this.awaitPartitionMapExchange();
    }

    public void checkSingleNode(int parallelism) throws Exception {
        IgniteEx srv = this.startGrid(0);
        AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)srv, parallelism);
        this.checkBaseOperations((Ignite)srv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMultipleNodes(int parallelism) throws Exception {
        IgniteEx cli;
        IgniteEx srv1 = this.startGrid(0);
        IgniteEx srv2 = this.startGrid(1);
        try {
            Ignition.setClientMode((boolean)true);
            cli = this.startGrid(2);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
        AbstractQueryTableLockAndConnectionPoolSelfTest.populateBaseQueryData((Ignite)cli, parallelism);
        this.checkBaseOperations((Ignite)srv1);
        this.checkBaseOperations((Ignite)srv2);
        this.checkBaseOperations((Ignite)cli);
        FieldsQueryCursor<List<?>> cursor = this.execute((Ignite)cli, AbstractQueryTableLockAndConnectionPoolSelfTest.baseQuery().setPageSize(12));
        Iterator iter = cursor.iterator();
        for (int i = 0; i < 30; ++i) {
            iter.next();
        }
        this.stopGrid(2);
        try (FieldsQueryCursor<List<?>> cursor2 = this.execute((Ignite)srv1, AbstractQueryTableLockAndConnectionPoolSelfTest.baseQuery().setPageSize(12));){
            Iterator iter2 = cursor2.iterator();
            for (int i = 0; i < 30; ++i) {
                iter2.next();
            }
            this.stopGrid(1);
        }
    }

    private void checkBaseOperations(Ignite node) throws Exception {
        int i;
        Iterator iter2;
        Iterator it;
        Object cursor;
        ArrayList<List<?>> rows;
        block23: {
            this.checkQuerySplitToSeveralMapQueries(node);
            rows = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.baseQuery()).getAll();
            AbstractQueryTableLockAndConnectionPoolSelfTest.assertBaseQueryResults(rows);
            rows = new ArrayList();
            cursor = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.baseQuery().setPageSize(12));
            it = cursor.iterator();
            for (int i2 = 0; i2 < 10; ++i2) {
                rows.add((List<?>)it.next());
            }
            this.execute(node, new SqlFieldsQuery("CREATE INDEX \"pers\".PERSON_NAME ON \"pers\".Person (name asc)")).getAll();
            this.execute(node, new SqlFieldsQuery("DROP INDEX \"pers\".PERSON_NAME")).getAll();
            try {
                while (it.hasNext()) {
                    rows.add((List<?>)it.next());
                }
                if (this.lazy()) {
                    AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"Retry exception must be thrown");
                }
            }
            catch (Exception e) {
                if (this.lazy() && X.cause((Throwable)e, QueryRetryException.class) != null) break block23;
                log.error("Invalid exception: ", (Throwable)e);
                AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"QueryRetryException is expected");
            }
        }
        rows = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.baseQuery().setPageSize(12)).getAll();
        AbstractQueryTableLockAndConnectionPoolSelfTest.assertBaseQueryResults(rows);
        rows = new ArrayList();
        cursor = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.baseQuery().setPageSize(12));
        it = cursor.iterator();
        while (it.hasNext()) {
            List row = (List)it.next();
            rows.add(row);
        }
        cursor.close();
        AbstractQueryTableLockAndConnectionPoolSelfTest.assertBaseQueryResults(rows);
        FieldsQueryCursor<List<?>> partialCursor = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.baseQuery().setPageSize(12));
        cursor = null;
        try {
            iter2 = partialCursor.iterator();
            for (i = 0; i < 30; ++i) {
                iter2.next();
            }
        }
        catch (Throwable iter2) {
            cursor = iter2;
            throw iter2;
        }
        finally {
            if (partialCursor != null) {
                if (cursor != null) {
                    try {
                        partialCursor.close();
                    }
                    catch (Throwable iter2) {
                        ((Throwable)cursor).addSuppressed(iter2);
                    }
                } else {
                    partialCursor.close();
                }
            }
        }
        ArrayList<Iterator> iters = new ArrayList<Iterator>();
        for (int i3 = 0; i3 < 200; ++i3) {
            iters.add(this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.randomizedQuery().setPageSize(12)).iterator());
        }
        while (!iters.isEmpty()) {
            Iterator iterIter = iters.iterator();
            while (iterIter.hasNext()) {
                iter2 = (Iterator)iterIter.next();
                for (i = 0; iter2.hasNext() && i < 20; ++i) {
                    iter2.next();
                }
                if (iter2.hasNext()) continue;
                iterIter.remove();
            }
        }
        this.checkConnectionLeaks(Ignition.allGrids().size());
        this.checkHoldQuery(node);
        this.checkShortQuery(node);
    }

    public void checkHoldQuery(final Ignite node) throws Exception {
        ArrayList rows = new ArrayList();
        Iterator it0 = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.query(50L).setPageSize(12)).iterator();
        rows.add((List<?>)it0.next());
        GridTestUtils.runMultiThreaded((Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 5; ++i) {
                    FieldsQueryCursor cursor = AbstractQueryTableLockAndConnectionPoolSelfTest.this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.query(489L).setPageSize(12));
                    cursor.getAll();
                }
            }
        }, (int)5, (String)"test-qry");
        FieldsQueryCursor<List<?>> cursor = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.query(50L).setPageSize(12));
        cursor.getAll();
        while (it0.hasNext()) {
            rows.add((List<?>)it0.next());
        }
        AbstractQueryTableLockAndConnectionPoolSelfTest.assertBaseQueryResults(rows);
    }

    public void checkShortQuery(Ignite node) throws Exception {
        ArrayList rows = new ArrayList();
        FieldsQueryCursor<List<?>> cursor0 = this.execute(node, AbstractQueryTableLockAndConnectionPoolSelfTest.query(489L).setPageSize(12));
        Iterator it = cursor0.iterator();
        while (it.hasNext()) {
            rows.add((List<?>)it.next());
        }
        AbstractQueryTableLockAndConnectionPoolSelfTest.assertQueryResults(rows, 489);
    }

    public void checkQuerySplitToSeveralMapQueries(Ignite node) throws Exception {
        ArrayList rows = new ArrayList();
        FieldsQueryCursor<List<?>> cursor0 = this.execute(node, new SqlFieldsQuery("SELECT pers.id, pers.name FROM (SELECT DISTINCT p.id, p.name FROM \"pers\".PERSON as p) as pers JOIN \"pers\".PERSON p on p.id = pers.id JOIN (SELECT t.persId as persId, SUM(t.time) totalTime FROM \"persTask\".PersonTask as t GROUP BY t.persId) as task ON task.persId = pers.id").setPageSize(12));
        Iterator it = cursor0.iterator();
        while (it.hasNext()) {
            rows.add((List<?>)it.next());
        }
        AbstractQueryTableLockAndConnectionPoolSelfTest.assertQueryResults(rows, 0);
    }

    private static void populateBaseQueryData(Ignite node, int parallelism) {
        node.createCache(AbstractQueryTableLockAndConnectionPoolSelfTest.cacheConfiguration(parallelism, "pers", Person.class));
        node.createCache(AbstractQueryTableLockAndConnectionPoolSelfTest.cacheConfiguration(parallelism, "persTask", PersonTask.class));
        IgniteCache<Long, Object> pers = AbstractQueryTableLockAndConnectionPoolSelfTest.cache(node, "pers");
        for (long i = 0L; i < 500L; ++i) {
            pers.put((Object)i, (Object)new Person(i));
        }
        IgniteCache<Long, Object> comp = AbstractQueryTableLockAndConnectionPoolSelfTest.cache(node, "persTask");
        for (long i = 0L; i < 500L; ++i) {
            comp.put((Object)i, (Object)new PersonTask(i));
        }
    }

    private static SqlFieldsQuery randomizedQuery() {
        return AbstractQueryTableLockAndConnectionPoolSelfTest.query(ThreadLocalRandom.current().nextInt(250));
    }

    private static SqlFieldsQuery baseQuery() {
        return AbstractQueryTableLockAndConnectionPoolSelfTest.query(50L);
    }

    private static CacheConfiguration<Long, Person> cacheConfiguration(int parallelism, String name, Class valClass) {
        return new CacheConfiguration().setName(name).setIndexedTypes(new Class[]{Long.class, valClass}).setQueryParallelism(parallelism).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10));
    }

    private static SqlFieldsQuery query(long arg) {
        return new SqlFieldsQuery("SELECT id, name FROM \"pers\".Person WHERE id >= " + arg);
    }

    private static void assertBaseQueryResults(List<List<?>> rows) {
        AbstractQueryTableLockAndConnectionPoolSelfTest.assertQueryResults(rows, 50);
    }

    private static void assertQueryResults(List<List<?>> rows, int resSize) {
        AbstractQueryTableLockAndConnectionPoolSelfTest.assertEquals((int)(500 - resSize), (int)rows.size());
        for (List<?> row : rows) {
            Long id = (Long)row.get(0);
            String name = (String)row.get(1);
            AbstractQueryTableLockAndConnectionPoolSelfTest.assertTrue((id >= (long)resSize ? 1 : 0) != 0);
            AbstractQueryTableLockAndConnectionPoolSelfTest.assertEquals((String)AbstractQueryTableLockAndConnectionPoolSelfTest.nameForId(id), (String)name);
        }
    }

    private static IgniteCache<Long, Object> cache(Ignite node, String name) {
        return node.cache(name);
    }

    private FieldsQueryCursor<List<?>> execute(Ignite node, String sql) {
        return ((IgniteEx)node).context().query().querySqlFields(new SqlFieldsQuery(sql).setLazy(this.lazy()), false);
    }

    private FieldsQueryCursor<List<?>> execute(Ignite node, SqlFieldsQuery qry) {
        return ((IgniteEx)node).context().query().querySqlFields(qry.setLazy(this.lazy()), false);
    }

    protected abstract boolean lazy();

    private static String nameForId(long id) {
        return "name-" + id;
    }

    private void checkConnectionLeaks(int nodeCnt) throws Exception {
        boolean notLeak = GridTestUtils.waitForCondition(() -> {
            for (int i = 0; i < nodeCnt; ++i) {
                if (this.usedConnections(i).isEmpty()) continue;
                return false;
            }
            return true;
        }, (long)5000L);
        if (!notLeak) {
            for (int i = 0; i < nodeCnt; ++i) {
                Set<H2PooledConnection> usedConns = this.usedConnections(i);
                if (this.usedConnections(i).isEmpty()) continue;
                log.error("Not closed connections: " + usedConns);
            }
            AbstractQueryTableLockAndConnectionPoolSelfTest.fail((String)"H2 JDBC connections leak detected. See the log above.");
        }
    }

    private Set<H2PooledConnection> usedConnections(int i) {
        ConnectionManager connMgr = ((IgniteH2Indexing)this.grid(i).context().query().getIndexing()).connections();
        return (Set)GridTestUtils.getFieldValue((Object)connMgr, (String[])new String[]{"usedConns"});
    }

    private static class PersonTask {
        @QuerySqlField(index=true)
        private long id;
        @QuerySqlField(index=true)
        private long persId;
        @QuerySqlField
        private long time;

        public PersonTask(long id) {
            this.id = id;
            this.persId = id;
            this.time = id;
        }

        public long id() {
            return this.id;
        }

        public long time() {
            return this.time;
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        private long id;
        @QuerySqlField
        private String name;

        public Person(long id) {
            this.id = id;
            this.name = AbstractQueryTableLockAndConnectionPoolSelfTest.nameForId(id);
        }

        public long id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }
    }
}

