/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteTwoRegionsRebuildIndexTest
extends GridCommonAbstractTest {
    private static final String PERSISTED_CACHE = "persisted";
    private static final String INMEMORY_CACHE = "inmemory";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        boolean client = igniteInstanceName.startsWith("client");
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        if (!client) {
            DataRegionConfiguration drCfg1 = new DataRegionConfiguration();
            drCfg1.setMaxSize(0x1800000L);
            drCfg1.setName("nopersistence");
            drCfg1.setInitialSize(drCfg1.getMaxSize());
            drCfg1.setPersistenceEnabled(false);
            DataRegionConfiguration drCfg2 = new DataRegionConfiguration();
            drCfg2.setMaxSize(0x1800000L);
            drCfg2.setName("persistence");
            drCfg2.setInitialSize(drCfg2.getMaxSize());
            drCfg2.setPersistenceEnabled(true);
            dsCfg.setDataRegionConfigurations(new DataRegionConfiguration[]{drCfg1, drCfg2});
            cfg.setDataStorageConfiguration(dsCfg);
        } else {
            CacheConfiguration ccfg1 = new CacheConfiguration(PERSISTED_CACHE);
            CacheConfiguration ccfg2 = new CacheConfiguration(INMEMORY_CACHE);
            ccfg1.setDataRegionName("persistence");
            ccfg2.setDataRegionName("nopersistence");
            cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
            cfg.setClientMode(true);
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testRebuildIndexes() throws Exception {
        this.startGrid("server");
        IgniteEx client = this.startGrid("client");
        client.cluster().active(true);
        this.populateData((Ignite)client, PERSISTED_CACHE);
        this.populateData((Ignite)client, INMEMORY_CACHE);
        this.stopGrid("server");
        this.startGrid("server");
        this.stopGrid("client");
        this.startGrid("client");
    }

    private void populateData(Ignite ignite, String cacheName) {
        try (IgniteDataStreamer streamer = ignite.dataStreamer(cacheName);){
            for (int i = 0; i < 1000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
            streamer.flush();
        }
    }
}

