/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.DeadlockProbe;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxyImpl;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.junit.After;
import org.junit.Test;

public class MvccDeadlockDetectionTest
extends GridCommonAbstractTest {
    private IgniteEx client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi()).setTransactionConfiguration(new TransactionConfiguration().setDeadlockTimeout(1L));
    }

    private void setUpGrids(int n, boolean indexed) throws Exception {
        Ignite ign = this.startGridsMultiThreaded(n);
        CacheConfiguration ccfg = new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
        if (indexed) {
            ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        }
        ign.getOrCreateCache(ccfg);
        G.setClientMode((boolean)true);
        this.client = this.startGrid(n);
    }

    @After
    public void cleanupTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void detectSimpleDeadlock() throws Exception {
        this.setUpGrids(2, false);
        Integer key0 = this.primaryKey(this.grid(0).cache("default"));
        Integer key1 = this.primaryKey(this.grid(1).cache("default"));
        IgniteCache cache = this.client.cache("default");
        assert (this.client.configuration().isClientMode().booleanValue());
        CyclicBarrier b = new CyclicBarrier(2);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put((Object)key0, (Object)0);
                b.await();
                cache.put((Object)key1, (Object)1);
                tx.commit();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put((Object)key1, (Object)1);
                b.await();
                cache.put((Object)key0, (Object)0);
                tx.commit();
            }
            return null;
        });
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1);
    }

    @Test
    public void detectSimpleDeadlockFastUpdate() throws Exception {
        this.setUpGrids(2, true);
        IgniteCache cache = this.client.cache("default");
        Integer key0 = this.primaryKey(this.grid(0).cache("default"));
        Integer key1 = this.primaryKey(this.grid(1).cache("default"));
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key0, -1}));
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key1, -1}));
        assert (this.client.configuration().isClientMode().booleanValue());
        CyclicBarrier b = new CyclicBarrier(2);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 0 where _key = ?").setArgs(new Object[]{key0}));
                b.await();
                cache.query(new SqlFieldsQuery("update Integer set _val = 0 where _key = ?").setArgs(new Object[]{key1}));
                tx.commit();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 1 where _key = ?").setArgs(new Object[]{key1}));
                b.await();
                cache.query(new SqlFieldsQuery("update Integer set _val = 1 where _key = ?").setArgs(new Object[]{key0}));
                tx.commit();
            }
            return null;
        });
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1);
    }

    @Test
    public void detect3Deadlock() throws Exception {
        this.setUpGrids(3, false);
        Integer key0 = this.primaryKey(this.grid(0).cache("default"));
        Integer key1 = this.primaryKey(this.grid(1).cache("default"));
        Integer key2 = this.primaryKey(this.grid(2).cache("default"));
        IgniteCache cache = this.client.cache("default");
        assert (this.client.configuration().isClientMode().booleanValue());
        CyclicBarrier b = new CyclicBarrier(3);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put((Object)key0, (Object)0);
                b.await();
                cache.put((Object)key1, (Object)1);
                tx.rollback();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put((Object)key1, (Object)0);
                b.await();
                cache.put((Object)key2, (Object)1);
                tx.rollback();
            }
            return null;
        });
        IgniteInternalFuture fut2 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put((Object)key2, (Object)1);
                b.await();
                cache.put((Object)key0, (Object)0);
                tx.rollback();
            }
            return null;
        });
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1, fut2);
    }

    @Test
    public void detectMultipleLockWaitDeadlock() throws Exception {
        this.setUpGrids(3, true);
        IgniteCache cache = this.client.cache("default");
        Integer key0 = this.primaryKey(this.grid(0).cache("default"));
        Integer key1 = this.primaryKey(this.grid(1).cache("default"));
        Integer key2 = this.primaryKey(this.grid(2).cache("default"));
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key0, -1}));
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key1, -1}));
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key2, -1}));
        CyclicBarrier b = new CyclicBarrier(3);
        IgniteInternalFuture fut2 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 2 where _key = ?").setArgs(new Object[]{key2}));
                b.await();
                cache.query(new SqlFieldsQuery("update Integer set _val = 2 where _key = ?").setArgs(new Object[]{key0}));
                tx.rollback();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 1 where _key = ?").setArgs(new Object[]{key1}));
                b.await();
                GridTestUtils.waitForCondition(() -> ((IgniteInternalFuture)fut2).isDone(), (long)1000L);
                tx.rollback();
            }
            return null;
        });
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 0 where _key = ?").setArgs(new Object[]{key0}));
                b.await();
                cache.query(new SqlFieldsQuery("update Integer set _val = 0 where _key = ? or _key = ?").setArgs(new Object[]{key2, key1}));
                tx.commit();
            }
            return null;
        });
        fut1.get(10L, TimeUnit.SECONDS);
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut2);
    }

    @Test
    public void detectDeadlockLocalEntriesEnlistFuture() throws Exception {
        this.setUpGrids(1, false);
        List keys = this.primaryKeys(this.grid(0).cache("default"), 2);
        IgniteCache cache = this.client.cache("default");
        assert (this.client.configuration().isClientMode().booleanValue());
        CyclicBarrier b = new CyclicBarrier(2);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put(keys.get(0), (Object)11);
                b.await();
                cache.put(keys.get(1), (Object)11);
                tx.commit();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put(keys.get(1), (Object)22);
                b.await();
                cache.put(keys.get(0), (Object)22);
                tx.commit();
            }
            return null;
        });
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1);
    }

    @Test
    public void detectDeadlockLocalPrimary() throws Exception {
        this.setUpGrids(2, false);
        IgniteCache cache0 = this.grid(0).cache("default");
        IgniteCache cache1 = this.grid(1).cache("default");
        int key0 = this.primaryKey(cache0);
        int key1 = this.primaryKey(cache1);
        CyclicBarrier b = new CyclicBarrier(2);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.grid(0).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache0.put((Object)key1, (Object)11);
                b.await();
                cache0.put((Object)key0, (Object)11);
                tx.commit();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.grid(1).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache1.put((Object)key0, (Object)22);
                b.await();
                cache1.put((Object)key1, (Object)22);
                tx.commit();
            }
            return null;
        });
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1);
    }

    @Test
    public void detectDeadlockLocalQueryEnlistFuture() throws Exception {
        this.setUpGrids(1, true);
        List keys = this.primaryKeys(this.grid(0).cache("default"), 2);
        Collections.sort(keys);
        Integer key0 = (Integer)keys.get(0);
        Integer key1 = (Integer)keys.get(1);
        IgniteCache cache = this.client.cache("default");
        assert (this.client.configuration().isClientMode().booleanValue());
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key0, -1}));
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, ?)").setArgs(new Object[]{key1, -1}));
        CyclicBarrier b = new CyclicBarrier(2);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 0 where _key <= ?").setArgs(new Object[]{key0}));
                b.await();
                cache.query(new SqlFieldsQuery("update Integer set _val = 0 where _key >= ?").setArgs(new Object[]{key1}));
                TimeUnit.SECONDS.sleep(2L);
                tx.commit();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.query(new SqlFieldsQuery("update Integer set _val = 1 where _key >= ?").setArgs(new Object[]{key1}));
                b.await();
                cache.query(new SqlFieldsQuery("update Integer set _val = 1 where _key <= ?").setArgs(new Object[]{key0}));
                tx.commit();
            }
            return null;
        });
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1);
    }

    @Test
    public void nonDeadlockedTxDetectsDeadlock1() throws Exception {
        this.setUpGrids(2, false);
        Integer key0 = this.primaryKey(this.grid(0).cache("default"));
        Integer key1 = this.primaryKey(this.grid(1).cache("default"));
        IgniteCache cache = this.client.cache("default");
        assert (this.client.configuration().isClientMode().booleanValue());
        CyclicBarrier b = new CyclicBarrier(3);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                MvccDeadlockDetectionTest.blockProbe(this.grid(1), tx);
                cache.put((Object)key0, (Object)0);
                b.await();
                cache.put((Object)key1, (Object)1);
                tx.rollback();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                MvccDeadlockDetectionTest.blockProbe(this.grid(0), tx);
                cache.put((Object)key1, (Object)1);
                b.await();
                cache.put((Object)key0, (Object)0);
                tx.rollback();
            }
            return null;
        });
        b.await();
        this.tryPutRepeatedly((IgniteCache<Object, Object>)cache, key0);
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1);
    }

    @Test
    public void nonDeadlockedTxDetectsDeadlock2() throws Exception {
        this.setUpGrids(2, false);
        List keys0 = this.primaryKeys(this.grid(0).cache("default"), 2);
        Integer key00 = (Integer)keys0.get(0);
        Integer key01 = (Integer)keys0.get(1);
        Integer key1 = this.primaryKey(this.grid(1).cache("default"));
        IgniteCache cache = this.client.cache("default");
        assert (this.client.configuration().isClientMode().booleanValue());
        CyclicBarrier b = new CyclicBarrier(3);
        IgniteInternalFuture fut0 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                MvccDeadlockDetectionTest.blockProbe(this.grid(1), tx);
                cache.put((Object)key00, (Object)0);
                b.await();
                cache.put((Object)key1, (Object)1);
                tx.rollback();
            }
            return null;
        });
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                MvccDeadlockDetectionTest.blockProbe(this.grid(0), tx);
                cache.put((Object)key1, (Object)1);
                cache.put((Object)key01, (Object)0);
                b.await();
                cache.put((Object)key00, (Object)0);
                tx.rollback();
            }
            return null;
        });
        b.await();
        this.tryPutRepeatedly((IgniteCache<Object, Object>)cache, key01);
        this.assertExactlyOneAbortedDueDeadlock(fut0, fut1);
    }

    @Test
    public void randomizedPuts() throws Exception {
        int gridCnt = GridTestUtils.SF.applyLB((int)10, (int)2);
        int opsByWorker = GridTestUtils.SF.applyLB((int)1000, (int)10);
        this.setUpGrids(gridCnt, false);
        ArrayList keys = new ArrayList();
        for (int i = 0; i < gridCnt; ++i) {
            keys.addAll(this.primaryKeys(this.grid(i).cache("default"), 3));
        }
        AtomicInteger aborted = new AtomicInteger();
        ArrayList<IgniteInternalFuture> futs = new ArrayList<IgniteInternalFuture>();
        for (int i = 0; i < gridCnt * 2; ++i) {
            IgniteEx ign = this.grid(i % gridCnt);
            IgniteCache cache = ign.cache("default");
            IgniteInternalFuture fut = GridTestUtils.runAsync(() -> {
                for (int k = 0; k < opsByWorker; ++k) {
                    try (Transaction tx = ign.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        ArrayList keys0 = new ArrayList(keys);
                        Collections.shuffle(keys0);
                        int nkeys = ThreadLocalRandom.current().nextInt(8) + 5;
                        for (int j = 0; j < nkeys; ++j) {
                            cache.put(keys0.get(j), (Object)j);
                        }
                        tx.rollback();
                        continue;
                    }
                    catch (Exception e) {
                        if (!X.hasCause((Throwable)e, (Class[])new Class[]{IgniteTxRollbackCheckedException.class})) continue;
                        aborted.incrementAndGet();
                    }
                }
            });
            futs.add(fut);
        }
        for (IgniteInternalFuture fut : futs) {
            fut.get(10L, TimeUnit.MINUTES);
        }
        log.info("Number of txs aborted: " + aborted);
    }

    private static void blockProbe(IgniteEx ign, Transaction tx) {
        ((TestRecordingCommunicationSpi)ign.configuration().getCommunicationSpi()).blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            if (msg instanceof DeadlockProbe) {
                DeadlockProbe msg0 = (DeadlockProbe)msg;
                GridNearTxLocal tx0 = ((TransactionProxyImpl)tx).tx();
                return msg0.initiatorVersion().equals((Object)tx0.xidVersion());
            }
            return false;
        });
    }

    private void assertExactlyOneAbortedDueDeadlock(IgniteInternalFuture<?> ... futs) throws IgniteCheckedException {
        assert (futs.length > 0);
        int aborted = 0;
        for (IgniteInternalFuture<?> fut : futs) {
            try {
                fut.get(10L, TimeUnit.SECONDS);
            }
            catch (IgniteCheckedException e) {
                if (X.hasCause((Throwable)e, (Class[])new Class[]{TransactionRollbackException.class})) {
                    ++aborted;
                    continue;
                }
                throw e;
            }
        }
        if (aborted != 1) {
            MvccDeadlockDetectionTest.fail((String)("Exactly one tx is expected to be aborted, but was " + aborted));
        }
    }

    private void tryPutRepeatedly(IgniteCache<Object, Object> cache, Integer key0) {
        for (int i = 0; i < 100; ++i) {
            try (Transaction tx = this.client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, 200L, 1);){
                cache.put((Object)key0, (Object)33);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
    }
}

