/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.junit.Test;

public class CacheMvccSizeTest
extends CacheMvccAbstractTest {
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    private void checkSizeModificationByOperation(String sql, boolean commit, int expSizeDelta) throws Exception {
        this.checkSizeModificationByOperation((IgniteCache<?, ?> c) -> {}, (IgniteCache<?, ?> cache) -> cache.query(CacheMvccSizeTest.q(sql, new Object[0])).getAll(), commit, expSizeDelta);
    }

    private void checkSizeModificationByOperation(String initSql, String sql, boolean commit, int expSizeDelta) throws Exception {
        this.checkSizeModificationByOperation((IgniteCache<?, ?> cache) -> cache.query(CacheMvccSizeTest.q(initSql, new Object[0])).getAll(), (IgniteCache<?, ?> cache) -> cache.query(CacheMvccSizeTest.q(sql, new Object[0])).getAll(), commit, expSizeDelta);
    }

    private void checkSizeModificationByOperation(Consumer<IgniteCache<?, ?>> inTx, boolean commit, int expSizeDelta) throws Exception {
        this.checkSizeModificationByOperation((IgniteCache<?, ?> c) -> {}, inTx, commit, expSizeDelta);
    }

    private void checkSizeModificationByOperation(Consumer<IgniteCache<?, ?>> beforeTx, Consumer<IgniteCache<?, ?>> inTx, boolean commit, int expSizeDelta) throws Exception {
        IgniteCache tbl0 = this.grid(0).cache("person");
        tbl0.query(CacheMvccSizeTest.q("delete from person", new Object[0]));
        beforeTx.accept(tbl0);
        int initSize = tbl0.size(new CachePeekMode[0]);
        tbl0.query(CacheMvccSizeTest.q("begin", new Object[0]));
        inTx.accept(tbl0);
        CacheMvccSizeTest.assertEquals((int)0, (int)(tbl0.size(new CachePeekMode[0]) - initSize));
        if (commit) {
            tbl0.query(CacheMvccSizeTest.q("commit", new Object[0]));
        } else {
            tbl0.query(CacheMvccSizeTest.q("rollback", new Object[0]));
        }
        CacheMvccSizeTest.assertEquals((int)expSizeDelta, (int)(tbl0.size(new CachePeekMode[0]) - initSize));
        CacheMvccSizeTest.assertEquals((int)tbl0.size(new CachePeekMode[0]), (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)tbl0.size(new CachePeekMode[0]), (int)tbl0.size(new CachePeekMode[]{CachePeekMode.BACKUP}));
        CacheMvccSizeTest.assertEquals((int)tbl0.size(new CachePeekMode[0]), (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[]{CachePeekMode.BACKUP}));
    }

    @Test
    public void testSql() throws Exception {
        this.startGridsMultiThreaded(2);
        CacheMvccSizeTest.createTable(this.grid(0));
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", true, 1);
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", false, 0);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0])), (IgniteCache<?, ?> personTbl) -> {
            try {
                personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
            }
            catch (Exception e) {
                if (e.getCause() instanceof TransactionDuplicateKeyException) {
                    CacheMvccSizeTest.assertTrue((boolean)e.getMessage().startsWith("Duplicate key during INSERT ["));
                }
                e.printStackTrace();
                CacheMvccSizeTest.fail((String)"Unexpected exceptions");
            }
        }, false, 0);
        this.checkSizeModificationByOperation("merge into person(id, name) values(1, 'a')", true, 1);
        this.checkSizeModificationByOperation("merge into person(id, name) values(1, 'a')", false, 0);
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", "merge into person(id, name) values(1, 'b')", true, 0);
        this.checkSizeModificationByOperation("update person set name = 'b' where id = 1", true, 0);
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", "update person set name = 'b' where id = 1", true, 0);
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", "delete from person where id = 1", true, -1);
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", "delete from person where id = 1", false, 0);
        this.checkSizeModificationByOperation("delete from person where id = 1", true, 0);
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", "select * from person", true, 0);
        this.checkSizeModificationByOperation("select * from person", true, 0);
        this.checkSizeModificationByOperation("insert into person values(1, 'a')", "select * from person where id = 1 for update", true, 0);
        this.checkSizeModificationByOperation("select * from person where id = 1 for update", true, 0);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> {
            personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("insert into person values(%d, 'b')", CacheMvccSizeTest.keyInSamePartition((Ignite)this.grid(0), "person", 1)));
            personTbl.query(CacheMvccSizeTest.q("insert into person values(%d, 'c')", CacheMvccSizeTest.keyInDifferentPartition((Ignite)this.grid(0), "person", 1)));
        }, true, 3);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> {
            personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
        }, true, 0);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> {
            personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
        }, true, 1);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0])), (IgniteCache<?, ?> personTbl) -> {
            personTbl.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
        }, true, 0);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> {
            personTbl.query(CacheMvccSizeTest.q("merge into person(id, name) values(1, 'a')", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
        }, true, 0);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> {
            personTbl.query(CacheMvccSizeTest.q("merge into person(id, name) values(1, 'a')", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("merge into person(id, name) values(1, 'a')", new Object[0]));
        }, true, 1);
        this.checkSizeModificationByOperation((IgniteCache<?, ?> personTbl) -> personTbl.query(CacheMvccSizeTest.q("merge into person(id, name) values(1, 'a')", new Object[0])), (IgniteCache<?, ?> personTbl) -> {
            personTbl.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
            personTbl.query(CacheMvccSizeTest.q("merge into person(id, name) values(1, 'a')", new Object[0]));
        }, true, 0);
    }

    @Test
    public void testInsertDeleteConcurrent() throws Exception {
        this.startGridsMultiThreaded(2);
        IgniteCache<?, ?> tbl0 = CacheMvccSizeTest.createTable(this.grid(0));
        SqlFieldsQuery insert = new SqlFieldsQuery("insert into person(id, name) values(?, 'a')");
        SqlFieldsQuery delete = new SqlFieldsQuery("delete from person where id = ?");
        CompletableFuture<Integer> insertFut = CompletableFuture.supplyAsync(() -> {
            int cnt = 0;
            for (int i = 0; i < 1000; ++i) {
                cnt += this.update(insert.setArgs(new Object[]{ThreadLocalRandom.current().nextInt(10)}), tbl0);
            }
            return cnt;
        });
        CompletableFuture<Integer> deleteFut = CompletableFuture.supplyAsync(() -> {
            int cnt = 0;
            for (int i = 0; i < 1000; ++i) {
                cnt += this.update(delete.setArgs(new Object[]{ThreadLocalRandom.current().nextInt(10)}), tbl0);
            }
            return cnt;
        });
        int expSize = insertFut.join() - deleteFut.join();
        CacheMvccSizeTest.assertEquals((int)expSize, (int)tbl0.size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)expSize, (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)expSize, (int)tbl0.size(new CachePeekMode[]{CachePeekMode.BACKUP}));
        CacheMvccSizeTest.assertEquals((int)expSize, (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[]{CachePeekMode.BACKUP}));
    }

    private int update(SqlFieldsQuery qry, IgniteCache<?, ?> cache) {
        try {
            return Integer.parseInt(((List)cache.query(qry).getAll().get(0)).get(0).toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Test
    public void testWriteConflictDoesNotChangeSize() throws Exception {
        this.startGridsMultiThreaded(2);
        IgniteCache<?, ?> tbl0 = CacheMvccSizeTest.createTable(this.grid(0));
        tbl0.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
        tbl0.query(CacheMvccSizeTest.q("begin", new Object[0]));
        tbl0.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
        CompletableFuture conflictingStarted = new CompletableFuture();
        CompletableFuture<Void> fut = CompletableFuture.runAsync(() -> {
            tbl0.query(CacheMvccSizeTest.q("begin", new Object[0]));
            try {
                tbl0.query(CacheMvccSizeTest.q("select * from person", new Object[0])).getAll();
                conflictingStarted.complete(null);
                tbl0.query(CacheMvccSizeTest.q("merge into person(id, name) values(1, 'b')", new Object[0]));
            }
            finally {
                tbl0.query(CacheMvccSizeTest.q("commit", new Object[0]));
            }
        });
        conflictingStarted.join();
        tbl0.query(CacheMvccSizeTest.q("commit", new Object[0]));
        try {
            fut.join();
        }
        catch (Exception e) {
            if (e.getCause().getCause() instanceof IgniteSQLException) {
                CacheMvccSizeTest.assertTrue((boolean)e.getMessage().contains("Failed to finish transaction because it has been rolled back"));
            }
            e.printStackTrace();
            CacheMvccSizeTest.fail((String)"Unexpected exception");
        }
        CacheMvccSizeTest.assertEquals((int)0, (int)tbl0.size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)0, (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)0, (int)tbl0.size(new CachePeekMode[]{CachePeekMode.BACKUP}));
        CacheMvccSizeTest.assertEquals((int)0, (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[]{CachePeekMode.BACKUP}));
    }

    @Test
    public void testDeleteChangesSizeAfterUnlock() throws Exception {
        this.startGridsMultiThreaded(2);
        IgniteCache<?, ?> tbl0 = CacheMvccSizeTest.createTable(this.grid(0));
        tbl0.query(CacheMvccSizeTest.q("insert into person values(1, 'a')", new Object[0]));
        tbl0.query(CacheMvccSizeTest.q("begin", new Object[0]));
        tbl0.query(CacheMvccSizeTest.q("select * from person where id = 1 for update", new Object[0])).getAll();
        CompletableFuture asyncThread = new CompletableFuture();
        CompletableFuture<Void> fut = CompletableFuture.runAsync(() -> {
            tbl0.query(CacheMvccSizeTest.q("begin", new Object[0]));
            try {
                tbl0.query(CacheMvccSizeTest.q("select * from person", new Object[0])).getAll();
                asyncThread.complete(Thread.currentThread());
                tbl0.query(CacheMvccSizeTest.q("delete from person where id = 1", new Object[0]));
            }
            finally {
                tbl0.query(CacheMvccSizeTest.q("commit", new Object[0]));
            }
        });
        Thread concThread = (Thread)asyncThread.join();
        while (concThread.getState() == Thread.State.RUNNABLE && !Thread.currentThread().isInterrupted()) {
        }
        tbl0.query(CacheMvccSizeTest.q("commit", new Object[0]));
        fut.join();
        CacheMvccSizeTest.assertEquals((int)0, (int)tbl0.size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)0, (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)0, (int)tbl0.size(new CachePeekMode[]{CachePeekMode.BACKUP}));
        CacheMvccSizeTest.assertEquals((int)0, (int)CacheMvccSizeTest.table(this.grid(1)).size(new CachePeekMode[]{CachePeekMode.BACKUP}));
    }

    @Test
    public void testDataStreamerModifiesReplicatedCacheSize() throws Exception {
        this.startGridsMultiThreaded(2);
        IgniteEx ignite = this.grid(0);
        ignite.createCache(new CacheConfiguration("test").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED));
        try (IgniteDataStreamer streamer = ignite.dataStreamer("test");){
            streamer.addData((Object)1, (Object)"a");
            streamer.addData((Object)CacheMvccSizeTest.keyInDifferentPartition((Ignite)ignite, "test", 1), (Object)"b");
        }
        CacheMvccSizeTest.assertEquals((int)2, (int)ignite.cache("test").size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)1, (int)this.grid(0).cache("test").localSize(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)1, (int)this.grid(0).cache("test").localSize(new CachePeekMode[]{CachePeekMode.BACKUP}));
        CacheMvccSizeTest.assertEquals((int)1, (int)this.grid(1).cache("test").localSize(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)1, (int)this.grid(1).cache("test").localSize(new CachePeekMode[]{CachePeekMode.BACKUP}));
    }

    @Test
    public void testSizeIsConsistentAfterRebalance() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        IgniteCache<?, ?> tbl = CacheMvccSizeTest.createTable(ignite);
        for (int i = 0; i < 100; ++i) {
            tbl.query(CacheMvccSizeTest.q("insert into person values(?, ?)", new Object[0]).setArgs(new Object[]{i, i}));
        }
        this.startGrid(1);
        this.awaitPartitionMapExchange();
        IgniteCache tbl0 = this.grid(0).cache("person");
        IgniteCache tbl1 = this.grid(1).cache("person");
        assert (tbl0.localSize(new CachePeekMode[0]) != 0 && tbl1.localSize(new CachePeekMode[0]) != 0);
        CacheMvccSizeTest.assertEquals((int)100, (int)tbl1.size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)100, (int)(tbl0.localSize(new CachePeekMode[0]) + tbl1.localSize(new CachePeekMode[0])));
    }

    @Test
    public void testSizeIsConsistentAfterRebalanceDuringInsert() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        IgniteCache<?, ?> tbl = CacheMvccSizeTest.createTable(ignite);
        Future f = null;
        for (int i = 0; i < 100; ++i) {
            if (i == 50) {
                f = ForkJoinPool.commonPool().submit(() -> this.startGrid(1));
            }
            tbl.query(CacheMvccSizeTest.q("insert into person values(?, ?)", new Object[0]).setArgs(new Object[]{i, i}));
        }
        f.get();
        this.awaitPartitionMapExchange();
        IgniteCache tbl0 = this.grid(0).cache("person");
        IgniteCache tbl1 = this.grid(1).cache("person");
        assert (tbl0.localSize(new CachePeekMode[0]) != 0 && tbl1.localSize(new CachePeekMode[0]) != 0);
        CacheMvccSizeTest.assertEquals((int)100, (int)tbl1.size(new CachePeekMode[0]));
        CacheMvccSizeTest.assertEquals((int)100, (int)(tbl0.localSize(new CachePeekMode[0]) + tbl1.localSize(new CachePeekMode[0])));
    }

    private static IgniteCache<?, ?> table(IgniteEx ignite) {
        assert (ignite.cachex("person").configuration().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
        assert (ignite.cachex("person").configuration().getCacheMode() == CacheMode.REPLICATED);
        return ignite.cache("person");
    }

    private static IgniteCache<?, ?> createTable(IgniteEx ignite) {
        IgniteCache sqlNexus = ignite.getOrCreateCache(new CacheConfiguration("sqlNexus").setSqlSchema("PUBLIC"));
        sqlNexus.query(CacheMvccSizeTest.q("create table person(  id int primary key,  name varchar) with \"atomicity=transactional_snapshot,template=replicated,cache_name=person\"", new Object[0]));
        return CacheMvccSizeTest.table(ignite);
    }

    private static SqlFieldsQuery q(String fSql, Object ... args) {
        return new SqlFieldsQuery(String.format(fSql, args));
    }

    private static int keyInSamePartition(Ignite ignite, String cacheName, int key) {
        Affinity affinity = ignite.affinity(cacheName);
        return IntStream.iterate(key + 1, i -> i + 1).filter(i -> affinity.partition((Object)i) == affinity.partition((Object)key)).findFirst().getAsInt();
    }

    private static int keyInDifferentPartition(Ignite ignite, String cacheName, int key) {
        Affinity affinity = ignite.affinity(cacheName);
        return IntStream.iterate(key + 1, i -> i + 1).filter(i -> affinity.partition((Object)i) != affinity.partition((Object)key)).findFirst().getAsInt();
    }
}

