/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.Person;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.index.AbstractRebuildIndexTest;
import org.apache.ignite.internal.processors.cache.index.IgniteH2IndexingEx;
import org.apache.ignite.internal.processors.cache.index.IndexingTestUtils;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusHolder;
import org.apache.ignite.internal.util.function.ThrowableFunction;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class ResumeRebuildIndexTest
extends AbstractRebuildIndexTest {
    @Test
    public void testNormalFlowIndexRebuildStateStorage() throws Exception {
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 1000);
        GridCacheContext cacheCtx = n.cachex("default").context();
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, cacheCtx.name());
        this.dbMgr(n).enableCheckpoints(false).get(this.getTestTimeout());
        ResumeRebuildIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}).isEmpty());
        IgniteInternalFuture idxRebFut = this.indexRebuildFuture(n, cacheCtx.cacheId());
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        ResumeRebuildIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut.get(this.getTestTimeout());
        ResumeRebuildIndexTest.assertEquals((long)1000L, (long)stopRebuildIdxConsumer.visitCnt.get());
        ResumeRebuildIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        this.dbMgr(n).enableCheckpoints(true).get(this.getTestTimeout());
        this.forceCheckpoint();
        ResumeRebuildIndexTest.assertNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
    }

    @Test
    public void testErrorFlowIndexRebuildStateStorage() throws Exception {
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 1000);
        GridCacheContext cacheCtx = n.cachex("default").context();
        IndexingTestUtils.BreakBuildIndexConsumer breakRebuildIdxConsumer = this.addBreakRebuildIndexConsumer(n, cacheCtx.name(), 10);
        ResumeRebuildIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}).isEmpty());
        IgniteInternalFuture idxRebFut0 = this.indexRebuildFuture(n, cacheCtx.cacheId());
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        ResumeRebuildIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
        breakRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        breakRebuildIdxConsumer.finishBuildIdxFut.onDone();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> idxRebFut0.get(this.getTestTimeout()), Throwable.class, null);
        ResumeRebuildIndexTest.assertTrue((breakRebuildIdxConsumer.visitCnt.get() < 1000L ? 1 : 0) != 0);
        this.forceCheckpoint();
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        ResumeRebuildIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, cacheCtx.name());
        this.dbMgr(n).enableCheckpoints(false).get(this.getTestTimeout());
        ResumeRebuildIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}).isEmpty());
        IgniteInternalFuture idxRebFut1 = this.indexRebuildFuture(n, cacheCtx.cacheId());
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        ResumeRebuildIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut1.get(this.getTestTimeout());
        ResumeRebuildIndexTest.assertEquals((long)1000L, (long)stopRebuildIdxConsumer.visitCnt.get());
        ResumeRebuildIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        this.dbMgr(n).enableCheckpoints(true).get(this.getTestTimeout());
        this.forceCheckpoint();
        ResumeRebuildIndexTest.assertNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
    }

    @Test
    public void testRestartNodeFlowIndexRebuildStateStorage() throws Exception {
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 1000);
        GridCacheContext cacheCtx = n.cachex("default").context();
        IndexingTestUtils.BreakBuildIndexConsumer breakRebuildIdxConsumer = this.addBreakRebuildIndexConsumer(n, cacheCtx.name(), 10);
        ResumeRebuildIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}).isEmpty());
        IgniteInternalFuture idxRebFut0 = this.indexRebuildFuture(n, cacheCtx.cacheId());
        breakRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        breakRebuildIdxConsumer.finishBuildIdxFut.onDone();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> idxRebFut0.get(this.getTestTimeout()), Throwable.class, null);
        this.forceCheckpoint();
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        ResumeRebuildIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
        this.stopAllGrids();
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, cacheCtx.name());
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        n = this.startGrid(0);
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        ResumeRebuildIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        IgniteInternalFuture idxRebFut1 = this.indexRebuildFuture(n, cacheCtx.cacheId());
        this.dbMgr(n).enableCheckpoints(false).get(this.getTestTimeout());
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut1.get(this.getTestTimeout());
        ResumeRebuildIndexTest.assertEquals((long)1000L, (long)stopRebuildIdxConsumer.visitCnt.get());
        ResumeRebuildIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheCtx.name()));
        ResumeRebuildIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
        this.dbMgr(n).enableCheckpoints(true).get(this.getTestTimeout());
        this.forceCheckpoint();
        ResumeRebuildIndexTest.assertNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheCtx.name())));
    }

    @Test
    public void testSingleNodeRestart() throws Exception {
        this.checkRestartRebuildIndexes(1, (ThrowableFunction<IgniteEx, IgniteEx, Exception>)((ThrowableFunction)n -> {
            this.stopAllGrids();
            IgniteH2IndexingEx.prepareBeforeNodeStart();
            return this.startGrid(0);
        }));
    }

    @Test
    public void testSingleNodeReactivation() throws Exception {
        this.checkRestartRebuildIndexes(1, (ThrowableFunction<IgniteEx, IgniteEx, Exception>)((ThrowableFunction)n -> {
            n.cluster().state(ClusterState.INACTIVE);
            n.cluster().state(ClusterState.ACTIVE);
            return n;
        }));
    }

    @Test
    public void testTwoNodeRestart() throws Exception {
        this.checkRestartRebuildIndexes(2, (ThrowableFunction<IgniteEx, IgniteEx, Exception>)((ThrowableFunction)n -> {
            String nodeName = n.name();
            this.stopGrid(nodeName);
            IgniteH2IndexingEx.prepareBeforeNodeStart();
            return this.startGrid(nodeName);
        }));
    }

    @Test
    public void testTwoNodeReactivation() throws Exception {
        this.checkRestartRebuildIndexes(2, (ThrowableFunction<IgniteEx, IgniteEx, Exception>)((ThrowableFunction)n -> {
            n.cluster().state(ClusterState.INACTIVE);
            n.cluster().state(ClusterState.ACTIVE);
            return n;
        }));
    }

    @Test
    public void testDeleteIndexRebuildStateOnDestroyCache() throws Exception {
        IgniteEx n0 = this.startGrid(this.getTestIgniteInstanceName(0));
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n1 = this.startGrid(this.getTestIgniteInstanceName(1));
        n0.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        for (int i = 0; i < 4; ++i) {
            String cacheName = "default" + i;
            String grpName = i == 1 || i == 2 ? "default_G" : null;
            this.populate((IgniteCache<Integer, Person>)n1.getOrCreateCache(this.cacheCfg(cacheName, grpName)), 10000);
            IndexingTestUtils.BreakBuildIndexConsumer breakRebuildIdxConsumer = this.addBreakRebuildIndexConsumer(n1, cacheName, 10);
            IgniteInternalCache cachex = n1.cachex(cacheName);
            int cacheSize = cachex.size();
            ResumeRebuildIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n1, new GridCacheContext[]{cachex.context()}).isEmpty());
            IgniteInternalFuture rebIdxFut = this.indexRebuildFuture(n1, cachex.context().cacheId());
            breakRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
            breakRebuildIdxConsumer.finishBuildIdxFut.onDone();
            GridTestUtils.assertThrows((IgniteLogger)log, () -> rebIdxFut.get(this.getTestTimeout()), Throwable.class, null);
            ResumeRebuildIndexTest.assertTrue((breakRebuildIdxConsumer.visitCnt.get() < (long)cacheSize ? 1 : 0) != 0);
        }
        n1.destroyCache("default0");
        ResumeRebuildIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n1).rebuildCompleted("default0"));
        n1.destroyCache("default1");
        ResumeRebuildIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n1).rebuildCompleted("default1"));
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n1).rebuildCompleted("default2"));
        ResumeRebuildIndexTest.assertFalse((boolean)this.indexBuildStatusStorage(n1).rebuildCompleted("default3"));
        this.forceCheckpoint((Ignite)n1);
        ConcurrentMap<String, IndexBuildStatusHolder> states = this.statuses(n1);
        ResumeRebuildIndexTest.assertFalse((boolean)states.containsKey("default0"));
        ResumeRebuildIndexTest.assertFalse((boolean)states.containsKey("default1"));
        ResumeRebuildIndexTest.assertTrue((boolean)states.containsKey("default2"));
        ResumeRebuildIndexTest.assertTrue((boolean)states.containsKey("default3"));
        this.stopGrid(1);
        this.awaitPartitionMapExchange();
        n0.destroyCache("default2");
        n0.destroyCache("default3");
        GridTestUtils.deleteCacheGrpDir((String)n1.name(), (dir, name) -> name.contains("default3") || name.contains("default_G"));
        n1 = this.startGrid(this.getTestIgniteInstanceName(1));
        ResumeRebuildIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n1).rebuildCompleted("default2"));
        ResumeRebuildIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n1).rebuildCompleted("default3"));
        this.forceCheckpoint((Ignite)n1);
        states = this.statuses(n1);
        ResumeRebuildIndexTest.assertFalse((boolean)states.containsKey("default2"));
        ResumeRebuildIndexTest.assertFalse((boolean)states.containsKey("default3"));
    }

    private void checkRestartRebuildIndexes(int nodeCnt, ThrowableFunction<IgniteEx, IgniteEx, Exception> function) throws Exception {
        ResumeRebuildIndexTest.assertTrue((nodeCnt > 0 ? 1 : 0) != 0);
        for (int i = 0; i < nodeCnt - 1; ++i) {
            this.startGrid(this.getTestIgniteInstanceName(i + 1));
        }
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 10000);
        this.populate((IgniteCache<Integer, Person>)n.getOrCreateCache(this.cacheCfg("default0", null)), 10000);
        if (nodeCnt > 1) {
            this.awaitPartitionMapExchange();
        }
        IgniteInternalCache cachex0 = n.cachex("default");
        IgniteInternalCache cachex1 = n.cachex("default0");
        int cacheSize0 = cachex0.size();
        int cacheSize1 = cachex1.size();
        ResumeRebuildIndexTest.assertTrue((String)String.valueOf(cacheSize0), (cacheSize0 >= 1000 ? 1 : 0) != 0);
        ResumeRebuildIndexTest.assertTrue((String)String.valueOf(cacheSize1), (cacheSize1 >= 1000 ? 1 : 0) != 0);
        GridCacheContext cacheCtx0 = cachex0.context();
        GridCacheContext cacheCtx1 = cachex1.context();
        IndexingTestUtils.BreakBuildIndexConsumer breakRebuildIdxConsumer = this.addBreakRebuildIndexConsumer(n, cacheCtx0.name(), 10);
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer0 = this.addStopRebuildIndexConsumer(n, cacheCtx1.name());
        ResumeRebuildIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx0, cacheCtx1}).isEmpty());
        IgniteInternalFuture rebIdxFut0 = this.indexRebuildFuture(n, cacheCtx0.cacheId());
        IgniteInternalFuture rebIdxFut1 = this.indexRebuildFuture(n, cacheCtx1.cacheId());
        breakRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        breakRebuildIdxConsumer.finishBuildIdxFut.onDone();
        stopRebuildIdxConsumer0.startBuildIdxFut.get(this.getTestTimeout());
        stopRebuildIdxConsumer0.finishBuildIdxFut.onDone();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> rebIdxFut0.get(this.getTestTimeout()), Throwable.class, null);
        ResumeRebuildIndexTest.assertTrue((breakRebuildIdxConsumer.visitCnt.get() < (long)cacheSize0 ? 1 : 0) != 0);
        rebIdxFut1.get(this.getTestTimeout());
        ResumeRebuildIndexTest.assertEquals((long)cacheSize1, (long)stopRebuildIdxConsumer0.visitCnt.get());
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer1 = this.addStopRebuildIndexConsumer(n, cacheCtx0.name());
        stopRebuildIdxConsumer0.resetFutures();
        this.forceCheckpoint();
        n = (IgniteEx)function.apply((Object)n);
        IgniteInternalFuture rebIdxFut01 = this.indexRebuildFuture(n, cacheCtx0.cacheId());
        IgniteInternalFuture rebIdxFut11 = this.indexRebuildFuture(n, cacheCtx1.cacheId());
        stopRebuildIdxConsumer1.startBuildIdxFut.get(this.getTestTimeout());
        stopRebuildIdxConsumer1.finishBuildIdxFut.onDone();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)stopRebuildIdxConsumer0.startBuildIdxFut.get(1000L), IgniteFutureTimeoutCheckedException.class, null);
        stopRebuildIdxConsumer0.finishBuildIdxFut.onDone();
        rebIdxFut01.get(this.getTestTimeout());
        ResumeRebuildIndexTest.assertEquals((long)cacheSize0, (long)stopRebuildIdxConsumer1.visitCnt.get());
        ResumeRebuildIndexTest.assertNull((Object)rebIdxFut11);
        ResumeRebuildIndexTest.assertEquals((long)cacheSize1, (long)stopRebuildIdxConsumer0.visitCnt.get());
    }
}

