/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.Person;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.IndexRenameRootPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.index.AbstractRebuildIndexTest;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class RenameIndexTreeTest
extends AbstractRebuildIndexTest {
    @Test
    public void testRenamingIndexRootPage() throws Exception {
        IgniteEx n = this.startGrid(0);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        int segments = idx.segmentsCount();
        String oldTreeName = this.treeName(idx);
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, segments, true);
        String newTreeName = UUID.randomUUID().toString();
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, newTreeName, segments, false);
        RenameIndexTreeTest.assertTrue((boolean)this.renameIndexRoot((IgniteCache<Integer, Person>)cache, newTreeName, newTreeName, segments).isEmpty());
        String moreMaxLenName = Arrays.toString(new byte[256]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.renameIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, moreMaxLenName, segments), Exception.class, null);
        RenameIndexTreeTest.assertEquals((int)segments, (int)this.renameIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, newTreeName, segments).size());
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, segments, false);
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, newTreeName, segments, true);
    }

    @Test
    public void testPersistRenamingIndexRootPage() throws Exception {
        IgniteEx n = this.startGrid(0);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        String oldTreeName = this.treeName(idx);
        String newTreeName = UUID.randomUUID().toString();
        int segments = idx.segmentsCount();
        RenameIndexTreeTest.assertEquals((int)segments, (int)this.renameIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, newTreeName, segments).size());
        this.forceCheckpoint();
        this.stopGrid(0);
        n = this.startGrid(0);
        cache = n.cache("default");
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, segments, true);
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, newTreeName, segments, true);
    }

    @Test
    public void testNotPersistRenamingIndexRootPage() throws Exception {
        IgniteEx n = this.startGrid(0);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        this.enableCheckpoints(n, this.getTestIgniteInstanceName(), false);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        String oldTreeName = this.treeName(idx);
        String newTreeName = UUID.randomUUID().toString();
        int segments = idx.segmentsCount();
        RenameIndexTreeTest.assertEquals((int)segments, (int)this.renameIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, newTreeName, segments).size());
        this.stopGrid(0);
        n = this.startGrid(0);
        cache = n.cache("default");
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, segments, true);
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, newTreeName, segments, false);
    }

    @Test
    public void testIndexRenameRootPageRecord() throws Exception {
        IgniteEx n = this.startGrid(0);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        this.enableCheckpoints(n, this.getTestIgniteInstanceName(), false);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        String oldTreeName = this.treeName(idx);
        String newTreeName = UUID.randomUUID().toString();
        int segments = idx.segmentsCount();
        int cacheId = GridTestUtils.cacheContext((IgniteCache)cache).cacheId();
        IndexRenameRootPageRecord r = new IndexRenameRootPageRecord(cacheId, oldTreeName, newTreeName, segments);
        RenameIndexTreeTest.walMgr((IgniteEx)n).log((WALRecord)r);
        Set cacheIds = n.context().cache().cacheNames().stream().map(GridCacheUtils::cacheId).collect(Collectors.toSet());
        int fakeCacheId = cacheIds.stream().mapToInt(Integer::intValue).sum();
        while (cacheIds.contains(fakeCacheId)) {
            ++fakeCacheId;
        }
        RenameIndexTreeTest.walMgr((IgniteEx)n).log((WALRecord)new IndexRenameRootPageRecord(fakeCacheId, oldTreeName, newTreeName, segments));
        this.stopGrid(0);
        n = this.startGrid(0);
        cache = n.cache("default");
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, segments, false);
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, newTreeName, segments, true);
    }

    @Test
    public void testRenameFromTask() throws Exception {
        IgniteEx n = this.startGrid(0);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        GridCacheContext cctx = GridTestUtils.cacheContext((IgniteCache)cache);
        String oldTreeName = this.treeName(idx);
        int segments = idx.segmentsCount();
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, segments, true);
        Map<Integer, RootPage> rootPages0 = this.findIndexRoots((IgniteCache<Integer, Person>)cache, oldTreeName, segments);
        Map rootPages1 = DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)oldTreeName, (int)segments);
        RenameIndexTreeTest.assertEqualsCollections(this.toPageIds(rootPages0), this.toPageIds(rootPages1));
        long currSegIdx = RenameIndexTreeTest.walMgr((IgniteEx)n).currentSegment();
        String newTreeName = UUID.randomUUID().toString();
        DurableBackgroundCleanupIndexTreeTaskV2.renameIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)oldTreeName, (String)newTreeName, (int)segments);
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, oldTreeName, segments, false);
        this.assertExistIndexRoot((IgniteCache<Integer, Person>)cache, newTreeName, segments, true);
        RenameIndexTreeTest.assertTrue((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)oldTreeName, (int)segments).isEmpty());
        rootPages0 = this.findIndexRoots((IgniteCache<Integer, Person>)cache, newTreeName, segments);
        rootPages1 = DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)newTreeName, (int)segments);
        RenameIndexTreeTest.assertEqualsCollections(this.toPageIds(rootPages0), this.toPageIds(rootPages1));
        FileWALPointer start = new FileWALPointer(currSegIdx, 0, 0);
        IgniteBiPredicate & Serializable pred = (IgniteBiPredicate & Serializable)(t, p) -> t == WALRecord.RecordType.INDEX_ROOT_PAGE_RENAME_RECORD;
        try (WALIterator it = RenameIndexTreeTest.walMgr((IgniteEx)n).replay((WALPointer)start, (IgniteBiPredicate)pred);){
            List records = StreamSupport.stream(it.spliterator(), false).map(IgniteBiTuple::get2).collect(Collectors.toList());
            RenameIndexTreeTest.assertEquals((int)1, (int)records.size());
            IndexRenameRootPageRecord record = (IndexRenameRootPageRecord)records.get(0);
            RenameIndexTreeTest.assertEquals((int)cctx.cacheId(), (int)record.cacheId());
            RenameIndexTreeTest.assertEquals((String)oldTreeName, (String)record.oldTreeName());
            RenameIndexTreeTest.assertEquals((String)newTreeName, (String)record.newTreeName());
            RenameIndexTreeTest.assertEquals((int)segments, (int)record.segments());
        }
    }

    @Test
    public void testRenameBeforeRunningTask() throws Exception {
        IgniteEx n = this.startGrid(0);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        GridCacheContext cctx = GridTestUtils.cacheContext((IgniteCache)cache);
        String oldTreeName = this.treeName(idx);
        H2Tree[] segments = (H2Tree[])GridTestUtils.getFieldValue((Object)idx, (String[])new String[]{"segments"});
        DurableBackgroundCleanupIndexTreeTaskV2 task = new DurableBackgroundCleanupIndexTreeTaskV2(cctx.group().name(), cctx.name(), idxName, oldTreeName, UUID.randomUUID().toString(), segments.length, segments);
        RenameIndexTreeTest.assertTrue((boolean)task.needToRename());
        task.renameIndexTrees(cctx.group());
        RenameIndexTreeTest.assertFalse((boolean)task.needToRename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RootPage> renameIndexRoot(IgniteCache<Integer, Person> cache, String oldTreeName, String newTreeName, int segments) throws Exception {
        GridCacheContext cacheCtx = GridTestUtils.cacheContext(cache);
        ArrayList<RootPage> res = new ArrayList<RootPage>();
        cacheCtx.shared().database().checkpointReadLock();
        try {
            for (int i = 0; i < segments; ++i) {
                RootPage rootPage = cacheCtx.offheap().renameRootPageForIndex(cacheCtx.cacheId(), oldTreeName, newTreeName, i);
                if (rootPage == null) continue;
                res.add(rootPage);
            }
        }
        finally {
            cacheCtx.shared().database().checkpointReadUnlock();
        }
        return res;
    }

    private void assertExistIndexRoot(IgniteCache<Integer, Person> cache, String treeName, int segments, boolean expExist) throws Exception {
        Map<Integer, RootPage> rootPages = this.findIndexRoots(cache, treeName, segments);
        for (int i = 0; i < segments; ++i) {
            RenameIndexTreeTest.assertEquals((boolean)expExist, (boolean)rootPages.containsKey(i));
        }
    }

    private Map<Integer, RootPage> findIndexRoots(IgniteCache<Integer, Person> cache, String treeName, int segments) throws Exception {
        GridCacheContext cacheCtx = GridTestUtils.cacheContext(cache);
        HashMap<Integer, RootPage> rootPages = new HashMap<Integer, RootPage>();
        for (int i = 0; i < segments; ++i) {
            RootPage rootPage = cacheCtx.offheap().findRootPageForIndex(cacheCtx.cacheId(), treeName, i);
            if (rootPage == null) continue;
            rootPages.put(i, rootPage);
        }
        return rootPages;
    }

    private Collection<FullPageId> toPageIds(Map<Integer, RootPage> rootPages) {
        return rootPages.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> ((RootPage)e.getValue()).pageId()).collect(Collectors.toList());
    }
}

