/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.IndexingTestUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.jetbrains.annotations.Nullable;

class IgniteH2IndexingEx
extends IgniteH2Indexing {
    private static final Map<String, Map<String, IgniteThrowableConsumer<CacheDataRow>>> cacheRowConsumer = new ConcurrentHashMap<String, Map<String, IgniteThrowableConsumer<CacheDataRow>>>();
    private static final Map<String, Map<String, Runnable>> cacheRebuildRunner = new ConcurrentHashMap<String, Map<String, Runnable>>();
    private static final Map<String, Map<String, IgniteThrowableConsumer<CacheDataRow>>> idxCreateCacheRowConsumer = new ConcurrentHashMap<String, Map<String, IgniteThrowableConsumer<CacheDataRow>>>();

    IgniteH2IndexingEx() {
    }

    protected void rebuildIndexesFromHash0(final GridCacheContext cctx, final SchemaIndexCacheVisitorClosure clo, GridFutureAdapter<Void> rebuildIdxFut, SchemaIndexOperationCancellationToken cancel) {
        super.rebuildIndexesFromHash0(cctx, new SchemaIndexCacheVisitorClosure(){

            public void apply(CacheDataRow row) throws IgniteCheckedException {
                cacheRowConsumer.getOrDefault(IndexingTestUtils.nodeName(cctx), Collections.emptyMap()).getOrDefault(cctx.name(), IndexingTestUtils.DO_NOTHING_CACHE_DATA_ROW_CONSUMER).accept((Object)row);
                clo.apply(row);
            }
        }, rebuildIdxFut, cancel);
    }

    public IgniteInternalFuture<?> rebuildIndexesFromHash(GridCacheContext cctx, boolean force) {
        cacheRebuildRunner.getOrDefault(IndexingTestUtils.nodeName(cctx), Collections.emptyMap()).getOrDefault(cctx.name(), IndexingTestUtils.DO_NOTHING).run();
        return super.rebuildIndexesFromHash(cctx, force);
    }

    public void dynamicIndexCreate(String schemaName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        super.dynamicIndexCreate(schemaName, tblName, idxDesc, ifNotExists, clo -> cacheVisitor.visit(row -> {
            idxCreateCacheRowConsumer.getOrDefault(IndexingTestUtils.nodeName(this.ctx), Collections.emptyMap()).getOrDefault(idxDesc.name(), IndexingTestUtils.DO_NOTHING_CACHE_DATA_ROW_CONSUMER).accept((Object)row);
            clo.apply(row);
        }));
    }

    static void clean(@Nullable String nodeNamePrefix) {
        if (nodeNamePrefix == null) {
            cacheRowConsumer.clear();
            cacheRebuildRunner.clear();
            idxCreateCacheRowConsumer.clear();
        } else {
            cacheRowConsumer.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(nodeNamePrefix));
            cacheRebuildRunner.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(nodeNamePrefix));
            idxCreateCacheRowConsumer.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(nodeNamePrefix));
        }
    }

    static void prepareBeforeNodeStart() {
        GridQueryProcessor.idxCls = IgniteH2IndexingEx.class;
    }

    static void addCacheRowConsumer(String nodeName, String cacheName, IgniteThrowableConsumer<CacheDataRow> c) {
        cacheRowConsumer.computeIfAbsent(nodeName, s -> new ConcurrentHashMap()).put(cacheName, c);
    }

    static void addCacheRebuildRunner(String nodeName, String cacheName, Runnable r) {
        cacheRebuildRunner.computeIfAbsent(nodeName, s -> new ConcurrentHashMap()).put(cacheName, r);
    }

    static void addIdxCreateCacheRowConsumer(String nodeName, String idxName, IgniteThrowableConsumer<CacheDataRow> c) {
        idxCreateCacheRowConsumer.computeIfAbsent(nodeName, s -> new ConcurrentHashMap()).put(idxName, c);
    }
}

