/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.List;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;

public class ChooseIndexTest
extends AbstractIndexingCommonTest {
    private static final int OBJ_CNT = 1000;
    private ListeningTestLogger testLog;
    private LogListener logLsnr;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)this.testLog);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.testLog = new ListeningTestLogger(false, log);
        this.logLsnr = LogListener.matches((String)"Invalid cost function: INVALID_COST_FUNC").build();
        this.testLog.registerListener(this.logLsnr);
        this.startGrid();
        this.sql(this.grid(), "CREATE TABLE TEST (    ID INT PRIMARY KEY,     V0 INT,     V1 INT,     V2 INT,     V3 INT,     VAL INT) WITH\" TEMPLATE=REPLICATED,CACHE_NAME=inst,VALUE_TYPE=test_val\"", new Object[0]);
        this.sql(this.grid(), "CREATE INDEX IDX_V1 ON TEST (V1)", new Object[0]);
        this.sql(this.grid(), "CREATE INDEX IDX_V0_V1 ON TEST (V0, V1, V2, V3)", new Object[0]);
        try (IgniteDataStreamer streamer = this.grid().dataStreamer("inst");){
            for (int i = 0; i < 1000; ++i) {
                BinaryObjectBuilder bobVal = this.grid().binary().builder("test_val");
                bobVal.setField("V0", (Object)i);
                bobVal.setField("V1", (Object)i);
                bobVal.setField("V2", (Object)i);
                bobVal.setField("V3", (Object)i);
                streamer.addData((Object)i, (Object)bobVal.build());
            }
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testDefault() {
        String plan = (String)((List)this.sql(this.grid(), "EXPLAIN SELECT * FROM TEST WHERE V0=0 AND V1=0", new Object[0]).getAll().get(0)).get(0);
        ChooseIndexTest.assertTrue((String)("Invalid plan: " + plan), (boolean)plan.contains("PUBLIC.IDX_V0_V1"));
    }

    @WithSystemProperty(key="IGNITE_INDEX_COST_FUNCTION", value="LAST")
    @Test
    public void testLast() {
        String plan = (String)((List)this.sql(this.grid(), "EXPLAIN SELECT * FROM TEST WHERE V0=0 AND V1=0", new Object[0]).getAll().get(0)).get(0);
        ChooseIndexTest.assertTrue((String)("Invalid plan: " + plan), (boolean)plan.contains("PUBLIC.IDX_V0_V1"));
    }

    @WithSystemProperty(key="IGNITE_INDEX_COST_FUNCTION", value="COMPATIBLE_8_7_12")
    @Test
    public void testCompatible_8_7_12() {
        String plan = (String)((List)this.sql(this.grid(), "EXPLAIN SELECT * FROM TEST WHERE V0=0 AND V1=0", new Object[0]).getAll().get(0)).get(0);
        ChooseIndexTest.assertTrue((String)("Invalid plan: " + plan), (boolean)plan.contains("PUBLIC.IDX_V1"));
    }

    @WithSystemProperty(key="IGNITE_INDEX_COST_FUNCTION", value="COMPATIBLE_8_7_6")
    @Test
    public void testCompatible_8_7_6() {
        String plan = (String)((List)this.sql(this.grid(), "EXPLAIN SELECT * FROM TEST WHERE V0=0 AND V1=0", new Object[0]).getAll().get(0)).get(0);
        ChooseIndexTest.assertTrue((String)("Invalid plan: " + plan), (boolean)plan.contains("PUBLIC.IDX_V0_V1"));
    }

    @WithSystemProperty(key="IGNITE_INDEX_COST_FUNCTION", value="INVALID_COST_FUNC")
    @Test
    public void testInvalidCostFunctionName() {
        ChooseIndexTest.assertTrue((boolean)this.logLsnr.check());
    }

    private FieldsQueryCursor<List<?>> sql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false);
    }
}

