/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.AbstractDataTypesCoverageTest;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.table.Column;
import org.jetbrains.annotations.Nullable;
import org.junit.Ignore;
import org.junit.Test;

public class BasicIndexTest
extends AbstractIndexingCommonTest {
    private static final String CLIENT_NAME = "client";
    private static boolean createIdx = true;
    private static boolean createCompositeIdx;
    private static boolean createStaticCache;
    private static final String TEST_TBL_NAME = "PUBLIC.TEST_TABLE";
    private Collection<QueryIndex> indexes = Collections.emptyList();
    private Integer inlineSize;
    private boolean isPersistenceEnabled;
    private int gridCount = 1;
    private ListeningTestLogger srvLog;
    private ListeningTestLogger clientLog;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        BasicIndexTest.assertNotNull((Object)this.inlineSize);
        for (QueryIndex index : this.indexes) {
            index.setInlineSize(this.inlineSize.intValue());
        }
        IgniteConfiguration igniteCfg = super.getConfiguration(igniteInstanceName);
        igniteCfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        if (igniteInstanceName.startsWith(CLIENT_NAME)) {
            igniteCfg.setClientMode(true);
            if (this.clientLog != null) {
                igniteCfg.setGridLogger((IgniteLogger)this.clientLog);
            }
        } else if (this.srvLog != null) {
            igniteCfg.setGridLogger((IgniteLogger)this.srvLog);
        }
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("keyStr", String.class.getName());
        fields.put("keyLong", Long.class.getName());
        fields.put("keyPojo", Pojo.class.getName());
        fields.put("valStr", String.class.getName());
        fields.put("valLong", Long.class.getName());
        fields.put("valPojo", Pojo.class.getName());
        if (!createIdx) {
            this.indexes = Collections.emptyList();
        }
        CacheConfiguration ccfg = new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setQueryEntities(Collections.singleton(new QueryEntity().setKeyType(Key.class.getName()).setValueType(Val.class.getName()).setFields(fields).setKeyFields(new HashSet<String>(Arrays.asList("keyStr", "keyLong", "keyPojo"))).setIndexes(this.indexes).setAliases(Collections.singletonMap("_KEY", "pk_id")))).setSqlIndexMaxInlineSize(this.inlineSize.intValue());
        if (createStaticCache) {
            igniteCfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        }
        if (this.isPersistenceEnabled) {
            igniteCfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xA00000L)));
        }
        return igniteCfg.setFailureHandler((FailureHandler)new StopNodeFailureHandler());
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.clientLog = null;
        this.srvLog = null;
        createCompositeIdx = false;
        super.afterTest();
    }

    protected int gridCount() {
        return this.gridCount;
    }

    @Test
    public void testNoIndexesNoPersistence() throws Exception {
        int[] inlineSizes;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
        }
    }

    private int[] inlineSizeVariations() {
        int[] baseVariations = new int[]{0, 10, 20, 50, 100};
        if (GridTestUtils.SF.apply((int)baseVariations.length) < baseVariations.length) {
            return new int[]{0, 20, 100};
        }
        return baseVariations;
    }

    @Test
    public void testAllIndexesNoPersistence() throws Exception {
        int[] inlineSizes;
        this.indexes = Arrays.asList(new QueryIndex("keyStr"), new QueryIndex("keyLong"), new QueryIndex("keyPojo"), new QueryIndex("valStr"), new QueryIndex("valLong"), new QueryIndex("valPojo"));
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
        }
    }

    @Test
    public void testDynamicIndexesNoPersistence() throws Exception {
        int[] inlineSizes;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.createDynamicIndexes("keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo");
            this.checkAll();
            this.stopAllGrids();
        }
    }

    @Test
    public void testCorrectPkFldsSequence() throws Exception {
        this.inlineSize = 10;
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        IgniteH2Indexing idx = (IgniteH2Indexing)ig0.context().query().getIndexing();
        String tblName = "T1";
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE PUBLIC." + tblName + " (F1 VARCHAR, F2 VARCHAR, F3 VARCHAR, CONSTRAINT PK PRIMARY KEY (F1, F2))"), true).getAll();
        List<String> expect = Arrays.asList("F1", "F2");
        this.checkPkFldSequence(tblName, expect, idx);
        tblName = "T2";
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE PUBLIC." + tblName + " (F1 VARCHAR, F2 VARCHAR, F3 VARCHAR, CONSTRAINT PK PRIMARY KEY (F2, F1))"), true).getAll();
        expect = Arrays.asList("F2", "F1");
        this.checkPkFldSequence(tblName, expect, idx);
        tblName = "T3";
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE PUBLIC." + tblName + " (F1 VARCHAR, F2 VARCHAR, F3 VARCHAR, CONSTRAINT PK PRIMARY KEY (F3, F2))"), true).getAll();
        expect = Arrays.asList("F3", "F2");
        this.checkPkFldSequence(tblName, expect, idx);
    }

    @Test
    public void testCorrectPkFldsSequenceAfterRestart() throws Exception {
        this.inlineSize = 10;
        IgniteEx ig0 = this.startGrid(this.getConfiguration("0").setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))));
        ig0.cluster().state(ClusterState.ACTIVE);
        GridQueryProcessor qryProc = ig0.context().query();
        IgniteH2Indexing idx = (IgniteH2Indexing)ig0.context().query().getIndexing();
        String tblName = "T1";
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE PUBLIC." + tblName + " (F1 VARCHAR, F2 VARCHAR, F3 VARCHAR, CONSTRAINT PK PRIMARY KEY (F2, F1))"), true).getAll();
        List<String> expect = Arrays.asList("F2", "F1");
        this.checkPkFldSequence(tblName, expect, idx);
        this.stopAllGrids();
        ig0 = this.startGrid(this.getConfiguration("0").setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))));
        ig0.cluster().state(ClusterState.ACTIVE);
        IgniteH2Indexing idx2 = (IgniteH2Indexing)ig0.context().query().getIndexing();
        String tblName2 = "T1";
        List<String> expect2 = Arrays.asList("F2", "F1");
        this.checkPkFldSequence(tblName2, expect2, idx2);
    }

    @Test
    public void testPkFldsSequenceFeatureUnsupported() throws Exception {
        this.inlineSize = 10;
        ArrayList<IgniteEx> nodes = new ArrayList<IgniteEx>();
        nodes.add(this.startGrid(0));
        String prev = System.getProperty("IGNITE_SPECIFIED_SEQ_PK_KEYS_DISABLED");
        try {
            System.setProperty("IGNITE_SPECIFIED_SEQ_PK_KEYS_DISABLED", "true");
            nodes.add(this.startGrid(1));
        }
        finally {
            if (prev == null) {
                System.clearProperty("IGNITE_SPECIFIED_SEQ_PK_KEYS_DISABLED");
            } else {
                System.setProperty("IGNITE_SPECIFIED_SEQ_PK_KEYS_DISABLED", prev);
            }
        }
        int i = 0;
        for (IgniteEx ig : nodes) {
            GridQueryProcessor qryProc = ig.context().query();
            IgniteH2Indexing idx = (IgniteH2Indexing)ig.context().query().getIndexing();
            String tblName = "T" + i++;
            qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE PUBLIC." + tblName + " (F1 VARCHAR, F2 VARCHAR, F3 VARCHAR, CONSTRAINT PK PRIMARY KEY (F2, F1))"), true).getAll();
            this.checkPkFldSequence(tblName, Arrays.asList("F1", "F2"), idx);
        }
    }

    private void checkPkFldSequence(String tblName, List<String> expect, IgniteH2Indexing idx) {
        Index pkIdx = idx.schemaManager().dataTable("PUBLIC", tblName.toUpperCase()).getIndex("_key_PK");
        List actual = Arrays.stream(pkIdx.getColumns()).map(Column::getName).collect(Collectors.toList());
        if (!expect.equals(actual)) {
            throw new AssertionError((Object)("Exp: " + expect + ", but was: " + actual));
        }
    }

    @Test
    public void testDynamicIdxOnStaticCacheWithIdxWithoutPersistence() throws Exception {
        this.runDynamicIdxOnStaticCacheWithIdx(false);
    }

    @Test
    public void testDynamicIdxOnStaticCacheWithIdxWithPersistence() throws Exception {
        this.runDynamicIdxOnStaticCacheWithIdx(true);
    }

    private void runDynamicIdxOnStaticCacheWithIdx(boolean persistEnabled) throws Exception {
        this.isPersistenceEnabled = persistEnabled;
        this.inlineSize = 10;
        createIdx = false;
        this.indexes = Collections.singletonList(new QueryIndex("valStr"));
        IgniteEx ig0 = this.startGrid(0);
        createIdx = true;
        this.startGrid(1);
        if (persistEnabled) {
            ig0.cluster().active(true);
        }
        IgniteCache cache = this.grid(0).cache("default");
        this.populateCache();
        String plan = ((List)cache.query(new SqlFieldsQuery("explain select * from Val where valStr between 0 and ?").setArgs(new Object[]{100})).getAll().get(0)).get(0).toString();
        BasicIndexTest.assertTrue((String)plan, (boolean)plan.contains("__SCAN_"));
        this.stopAllGrids();
        if (persistEnabled) {
            this.cleanPersistenceDir();
        }
        createStaticCache = false;
        ig0 = this.startGrid(0);
        if (persistEnabled) {
            ig0.cluster().active(true);
        }
        ig0.getOrCreateCache("default");
        this.populateCache();
        createStaticCache = true;
        try {
            this.startGrid(1);
            BasicIndexTest.fail((String)"Exception wasn't thrown");
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualFieldsDynamicIndexesWithoutPersistence() throws Exception {
        this.runEqualFieldsDynamicIndexes(false);
    }

    @Test
    public void testEqualFieldsDynamicIndexesWithPersistence() throws Exception {
        this.runEqualFieldsDynamicIndexes(true);
    }

    private void runEqualFieldsDynamicIndexes(boolean persistEnabled) throws Exception {
        this.isPersistenceEnabled = persistEnabled;
        this.indexes = Collections.singletonList(new QueryIndex("valStr"));
        this.inlineSize = 10;
        this.srvLog = new ListeningTestLogger(false, log);
        this.clientLog = new ListeningTestLogger(false, log);
        String msg1 = "Index with the given set or subset of columns already exists";
        LogListener lsnr = LogListener.matches((String)msg1).andMatches(Pattern.compile(".*newIndexName=idx[0-9]")).build();
        LogListener staticCachesLsnr = LogListener.matches((String)msg1).build();
        this.srvLog.registerListener(staticCachesLsnr);
        IgniteEx ig0 = this.startGrid(0);
        if (persistEnabled) {
            ig0.cluster().active(true);
        }
        IgniteCache cache = this.grid(0).cache("default");
        this.populateCache();
        cache.query(new SqlFieldsQuery("create index \"idx0\" on Val(valStr)"));
        BasicIndexTest.assertTrue((boolean)staticCachesLsnr.check());
        this.srvLog.unregisterListener((Consumer)staticCachesLsnr);
        this.srvLog.registerListener(lsnr);
        cache.query(new SqlFieldsQuery("create index \"idx1\" on Val(valStr, valLong)"));
        cache.query(new SqlFieldsQuery("create index \"idx2\" on Val(valStr desc, valLong)"));
        BasicIndexTest.assertFalse((boolean)lsnr.check());
        cache.query(new SqlFieldsQuery("create index \"idx3\" on Val(valStr, valLong)"));
        cache.query(new SqlFieldsQuery("create index \"idx4\" on Val(valLong)"));
        String plan = ((List)cache.query(new SqlFieldsQuery("explain select min(_key), max(_key) from Val")).getAll().get(0)).get(0).toString().toUpperCase();
        BasicIndexTest.assertTrue((String)plan, (boolean)plan.contains("_key_PK".toUpperCase()));
        BasicIndexTest.assertTrue((boolean)lsnr.check());
        this.srvLog.unregisterListener((Consumer)lsnr);
        IgniteEx client = this.startGrid(CLIENT_NAME);
        cache = client.cache("default");
        LogListener lsnrIdx5 = LogListener.matches((String)msg1).andMatches("newIndexName=idx5").build();
        this.srvLog.registerListener(lsnrIdx5);
        cache.query(new SqlFieldsQuery("create index \"idx5\" on Val(valStr desc, valLong)"));
        BasicIndexTest.assertTrue((boolean)lsnrIdx5.check());
        LogListener lsnrIdx7 = LogListener.matches((String)msg1).andMatches("newIndexName=idx7").build();
        this.srvLog.registerListener(lsnrIdx7);
        cache.query(new SqlFieldsQuery("create index \"idx6\" on Val(valLong)"));
        cache.query(new SqlFieldsQuery("create index \"idx7\" on Val(keyStr, keyLong, keyPojo, valLong)"));
        BasicIndexTest.assertFalse((boolean)lsnrIdx7.check());
    }

    private void checkIdxIsUsed(GridQueryProcessor qryProc, String idxName, String tblName, String ... reqFlds) {
        this.checkIdxUsage(qryProc, idxName, null, tblName, reqFlds);
    }

    private void checkIdxIsNotUsed(GridQueryProcessor qryProc, String idxName, String tblName, String ... reqFlds) {
        this.checkIdxUsage(qryProc, null, idxName, tblName, reqFlds);
    }

    private void checkIdxUsage(GridQueryProcessor qryProc, String reqIdxName, String forbIdxname, String tblName, String ... reqFlds) {
        String sql = "explain select * from " + tblName + " where ";
        for (int i = 0; i < reqFlds.length; ++i) {
            sql = sql + reqFlds[i] + " > 0 " + (i < reqFlds.length - 1 ? " and " : "");
        }
        String plan = ((List)qryProc.querySqlFields(new SqlFieldsQuery(sql), true).getAll().get(0)).get(0).toString().toUpperCase();
        if (reqIdxName != null) {
            BasicIndexTest.assertTrue((String)String.format("Plan \n%s\ndoesn't contain index %s", plan, reqIdxName), (boolean)plan.contains(reqIdxName.toUpperCase()));
        }
        if (forbIdxname != null) {
            BasicIndexTest.assertTrue((String)String.format("Plan \n%s\ncontains index %s", plan, forbIdxname), (!plan.contains(forbIdxname.toUpperCase()) ? 1 : 0) != 0);
        }
    }

    private boolean checkIdxAlreadyExistLog(GridQueryProcessor qryProc, String idxName, String tblName, String ... reqFlds) {
        String msg0 = "Index with the given set or subset of columns already exists";
        String sql = "create index \"" + idxName + "\" on " + tblName + "(";
        for (int i = 0; i < reqFlds.length; ++i) {
            sql = sql + reqFlds[i] + (i < reqFlds.length - 1 ? ", " : ")");
        }
        LogListener lsnrIdx = LogListener.matches((String)msg0).andMatches(idxName).build();
        this.srvLog.registerListener(lsnrIdx);
        qryProc.querySqlFields(new SqlFieldsQuery(sql), true).getAll();
        this.srvLog.unregisterListener((Consumer)lsnrIdx);
        return lsnrIdx.check();
    }

    private void populateTable(GridQueryProcessor qryProc, String tblName, int consPkFldsNum, String ... reqFlds) {
        int i;
        assert (consPkFldsNum <= reqFlds.length);
        String sql = "CREATE TABLE " + tblName + " (";
        String sqlIns = "INSERT INTO " + tblName + " (";
        for (i = 0; i < reqFlds.length; ++i) {
            sql = sql + reqFlds[i] + " VARCHAR" + (consPkFldsNum == 0 && i == 0 ? " PRIMARY KEY, " : ", ");
            sqlIns = sqlIns + reqFlds[i] + (i < reqFlds.length - 1 ? ", " : ") values (");
        }
        if (consPkFldsNum != 0) {
            sql = sql + " CONSTRAINT PK_PERSON PRIMARY KEY (";
            if (consPkFldsNum > 0) {
                for (i = 0; i < consPkFldsNum; ++i) {
                    sql = sql + reqFlds[i] + (i < consPkFldsNum - 1 ? ", " : "))");
                }
            } else {
                for (i = -consPkFldsNum - 1; i >= 0; --i) {
                    sql = sql + reqFlds[i] + (i > 0 ? ", " : "))");
                }
            }
        } else {
            sql = sql + ")";
        }
        qryProc.querySqlFields(new SqlFieldsQuery(sql), true);
        for (i = 0; i < 10; ++i) {
            String s0 = sqlIns;
            for (int f = 0; f < reqFlds.length; ++f) {
                s0 = s0 + (i + f) + (f < reqFlds.length - 1 ? ", " : ")");
            }
            qryProc.querySqlFields(new SqlFieldsQuery(s0), true).getAll();
        }
    }

    private boolean checkIdxUsage(List<List<?>> res, String idx) {
        String plan = res.get(0).get(0).toString();
        return idx != null ? plan.contains(idx) : !plan.contains("__SCAN_");
    }

    @Test
    public void testCorrectFieldsSequenceInPk() throws Exception {
        this.inlineSize = 10;
        this.srvLog = new ListeningTestLogger(false, log);
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, -2, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG");
        BasicIndexTest.assertFalse((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx1", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME"));
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx2", TEST_TBL_NAME, "LAST_NAME", "FIRST_NAME"));
    }

    @Test
    public void testAllTableFieldsCoveredByIdx() throws Exception {
        this.inlineSize = 10;
        this.srvLog = new ListeningTestLogger(false, log);
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 2, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LANG");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LAST_NAME");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "LANG", "ADDRESS");
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx1", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME"));
        String sqlIdx2 = String.format("create index \"idx2\" on %s(LANG, ADDRESS)", TEST_TBL_NAME);
        qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx2), true).getAll();
        this.checkIdxIsUsed(qryProc, "idx2", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "LANG", "ADDRESS");
        this.checkIdxIsUsed(qryProc, null, TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG");
    }

    @Test
    public void testConditionsWithoutIndexes() throws Exception {
        this.inlineSize = 10;
        this.srvLog = new ListeningTestLogger(false, log);
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 2, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG");
        String sqlIdx = String.format("create index \"idx1\" on %s(LANG, ADDRESS)", TEST_TBL_NAME);
        qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx), true).getAll();
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LAST_NAME");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "ADDRESS");
        this.checkIdxIsUsed(qryProc, "idx1", TEST_TBL_NAME, "LANG");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "ADDRESS", "LAST_NAME");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "ADDRESS", "ADDRESS");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LAST_NAME", "ADDRESS");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "ADDRESS");
    }

    @Test
    public void testPartialTableFieldsCoveredByIdx() throws Exception {
        this.inlineSize = 10;
        this.srvLog = new ListeningTestLogger(false, log);
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 2, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG", "GENDER");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LANG");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LAST_NAME");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "LANG", "ADDRESS");
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx1", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME"));
        String sqlIdx2 = String.format("create index \"idx2\" on %s(LANG, ADDRESS)", TEST_TBL_NAME);
        qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx2), true).getAll();
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "LANG", "ADDRESS");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG");
        this.checkIdxIsNotUsed(qryProc, "idx2", TEST_TBL_NAME, "ADDRESS", "LAST_NAME");
        BasicIndexTest.assertFalse((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx3", TEST_TBL_NAME, "ADDRESS", "LANG"));
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx4", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG"));
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx5", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "LANG", "ADDRESS"));
        String msg0 = "Index with the given set or subset of columns already exists";
        LogListener lsnrIdx4 = LogListener.matches((String)msg0).andMatches("_key_PK").build();
        this.srvLog.registerListener(lsnrIdx4);
        String sqlIdx5 = String.format("create index \"idx6\" on %s(FIRST_NAME, LAST_NAME, LANG, ADDRESS)", TEST_TBL_NAME);
        String cacheName = QueryUtils.createTableCacheName((String)"PUBLIC", (String)"TEST_TABLE");
        IgniteCache jcache = ig0.cache(cacheName);
        jcache.query(new SqlFieldsQuery(sqlIdx5)).getAll();
        BasicIndexTest.assertTrue((boolean)lsnrIdx4.check());
    }

    @Test
    public void testCheckThreeFieldsInPk() throws Exception {
        this.inlineSize = 10;
        this.srvLog = new ListeningTestLogger(log);
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 3, "c1", "c2", "c3", "c4", "c5", "c6");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "c1");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "c2");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "c3");
    }

    @Test
    public void testCreateIdxWithDifferentIdxFldsSeq() throws Exception {
        this.inlineSize = 10;
        this.srvLog = new ListeningTestLogger(false, log);
        IgniteEx ig0 = this.startGrid(0);
        IgniteEx client = this.startGrid(CLIENT_NAME);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 1, "c1", "c2", "c3", "c4", "c5");
        BasicIndexTest.assertFalse((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx1", TEST_TBL_NAME, "c1", "c2", "c3", "c4", "c5"));
        BasicIndexTest.assertFalse((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx2", TEST_TBL_NAME, "c1", "c3", "c4", "c5"));
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx3", TEST_TBL_NAME, "c1", "c2"));
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx4", TEST_TBL_NAME, "c1", "c3"));
        BasicIndexTest.assertFalse((boolean)this.checkIdxAlreadyExistLog(qryProc, "idx5", TEST_TBL_NAME, "c1", "c4", "c5"));
        GridQueryProcessor qryProcCl = client.context().query();
        BasicIndexTest.assertTrue((boolean)this.checkIdxAlreadyExistLog(qryProcCl, "idx6", TEST_TBL_NAME, "c1", "c2"));
    }

    @Test
    public void testInWithEqualsIdxUsage() throws Exception {
        this.inlineSize = 10;
        this.isPersistenceEnabled = false;
        IgniteEx ignite = this.startGrid(0);
        GridQueryProcessor qryProc = ignite.context().query();
        this.checkInWithEqualsIdxUsageForDifferentTypes(qryProc);
        createCompositeIdx = true;
        this.checkInWithEqualsIdxUsageForDifferentTypes(qryProc);
    }

    private void checkInWithEqualsIdxUsageForDifferentTypes(GridQueryProcessor qryProc) {
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.INT, "val * 3", 1, 2, -3, null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.BIGINT, null, 0L, Long.MAX_VALUE, Long.MIN_VALUE, null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.VARCHAR, "_val", new AbstractDataTypesCoverageTest.Quoted((Object)""), new AbstractDataTypesCoverageTest.Quoted((Object)"whatever"), new AbstractDataTypesCoverageTest.Quoted((Object)"CamelCase"), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.DATE, "_key", new AbstractDataTypesCoverageTest.Dated(Date.valueOf("2001-09-11")), new AbstractDataTypesCoverageTest.Dated(Date.valueOf("1806-08-12")), new AbstractDataTypesCoverageTest.Dated(Date.valueOf("2051-11-21")), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.TIME, "fld, val", new AbstractDataTypesCoverageTest.Timed(Time.valueOf("00:00:01")), new AbstractDataTypesCoverageTest.Timed(Time.valueOf("12:00:00")), new AbstractDataTypesCoverageTest.Timed(Time.valueOf("23:59:59")), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.TIMESTAMP, "val, fld", new AbstractDataTypesCoverageTest.Dated(Timestamp.valueOf("2019-01-01 00:00:00")), new AbstractDataTypesCoverageTest.Dated(Timestamp.valueOf("2051-12-31 23:59:59")), new AbstractDataTypesCoverageTest.Dated(Timestamp.valueOf("1806-08-12 12:00:00")), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.DOUBLE, "*, _key", -1.0, 1.0E-7, new AbstractDataTypesCoverageTest.Quoted((Object)Double.NEGATIVE_INFINITY), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.UUID, "val", new AbstractDataTypesCoverageTest.Quoted((Object)"d9bc480e-1107-11ea-8d71-362b9e155667"), new AbstractDataTypesCoverageTest.Quoted((Object)UUID.fromString("d9bc4354-1107-11ea-8d71-362b9e155667")), new AbstractDataTypesCoverageTest.Quoted((Object)UUID.randomUUID()), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.DECIMAL, "ROUND(val + 0.05, 1)", "10.2", new BigDecimal("10.01"), new BigDecimal(123.123), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.BINARY, "BIT_LENGTH(val)", new AbstractDataTypesCoverageTest.ByteArrayed(new byte[0]), new AbstractDataTypesCoverageTest.ByteArrayed(new byte[]{0, 1}), new AbstractDataTypesCoverageTest.ByteArrayed(new byte[]{1, 2, 3}), null);
        this.checkInWithEqualsIdxUsageForType(qryProc, SqlDataType.OTHER, null, new UserObject(new Pojo(1L)), new UserObject(new Pojo(2L)), new UserObject(new Pojo(-3L)), null);
    }

    @Test
    public void testFailToCreateSqlIndexWithDuplicatedColumn() throws Exception {
        this.inlineSize = 10;
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 1, "ID", "NAME");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            String sqlIdx1 = String.format("create index \"idx1\" on %s(NAME, NAME)", TEST_TBL_NAME);
            qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx1), true).getAll();
            return null;
        }, IgniteSQLException.class, (String)"Already defined column in index: NAME ASC");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            String sqlIdx1 = String.format("create index \"idx1\" on %s(NAME ASC, NAME DESC)", TEST_TBL_NAME);
            qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx1), true).getAll();
            return null;
        }, IgniteSQLException.class, (String)"Already defined column in index: NAME ASC");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            String sqlIdx1 = String.format("create index \"idx1\" on %s(NAME DESC, ID, NAME)", TEST_TBL_NAME);
            qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx1), true).getAll();
            return null;
        }, IgniteSQLException.class, (String)"Already defined column in index: NAME DESC");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            String sqlIdx1 = String.format("create index \"idx1\" on %s(ID, id)", TEST_TBL_NAME);
            qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx1), true).getAll();
            return null;
        }, IgniteSQLException.class, (String)"Already defined column in index: ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInWithEqualsIdxUsageForType(GridQueryProcessor qryProc, SqlDataType dataType, @Nullable String proj, Object ... values) {
        assert (values.length >= 4);
        if (proj == null) {
            proj = "*";
        }
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE PUBLIC.TEST_TABLE(id LONG PRIMARY KEY, fld " + (Object)((Object)dataType) + ",  val " + (Object)((Object)dataType) + ")"), true);
        String idxName = "IDX_VAL";
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE INDEX \"IDX_VAL\" ON PUBLIC.TEST_TABLE" + (createCompositeIdx ? "(val, fld)" : "(val)")), true);
        for (int i = 0; i < values.length; ++i) {
            Object valToPut = this.toObjVal(values[i]);
            qryProc.querySqlFields(new SqlFieldsQuery("INSERT INTO PUBLIC.TEST_TABLE(id, fld, val) VALUES (?1, ?2, ?3)").setArgs(new Object[]{i, valToPut, valToPut}), true);
        }
        try {
            int rnd = ThreadLocalRandom.current().nextInt(values.length);
            Object val1 = values[rnd % values.length];
            Object val2 = values[(rnd + 1) % values.length];
            Object val3 = values[(rnd + 2) % values.length];
            Object val4 = values[(rnd + 3) % values.length];
            String qry = "select " + proj + " from " + TEST_TBL_NAME + " ";
            String sql = qry + "where val in (?1, ?2) and (fld = ?1 or fld = ?2)";
            List res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            sql = qry + "where val in (select fld from " + TEST_TBL_NAME + " where fld in(?1, ?2)) and (fld = ?1 or fld = ?2)";
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            sql = qry + "where val in (?1, ?2) and (fld = ?3 or fld = ?3)";
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3)}), true).getAll();
            sql = qry + "where val in (?1, ?2) and fld = ?3";
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3)}), true).getAll();
            sql = qry + "where val in (" + this.toStringVal(val1) + ", " + this.toStringVal(val2) + ") and fld = " + this.toStringVal(val3);
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql), true).getAll();
            sql = qry + "where (val = ?1 OR val = ?2) and fld = " + this.toStringVal(val3);
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            sql = qry + "where val in (?1, ?2) and (fld = ?3 or fld = ?4) ORDER BY fld";
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3), this.toObjVal(val4)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3), this.toObjVal(val4)}), true).getAll();
            sql = qry + "where val in (?1, ?2) and (fld = ?3 or fld = ?1) ORDER BY fld";
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2), this.toObjVal(val3)}), true).getAll();
            sql = qry + "where val in (?1, ?2) and (fld = ?1 or fld = ?2) ORDER BY fld";
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql).setArgs(new Object[]{this.toObjVal(val1), this.toObjVal(val2)}), true).getAll();
            sql = qry + "where val in (" + this.toStringVal(val2) + ", " + this.toStringVal(val1) + ") and (fld = " + this.toStringVal(val1) + " or fld = " + this.toStringVal(val2) + ") ORDER BY fld";
            res = qryProc.querySqlFields(new SqlFieldsQuery("explain " + sql), true).getAll();
            BasicIndexTest.assertTrue((boolean)this.checkIdxUsage(res, "IDX_VAL"));
            qryProc.querySqlFields(new SqlFieldsQuery(sql), true).getAll();
        }
        finally {
            qryProc.querySqlFields(new SqlFieldsQuery("DROP TABLE PUBLIC.TEST_TABLE;"), true);
        }
    }

    private <T> String toStringVal(T val) {
        return val instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)val).sqlStrVal() : String.valueOf(val);
    }

    private <T> Object toObjVal(T val) {
        return val instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)val).originalVal() : val;
    }

    @Test
    public void testIndexWithDifferentFldsReqPartialFldsInIdx() throws Exception {
        this.inlineSize = 10;
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 2, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG", "GENDER");
        String sqlIdx1 = String.format("create index \"idx1\" on %s(LANG, LAST_NAME, ADDRESS, FIRST_NAME)", TEST_TBL_NAME);
        qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx1), true).getAll();
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "LANG");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "ADDRESS");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LAST_NAME", "ADDRESS");
    }

    @Test
    public void testIndexWithDifferentFldsReqAllFldsInIdx() throws Exception {
        this.inlineSize = 10;
        IgniteEx ig0 = this.startGrid(0);
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, TEST_TBL_NAME, 2, "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG");
        String sqlIdx1 = String.format("create index \"idx1\" on %s(LANG, LAST_NAME, ADDRESS, FIRST_NAME)", TEST_TBL_NAME);
        qryProc.querySqlFields(new SqlFieldsQuery(sqlIdx1), true).getAll();
        this.checkIdxIsUsed(qryProc, "idx1", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "LANG");
        this.checkIdxIsUsed(qryProc, "_key_PK", TEST_TBL_NAME, "FIRST_NAME", "LAST_NAME", "ADDRESS");
        this.checkIdxIsUsed(qryProc, "__SCAN_", TEST_TBL_NAME, "LAST_NAME", "ADDRESS");
    }

    @Test
    public void testNoIndexesWithPersistence() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testAllIndexesWithPersistence() throws Exception {
        int[] inlineSizes;
        this.indexes = Arrays.asList(new QueryIndex("keyStr"), new QueryIndex("keyLong"), new QueryIndex("keyPojo"), new QueryIndex("valStr"), new QueryIndex("valLong"), new QueryIndex("valPojo"));
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    @WithSystemProperty(key="IGNITE_THROTTLE_INLINE_SIZE_CALCULATION", value="1")
    public void testInlineSizeChange() throws Exception {
        this.isPersistenceEnabled = true;
        this.indexes = Collections.singletonList(new QueryIndex("valStr"));
        this.inlineSize = 33;
        this.srvLog = new ListeningTestLogger(false, log);
        String msg1 = "curSize=1";
        String msg2 = "curSize=2";
        String msg3 = "curSize=3";
        LogListener lstn1 = LogListener.matches((String)msg1).build();
        LogListener lstn2 = LogListener.matches((String)msg2).build();
        LogListener lstn3 = LogListener.matches((String)msg3).build();
        this.srvLog.registerListener(lstn1);
        this.srvLog.registerListener(lstn2);
        this.srvLog.registerListener(lstn3);
        IgniteEx ig0 = this.startGrid(0);
        ig0.cluster().active(true);
        this.populateCache();
        IgniteCache cache = this.grid(0).cache("default");
        this.execSql(cache, "create index \"idx1\" on Val(valLong) INLINE_SIZE 1 PARALLEL 28", new Object[0]);
        List<List<?>> res = this.execSql(cache, "explain select * from Val where valLong > ?", 10);
        BasicIndexTest.assertTrue((boolean)((String)res.get(0).get(0)).toUpperCase().contains("default.idx1".toUpperCase()));
        BasicIndexTest.assertTrue((boolean)lstn1.check());
        this.execSql(cache, "drop index \"idx1\"", new Object[0]);
        this.execSql(cache, "create index \"idx1\" on Val(valLong) INLINE_SIZE 2 PARALLEL 28", new Object[0]);
        this.execSql(cache, "explain select * from Val where valLong > ?", 10);
        BasicIndexTest.assertTrue((boolean)lstn2.check());
        this.execSql(cache, "drop index \"idx1\"", new Object[0]);
        this.stopAllGrids();
        ig0 = this.startGrid(0);
        ig0.cluster().active(true);
        cache = ig0.cache("default");
        this.execSql(cache, "create index \"idx1\" on Val(valLong) INLINE_SIZE 3 PARALLEL 28", new Object[0]);
        this.execSql(cache, "explain select * from Val where valLong > ?", 10);
        BasicIndexTest.assertTrue((boolean)lstn3.check());
    }

    private List<List<?>> execSql(IgniteCache<?, ?> cache, String qry, Object ... args) {
        return cache.query(new SqlFieldsQuery(qry).setArgs(args)).getAll();
    }

    @Test
    public void testDynamicIndexesWithPersistence() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.createDynamicIndexes("keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo");
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testDynamicIndexesDropWithPersistence() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            String[] cols = new String[]{"keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo"};
            this.createDynamicIndexes(cols);
            this.checkAll();
            this.dropDynamicIndexes(cols);
            this.checkAll();
            this.stopAllGrids();
            this.startGridsMultiThreaded(this.gridCount());
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testNoIndexesWithPersistenceIndexRebuild() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            List<Path> idxPaths = this.getIndexBinPaths("default");
            this.grid(0).cluster().active(false);
            this.stopAllGrids();
            idxPaths.forEach(idxPath -> BasicIndexTest.assertTrue((boolean)U.delete((Path)idxPath)));
            this.startGridsMultiThreaded(this.gridCount());
            this.grid(0).cache("default").indexReadyFuture().get();
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testAllIndexesWithPersistenceIndexRebuild() throws Exception {
        int[] inlineSizes;
        this.indexes = Arrays.asList(new QueryIndex("keyStr"), new QueryIndex("keyLong"), new QueryIndex("keyPojo"), new QueryIndex("valStr"), new QueryIndex("valLong"), new QueryIndex("valPojo"));
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.checkAll();
            List<Path> idxPaths = this.getIndexBinPaths("default");
            this.grid(0).cluster().active(false);
            this.stopAllGrids();
            idxPaths.forEach(idxPath -> BasicIndexTest.assertTrue((boolean)U.delete((Path)idxPath)));
            this.startGridsMultiThreaded(this.gridCount());
            this.grid(0).cache("default").indexReadyFuture().get();
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testDynamicIndexesWithPersistenceIndexRebuild() throws Exception {
        int[] inlineSizes;
        this.isPersistenceEnabled = true;
        for (int i : inlineSizes = this.inlineSizeVariations()) {
            this.log().info("Checking inlineSize=" + i);
            this.inlineSize = i;
            this.startGridsMultiThreaded(this.gridCount());
            this.populateCache();
            this.createDynamicIndexes("keyStr", "keyLong", "keyPojo", "valStr", "valLong", "valPojo");
            this.checkAll();
            List<Path> idxPaths = this.getIndexBinPaths("default");
            this.grid(0).cluster().active(false);
            this.stopAllGrids();
            idxPaths.forEach(idxPath -> BasicIndexTest.assertTrue((boolean)U.delete((Path)idxPath)));
            this.startGridsMultiThreaded(this.gridCount());
            this.grid(0).cache("default").indexReadyFuture().get();
            this.checkAll();
            this.stopAllGrids();
            this.cleanPersistenceDir();
        }
    }

    @Test
    public void testIndexSelectionIsNotAffectedByCreationOrderScenario1() throws Exception {
        this.checkRightIndexChosen("IDX1", "IDX2", "CREATE INDEX IDX1  on TEST_TBL_NAME (FIRST_NAME, LAST_NAME)", "CREATE INDEX IDX2 on TEST_TBL_NAME (LAST_NAME, FIRST_NAME)", "SELECT * FROM TEST_TBL_NAME WHERE LAST_NAME = 2 and FIRST_NAME >= 1 and FIRST_NAME <= 5 and ADDRESS in (1, 2, 3);");
    }

    @Test
    public void testIndexSelectionIsNotAffectedByCreationOrderScenario2() throws Exception {
        this.checkRightIndexChosen("IDX1", "IDX2", "CREATE INDEX IDX1 on TEST_TBL_NAME (LAST_NAME, FIRST_NAME)", "CREATE INDEX IDX2 on TEST_TBL_NAME (FIRST_NAME, LAST_NAME)", "SELECT * FROM TEST_TBL_NAME WHERE LAST_NAME >= 2 and FIRST_NAME = 1 and FIRST_NAME <= 5 and ADDRESS in (1, 2, 3)");
    }

    @Test
    public void testIndexSelectionIsNotAffectedByCreationOrderScenario3() throws Exception {
        this.checkRightIndexChosen("IDX1", "IDX2", "CREATE INDEX IDX1 on TEST_TBL_NAME (FIRST_NAME)", "CREATE INDEX IDX2 on TEST_TBL_NAME (LAST_NAME, FIRST_NAME)", "SELECT * FROM TEST_TBL_NAME WHERE LAST_NAME = 2 and FIRST_NAME >= 1 and FIRST_NAME <= 5 and ADDRESS in (1, 2, 3)");
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-25338")
    @Test
    public void testIndexSelectionIsNotAffectedByCreationOrderScenario4() throws Exception {
        this.checkRightIndexChosen("IDX1", "IDX2", "CREATE INDEX IDX1 on TEST_TBL_NAME (LAST_NAME, ADDRESS)", "CREATE INDEX IDX2 on TEST_TBL_NAME (LAST_NAME, FIRST_NAME)", "SELECT * FROM TEST_TBL_NAME WHERE LAST_NAME = 2 and FIRST_NAME >= 1 and FIRST_NAME <= 5 and ADDRESS in (1, 2, 3)");
    }

    @Test
    public void testIndexSelectionIsNotAffectedByCreationOrderScenario5() throws Exception {
        this.checkRightIndexChosen("IDX1", "IDX2", "CREATE INDEX IDX1 on TEST_TBL_NAME (LAST_NAME, FIRST_NAME)", "CREATE INDEX IDX2 on TEST_TBL_NAME (LAST_NAME, ADDRESS)", "SELECT * FROM TEST_TBL_NAME WHERE LAST_NAME = 2 and ADDRESS >= 1");
    }

    @Test
    public void testStopNodeOnSqlQueryWithIncompatibleType() throws Exception {
        this.inlineSize = 10;
        this.startGrid();
        this.sql("CREATE TABLE TEST (ID INT PRIMARY KEY, val_int INT, VAL_OBJ OTHER)", new Object[0]);
        this.sql("CREATE INDEX TEST_VAL_INT ON TEST(VAL_INT)", new Object[0]);
        this.sql("CREATE INDEX TEST_VAL_OBJ ON TEST(VAL_OBJ)", new Object[0]);
        this.sql("INSERT INTO TEST VALUES (0, 0, ?)", Instant.now());
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.sql("SELECT * FROM TEST WHERE VAL_OBJ < CURRENT_TIMESTAMP()", new Object[0]).getAll();
            return null;
        }, CacheException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.sql("SELECT * FROM TEST WHERE VAL_INT < CURRENT_TIMESTAMP()", new Object[0]).getAll();
            return null;
        }, CacheException.class, null);
        BasicIndexTest.assertFalse((boolean)this.grid().context().isStopping());
    }

    @Test
    public void testOpenRangePredicateOnCompoundPk() throws Exception {
        this.inlineSize = 10;
        this.startGrid();
        this.sql("create table test (id1 int, id2 int, val int, constraint pk primary key (id1, id2))", new Object[0]);
        for (int i = 1; i <= 5; ++i) {
            this.sql("insert into test (id1, id2, val) values (?, ?, ?)", 0, i, i);
        }
        BasicIndexTest.assertEquals((int)5, (int)this.sql("select * from test where id1 = 0 and id2 > 0", new Object[0]).getAll().size());
    }

    private void checkRightIndexChosen(String wrongIdx1Name, String properIdx2Name, String idx1Cmd, String idx2Cmd, String qry) throws Exception {
        this.inlineSize = 10;
        wrongIdx1Name = wrongIdx1Name.toUpperCase();
        properIdx2Name = properIdx2Name.toUpperCase();
        BasicIndexTest.assertTrue((String)idx1Cmd, (boolean)idx1Cmd.toUpperCase().contains(wrongIdx1Name));
        BasicIndexTest.assertTrue((String)idx2Cmd, (boolean)idx2Cmd.toUpperCase().contains(properIdx2Name));
        IgniteEx ig0 = this.startGrids(this.gridCount());
        GridQueryProcessor qryProc = ig0.context().query();
        this.populateTable(qryProc, "TEST_TBL_NAME", 1, "ID", "FIRST_NAME", "LAST_NAME", "ADDRESS", "LANG");
        qryProc.querySqlFields(new SqlFieldsQuery(idx2Cmd), true).getAll();
        qryProc.querySqlFields(new SqlFieldsQuery(idx1Cmd), true).getAll();
        String plan = ((List)qryProc.querySqlFields(new SqlFieldsQuery("explain " + qry), true).getAll().get(0)).get(0).toString().toUpperCase();
        BasicIndexTest.assertTrue((String)("plan=" + plan), (boolean)plan.contains(properIdx2Name));
        BasicIndexTest.assertFalse((String)("plan=" + plan), (boolean)plan.contains(wrongIdx1Name));
        qryProc.querySqlFields(new SqlFieldsQuery("DROP INDEX " + wrongIdx1Name), true).getAll();
        qryProc.querySqlFields(new SqlFieldsQuery("DROP INDEX " + properIdx2Name), true).getAll();
        qryProc.querySqlFields(new SqlFieldsQuery(idx1Cmd), true).getAll();
        qryProc.querySqlFields(new SqlFieldsQuery(idx2Cmd), true).getAll();
        plan = ((List)qryProc.querySqlFields(new SqlFieldsQuery("explain " + qry), true).getAll().get(0)).get(0).toString().toUpperCase();
        BasicIndexTest.assertTrue((String)("plan=" + plan), (boolean)plan.contains(properIdx2Name));
        BasicIndexTest.assertFalse((String)("plan=" + plan), (boolean)plan.contains(wrongIdx1Name));
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testCreateLuceneIndex() throws Exception {
        this.inlineSize = 10;
        this.startGrid();
        this.sql("create table test0(id1 int primary key, val varchar) WITH \"WRAP_VALUE=false\"", new Object[0]);
        IgniteH2Indexing idx = (IgniteH2Indexing)this.grid().context().query().getIndexing();
        H2TableDescriptor tblDesc0 = idx.schemaManager().dataTable("PUBLIC", "TEST0").rowDescriptor().tableDescriptor();
        BasicIndexTest.assertNotNull((Object)GridTestUtils.getFieldValue((Object)tblDesc0, (String[])new String[]{"luceneIdx"}));
        idx.distributedConfiguration().disableCreateLuceneIndexForStringValueType(true).get();
        this.sql("create table test1(id1 int primary key, val varchar) WITH \"WRAP_VALUE=false\"", new Object[0]);
        H2TableDescriptor tblDesc1 = idx.schemaManager().dataTable("PUBLIC", "TEST1").rowDescriptor().tableDescriptor();
        BasicIndexTest.assertNull((Object)GridTestUtils.getFieldValue((Object)tblDesc1, (String[])new String[]{"luceneIdx"}));
    }

    @Test
    public void testCacheSecondaryCompositeIndex() throws Exception {
        this.inlineSize = 70;
        this.startGrid();
        String cacheName = "TEST";
        this.grid().createCache(new CacheConfiguration().setName(cacheName).setSqlSchema(cacheName).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 4)).setQueryEntities(Collections.singleton(new QueryEntity().setTableName(cacheName).setKeyType(Integer.class.getName()).setKeyFieldName("id").setValueType("TEST_VAL_SECONDARY_COMPOSITE").addQueryField("id", Integer.class.getName(), null).addQueryField("val_obj", Object.class.getName(), null).setIndexes(Arrays.asList(new QueryIndex(Arrays.asList("val_obj"), QueryIndexType.SORTED).setInlineSize(this.inlineSize.intValue()))))));
        BinaryObjectBuilder bob = this.grid().binary().builder("TEST_VAL_SECONDARY_COMPOSITE");
        BinaryObjectBuilder bobInner = this.grid().binary().builder("inner");
        bobInner.setField("inner_k", (Object)0);
        bobInner.setField("inner_uuid", (Object)UUID.randomUUID());
        bob.setField("val_obj", (Object)bobInner.build());
        this.grid().cache(cacheName).put((Object)0, (Object)bob.build());
    }

    @Test
    public void testCreateSystemIndexWithSpecifiedInlineSizeByDdl() throws Exception {
        this.srvLog = new ListeningTestLogger(false, log);
        this.inlineSize = 10;
        int pkInlineSize = 22;
        int affInlineSize = 23;
        IgniteEx ign = this.startGrid();
        this.sql("CREATE TABLE TEST (ID VARCHAR, ID_AFF INT, VAL INT, PRIMARY KEY (ID, ID_AFF)) WITH\"AFFINITY_KEY=ID_AFF,PK_INLINE_SIZE=22,AFFINITY_INDEX_INLINE_SIZE=23\"", new Object[0]);
        GridH2Table tbl = ((IgniteH2Indexing)ign.context().query().getIndexing()).schemaManager().dataTable("PUBLIC", "TEST");
        BasicIndexTest.assertEquals((int)22, (int)((H2TreeIndex)tbl.getIndex("_key_PK")).inlineSize());
        BasicIndexTest.assertEquals((int)23, (int)((H2TreeIndex)tbl.getIndex("AFFINITY_KEY")).inlineSize());
        LogListener lsnr = LogListener.matches((String)"Indexed columns of a row cannot be fully inlined").andMatches("for sorted indexes on primary key and affinity field use 'PK_INLINE_SIZE' and 'AFFINITY_INDEX_INLINE_SIZE' properties for CREATE TABLE command").build();
        this.srvLog.registerListener(lsnr);
        String key_prefix = "ID____________________________________________________________________";
        for (int i = 0; i < 1000; ++i) {
            this.sql("INSERT INTO TEST VALUES (?, ?, ?)", "ID____________________________________________________________________" + i, i, i);
        }
        BasicIndexTest.assertTrue((boolean)lsnr.check());
    }

    @Test
    @WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="2147483647")
    public void testMaxInlineSizeIsUsedWhenExceeded() throws Exception {
        this.inlineSize = -1;
        IgniteEx ign = this.startGrid();
        int idxColSize = 428;
        this.sql("CREATE TABLE TEST (ID VARCHAR(" + idxColSize + "), ID_AFF VARCHAR, PRIMARY KEY (ID))", new Object[0]);
        GridH2Table tbl = ((IgniteH2Indexing)ign.context().query().getIndexing()).schemaManager().dataTable("PUBLIC", "TEST");
        BasicIndexTest.assertEquals((int)427, (int)((H2TreeIndex)tbl.getIndex("_key_PK")).inlineSize());
    }

    @Test
    @WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="2147483647")
    public void testWarnWhenConfiguredInlineSizeExceedsMax() throws Exception {
        this.inlineSize = -1;
        this.srvLog = new ListeningTestLogger(false, log);
        this.startGrid();
        int idxInlineSize = 428;
        String warnMsg = "Explicit INLINE_SIZE exceeds maximum size. Ignoring [index=SOME_IDX, explicitInlineSize=" + idxInlineSize + ", maxInlineSize=" + 427 + "]";
        LogListener lsnr = LogListener.matches((String)warnMsg).build();
        this.srvLog.registerListener(lsnr);
        this.sql("CREATE TABLE TEST (ID VARCHAR, ID_AFF INT, VAL INT, PRIMARY KEY (ID, ID_AFF))", new Object[0]);
        this.sql("CREATE INDEX SOME_IDX ON TEST (VAL) inline_size " + idxInlineSize, new Object[0]);
        BasicIndexTest.assertTrue((boolean)lsnr.check());
        this.srvLog.unregisterListener((Consumer)lsnr);
    }

    private void checkAll() {
        IgniteCache cache = this.grid(0).cache("default");
        this.checkRemovePut((IgniteCache<Key, Val>)cache);
        this.checkSelectAll((IgniteCache<Key, Val>)cache);
        this.checkSelectStringEqual((IgniteCache<Key, Val>)cache);
        this.checkSelectLongEqual((IgniteCache<Key, Val>)cache);
        this.checkSelectStringRange((IgniteCache<Key, Val>)cache);
        this.checkSelectLongRange((IgniteCache<Key, Val>)cache);
    }

    private void populateCache() {
        int i;
        IgniteCache cache = this.grid(0).cache("default");
        for (i = 0; i < 100; i += 2) {
            cache.put((Object)BasicIndexTest.key(i), (Object)BasicIndexTest.val(i));
        }
        for (i = 99; i > 0; i -= 2) {
            cache.put((Object)BasicIndexTest.key(i), (Object)BasicIndexTest.val(i));
        }
        for (i = 99; i > 0; i -= 2) {
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)cache.get((Object)BasicIndexTest.key(i)));
        }
    }

    private void checkRemovePut(IgniteCache<Key, Val> cache) {
        int INT = 24;
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(24L), (Object)cache.get((Object)BasicIndexTest.key(24L)));
        cache.remove((Object)BasicIndexTest.key(24L));
        BasicIndexTest.assertNull((Object)cache.get((Object)BasicIndexTest.key(24L)));
        cache.put((Object)BasicIndexTest.key(24L), (Object)BasicIndexTest.val(24L));
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(24L), (Object)cache.get((Object)BasicIndexTest.key(24L)));
    }

    private void checkSelectAll(IgniteCache<Key, Val> cache) {
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val")).getAll();
        BasicIndexTest.assertEquals((int)100, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            BasicIndexTest.assertEquals((Object)BasicIndexTest.key(i), (Object)key);
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)val);
        }
    }

    private void checkSelectStringEqual(IgniteCache<Key, Val> cache) {
        String STR = "foo011";
        long LONG = 11L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where keyStr = ?").setArgs(new Object[]{"foo011"})).getAll();
        BasicIndexTest.assertEquals((int)1, (int)data.size());
        List row = (List)data.get(0);
        BasicIndexTest.assertEquals((Object)BasicIndexTest.key(11L), row.get(0));
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(11L), row.get(1));
    }

    private void checkSelectLongEqual(IgniteCache<Key, Val> cache) {
        long LONG = 42L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where valLong = ?").setArgs(new Object[]{42L})).getAll();
        BasicIndexTest.assertEquals((int)1, (int)data.size());
        List row = (List)data.get(0);
        BasicIndexTest.assertEquals((Object)BasicIndexTest.key(42L), row.get(0));
        BasicIndexTest.assertEquals((Object)BasicIndexTest.val(42L), row.get(1));
    }

    private void checkSelectStringRange(IgniteCache<Key, Val> cache) {
        String PREFIX = "foo06";
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where keyStr like ?").setArgs(new Object[]{"foo06%"})).getAll();
        BasicIndexTest.assertEquals((int)10, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            BasicIndexTest.assertEquals((Object)BasicIndexTest.key(i), (Object)key);
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)val);
            BasicIndexTest.assertTrue((boolean)key.keyStr.startsWith("foo06"));
        }
    }

    private void checkSelectLongRange(IgniteCache<Key, Val> cache) {
        long RANGE_START = 70L;
        long RANGE_END = 80L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where valLong >= ? and valLong < ?").setArgs(new Object[]{70L, 80L})).getAll();
        BasicIndexTest.assertEquals((int)10, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            BasicIndexTest.assertEquals((Object)BasicIndexTest.key(i), (Object)key);
            BasicIndexTest.assertEquals((Object)BasicIndexTest.val(i), (Object)val);
            BasicIndexTest.assertTrue((i >= 70L && i < 80L ? 1 : 0) != 0);
        }
    }

    private void createDynamicIndexes(String ... cols) {
        IgniteCache cache = this.grid(0).cache("default");
        for (String col : cols) {
            String indexName = col + "_idx";
            String schemaName = "default";
            cache.query(new SqlFieldsQuery(String.format("create index %s on \"%s\".Val(%s) INLINE_SIZE %s;", indexName, schemaName, col, this.inlineSize))).getAll();
        }
        cache.indexReadyFuture().get();
    }

    private void dropDynamicIndexes(String ... cols) {
        IgniteCache cache = this.grid(0).cache("default");
        for (String col : cols) {
            String indexName = col + "_idx";
            cache.query(new SqlFieldsQuery(String.format("drop index %s;", indexName))).getAll();
        }
        cache.indexReadyFuture().get();
    }

    private static Key key(long i) {
        return new Key(String.format("foo%03d", i), i, new Pojo(i));
    }

    private static Val val(long i) {
        return new Val(String.format("bar%03d", i), i, new Pojo(i));
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.sql(this.grid(), sql, args);
    }

    private FieldsQueryCursor<List<?>> sql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false);
    }

    static {
        createStaticCache = true;
    }

    private static enum SqlDataType {
        INT(Integer.class),
        BIGINT(Long.class),
        DECIMAL(BigDecimal.class),
        DOUBLE(Double.class),
        TIME(Time.class),
        DATE(Date.class),
        TIMESTAMP(Timestamp.class),
        VARCHAR(String.class),
        OTHER(Pojo.class),
        UUID(UUID.class),
        BINARY(byte[].class);

        private Object javaType;

        private SqlDataType(Object javaType) {
            this.javaType = javaType;
        }
    }

    static class UserObject
    implements AbstractDataTypesCoverageTest.SqlStrConvertedValHolder {
        private Object obj;

        public UserObject(Object obj) {
            this.obj = obj;
        }

        public Object originalVal() {
            return this.obj;
        }

        public String sqlStrVal() {
            return null;
        }
    }

    private static class Pojo {
        private long pojoLong;

        private Pojo(long pojoLong) {
            this.pojoLong = pojoLong;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            return this.pojoLong == pojo.pojoLong;
        }

        public int hashCode() {
            return Objects.hash(this.pojoLong);
        }

        public String toString() {
            return S.toString(Pojo.class, (Object)this);
        }
    }

    private static class Val {
        private String valStr;
        private long valLong;
        private Pojo valPojo;

        private Val(String str, long aLong, Pojo pojo) {
            this.valStr = str;
            this.valLong = aLong;
            this.valPojo = pojo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Val val = (Val)o;
            return this.valLong == val.valLong && Objects.equals(this.valStr, val.valStr) && Objects.equals(this.valPojo, val.valPojo);
        }

        public int hashCode() {
            return Objects.hash(this.valStr, this.valLong, this.valPojo);
        }

        public String toString() {
            return S.toString(Val.class, (Object)this);
        }
    }

    private static class Key {
        private String keyStr;
        private long keyLong;
        private Pojo keyPojo;

        private Key(String str, long aLong, Pojo pojo) {
            this.keyStr = str;
            this.keyLong = aLong;
            this.keyPojo = pojo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.keyLong == key.keyLong && Objects.equals(this.keyStr, key.keyStr) && Objects.equals(this.keyPojo, key.keyPojo);
        }

        public int hashCode() {
            return Objects.hash(this.keyStr, this.keyLong, this.keyPojo);
        }

        public String toString() {
            return S.toString(Key.class, (Object)this);
        }
    }
}

