/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class WrongIndexedTypesTest
extends GridCommonAbstractTest {
    private boolean failed;
    private static final String TX_CACHE = "tx_cache";
    private static final String ATOMIC_CACHE = "atomic_cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setFailureHandler((ignite, ctx) -> {
            this.failed = true;
            return true;
        }).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(TX_CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{String.class, String.class}), new CacheConfiguration(ATOMIC_CACHE).setAtomicityMode(CacheAtomicityMode.ATOMIC).setIndexedTypes(new Class[]{String.class, String.class})});
    }

    @Test
    public void testPutIndexedType() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        for (String cacheName : F.asList((Object[])new String[]{TX_CACHE, ATOMIC_CACHE})) {
            for (int i = 0; i < 10; ++i) {
                try {
                    ignite.cache(cacheName).put((Object)i, (Object)("val" + i));
                    WrongIndexedTypesTest.fail((String)"Exception expected");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        WrongIndexedTypesTest.assertFalse((boolean)this.failed);
    }
}

