/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.ConcurrentStripedPool;
import org.apache.ignite.internal.processors.query.h2.H2Connection;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", value="200"), @WithSystemProperty(key="IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", value="1000")})
public class IgniteCacheQueryH2IndexingLeakTest
extends GridCommonAbstractTest {
    private static final int THREAD_COUNT = 10;
    public static final long STMT_CACHE_TTL = 1000L;
    private static final int ITERATIONS = 5;
    static final CyclicBarrier BARRIER = new CyclicBarrier(10);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration()});
    }

    protected CacheConfiguration<?, ?> cacheConfiguration() {
        return IgniteCacheQueryH2IndexingLeakTest.defaultCacheConfiguration().setCacheMode(CacheMode.PARTITIONED).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setSqlFunctionClasses(new Class[]{IgniteCacheQueryH2IndexingLeakTest.class}).setIndexedTypes(new Class[]{Integer.class, Integer.class});
    }

    protected long getTestTimeout() {
        return 60000L;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    private static int getStatementCacheSize(GridQueryProcessor qryProcessor) {
        IgniteH2Indexing h2Idx = (IgniteH2Indexing)qryProcessor.getIndexing();
        ConcurrentStripedPool conns = (ConcurrentStripedPool)GridTestUtils.getFieldValue((Object)h2Idx.connections(), (String[])new String[]{"connPool"});
        return conns.stream().mapToInt(H2Connection::statementCacheSize).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaksInIgniteH2IndexingOnTerminatedThread() throws Exception {
        GridQueryProcessor qryProc = this.grid(0).context().query();
        String qry = "select * from \"default\".Integer where _val >= \"default\".barrier()";
        for (int i = 0; i < 5; ++i) {
            this.info("Iteration #" + i);
            final CountDownLatch exitLatch = new CountDownLatch(1);
            final CountDownLatch qryExec = new CountDownLatch(10);
            IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

                public void applyx() throws IgniteCheckedException {
                    try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
                         Statement stmt = conn.createStatement();){
                        stmt.executeQuery("select * from \"default\".Integer where _val >= \"default\".barrier()").next();
                        qryExec.countDown();
                        U.await((CountDownLatch)exitLatch);
                    }
                    catch (Exception ex) {
                        throw new IgniteCheckedException((Throwable)ex);
                    }
                }
            }, 10);
            try {
                qryExec.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
                Assert.assertThat((Object)IgniteCacheQueryH2IndexingLeakTest.getStatementCacheSize(qryProc), IgniteCacheQueryH2IndexingLeakTest.greaterOrEqualTo(10));
            }
            finally {
                exitLatch.countDown();
            }
            fut.get();
            IgniteCacheQueryH2IndexingLeakTest.assertTrue((String)"Unable to wait while statement cache will be cleared", (boolean)GridTestUtils.waitForCondition(() -> IgniteCacheQueryH2IndexingLeakTest.getStatementCacheSize(qryProc) == 0, (long)2000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaksInIgniteH2IndexingOnUnusedThread() throws Exception {
        GridQueryProcessor qryProc = this.grid(0).context().query();
        String qry = "select * from \"default\".Integer where _val >= \"default\".barrier()";
        for (int i = 0; i < 5; ++i) {
            this.info("Iteration #" + i);
            final CountDownLatch exitLatch = new CountDownLatch(1);
            final CountDownLatch qryExec = new CountDownLatch(10);
            IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

                public void applyx() throws IgniteCheckedException {
                    try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
                         Statement stmt = conn.createStatement();){
                        stmt.executeQuery("select * from \"default\".Integer where _val >= \"default\".barrier()").next();
                        qryExec.countDown();
                        U.await((CountDownLatch)exitLatch);
                    }
                    catch (SQLException ex) {
                        throw new IgniteCheckedException((Throwable)ex);
                    }
                }
            }, 10);
            try {
                qryExec.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
                Assert.assertThat((Object)IgniteCacheQueryH2IndexingLeakTest.getStatementCacheSize(qryProc), IgniteCacheQueryH2IndexingLeakTest.greaterOrEqualTo(10));
                IgniteCacheQueryH2IndexingLeakTest.assertTrue((String)"Unable to wait while statement cache will be cleared", (boolean)GridTestUtils.waitForCondition(() -> IgniteCacheQueryH2IndexingLeakTest.getStatementCacheSize(qryProc) == 0, (long)2000L));
            }
            finally {
                exitLatch.countDown();
            }
            fut.get();
        }
    }

    @QuerySqlFunction
    public static int barrier() {
        try {
            BARRIER.await();
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
        return 42;
    }

    private static <T extends Comparable<? super T>> Matcher<T> greaterOrEqualTo(final T wanted) {
        return new CustomMatcher<T>("should be greater or equal to " + wanted){

            public boolean matches(Object item) {
                return wanted != null && item instanceof Comparable && ((Comparable)item).compareTo(wanted) >= 0;
            }
        };
    }
}

