/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheOffheapIndexScanTest
extends GridCommonAbstractTest {
    private static IgniteCache<Integer, Object> cache;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cacheCfg = new CacheConfiguration("default");
        cacheCfg.setCacheMode(CacheMode.LOCAL);
        cacheCfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(1, false);
        cache = this.grid(0).cache("default");
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        cache = null;
    }

    @Test
    public void testQueryPlan() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)i, (Object)new Person(i, "firstName" + i, "lastName" + i, i % 100));
        }
        final AtomicBoolean end = new AtomicBoolean();
        IgniteInternalFuture fut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!end.get()) {
                    cache.query(new SqlFieldsQuery("select _val from Person")).getAll();
                }
                return null;
            }
        }, 5);
        for (int i = 0; i < 150; ++i) {
            String plan = (String)((List)cache.query(new SqlFieldsQuery("explain analyze select count(*) from Person where salary = 50")).getAll().get(0)).get(0);
            IgniteCacheOffheapIndexScanTest.assertTrue((String)plan, (boolean)plan.contains("scanCount: 11 "));
            Thread.sleep(100L);
        }
        end.set(true);
        fut.get();
    }

    public static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int orgId;
        @QuerySqlField
        private String firstName;
        @QuerySqlField
        private String lastName;
        @QuerySqlField(index=true)
        private double salary;

        public Person() {
        }

        public Person(int id, String firstName, String lastName, double salary) {
            this(id, 0, firstName, lastName, salary);
        }

        public Person(int id, int orgId, String firstName, String lastName, double salary) {
            this.id = id;
            this.orgId = orgId;
            this.firstName = firstName;
            this.lastName = lastName;
            this.salary = salary;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Person && this.id == ((Person)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Person [firstName=" + this.firstName + ", id=" + this.id + ", orgId=" + this.orgId + ", lastName=" + this.lastName + ", salary=" + this.salary + ']';
        }
    }
}

