/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class AffinityKeyNameAndValueFieldNameConflictTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "person";
    private Class<?> keyCls;
    private BiFunction<Integer, String, ?> keyProducer;
    private boolean qryEntityCfg;
    private boolean keyFieldSpecified;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration(PERSON_CACHE);
        if (this.qryEntityCfg) {
            CacheKeyConfiguration keyCfg = new CacheKeyConfiguration(this.keyCls.getName(), "name");
            cfg.setCacheKeyConfiguration(new CacheKeyConfiguration[]{keyCfg});
            QueryEntity entity = new QueryEntity();
            entity.setKeyType(this.keyCls.getName());
            entity.setValueType(Person.class.getName());
            if (this.keyFieldSpecified) {
                entity.setKeyFields(Stream.of("name").collect(Collectors.toSet()));
            }
            entity.addQueryField("id", Integer.class.getName(), null);
            entity.addQueryField("name", String.class.getName(), null);
            ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        } else {
            CacheKeyConfiguration keyCfg = new CacheKeyConfiguration(this.keyCls);
            cfg.setCacheKeyConfiguration(new CacheKeyConfiguration[]{keyCfg});
            ccfg.setIndexedTypes(new Class[]{this.keyCls, Person.class});
        }
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testQueryEntityConfig() throws Exception {
        this.qryEntityCfg = true;
        this.keyCls = PersonKey1.class;
        this.keyProducer = PersonKey1::new;
        this.checkQuery();
    }

    @Test
    public void testQueryEntityConfigKeySpecified() throws Exception {
        this.qryEntityCfg = true;
        this.keyFieldSpecified = true;
        this.keyCls = PersonKey1.class;
        this.keyProducer = PersonKey1::new;
        this.checkQuery();
    }

    @Test
    public void testAnnotationConfig() throws Exception {
        this.keyCls = PersonKey1.class;
        this.keyProducer = PersonKey1::new;
        this.checkQuery();
    }

    @Test
    public void testAnnotationConfigCollision() throws Exception {
        this.keyCls = PersonKey2.class;
        this.keyProducer = PersonKey2::new;
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AffinityKeyNameAndValueFieldNameConflictTest.this.checkQuery();
                return null;
            }
        }, CacheException.class, (String)"Property with name 'name' already exists for value");
    }

    private void checkQuery() throws Exception {
        this.startGrid(2);
        IgniteEx g = this.grid(2);
        IgniteCache personCache = g.cache(PERSON_CACHE);
        personCache.put(this.keyProducer.apply(1, "o1"), (Object)new Person("p1"));
        SqlFieldsQuery query = new SqlFieldsQuery("select * from \"person\"." + Person.class.getSimpleName() + " it where it.name=?");
        List result = personCache.query(query.setArgs(new Object[]{this.keyFieldSpecified ? "o1" : "p1"})).getAll();
        AffinityKeyNameAndValueFieldNameConflictTest.assertEquals((int)1, (int)result.size());
        this.stopAllGrids();
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        String name;

        public Person(String name) {
            this.name = name;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }

    public static class PersonKey2 {
        @QuerySqlField
        private int id;
        @QuerySqlField
        @AffinityKeyMapped
        private String name;

        public PersonKey2(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonKey2 other = (PersonKey2)o;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class PersonKey1 {
        @QuerySqlField
        private int id;
        @AffinityKeyMapped
        private String name;

        public PersonKey1(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonKey1 other = (PersonKey1)o;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

