/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mxbean;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.metric.UserQueriesTestBase;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Test;

public class SqlQueryMXBeanImplSqlFreeMemQuotaExceededTest
extends UserQueriesTestBase {
    @After
    public void stopAll() {
        this.stopAllGrids();
    }

    @Test
    public void testFreeMemoryAfterQuotaExceeded() throws Exception {
        int strongMemQuota = 0x100000;
        int memQuotaUnlimited = 0;
        this.startGridWithMaxMem(1, strongMemQuota);
        this.startGridWithMaxMem(0, memQuotaUnlimited, true);
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(0));
        String mapFailMsg = "SQL query ran out of memory: Global quota was exceeded.";
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            SqlMemoryQuotaExceededException cfr_ignored_0 = (SqlMemoryQuotaExceededException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB").setLazy(false)).getAll(), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Global quota was exceeded.");
        }, "failed");
        long freeMem = this.getValue("mxbean.SqlQueryMXBeanImplSqlFreeMemQuotaExceededTest1", "SQL Query", "SqlQueryMXBeanImpl", "SqlFreeMemoryBytes");
        long maxMem = this.getValue("mxbean.SqlQueryMXBeanImplSqlFreeMemQuotaExceededTest1", "SQL Query", "SqlQueryMXBeanImpl", "SqlGlobalMemoryQuotaBytes");
        if (freeMem < maxMem) {
            SqlQueryMXBeanImplSqlFreeMemQuotaExceededTest.fail((String)String.format("Expected no memory reserved: [freeMem=%d, maxMem=%d]", freeMem, maxMem));
        }
    }
}

