/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.metric.SqlStatisticsAbstractTest;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlStatisticsMemoryQuotaTest
extends SqlStatisticsAbstractTest {
    @After
    public void cleanUp() {
        this.stopAllGrids();
    }

    @Before
    public void setup() {
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.refresh();
    }

    @Test
    public void testAllMetricsValuesAfterGridStarts() throws Exception {
        this.startGrids(2);
        SqlStatisticsMemoryQuotaTest.assertEquals((long)0L, (long)this.longMetricValue(0, "requests"));
        SqlStatisticsMemoryQuotaTest.assertEquals((long)0L, (long)this.longMetricValue(1, "requests"));
        long dfltSqlGlobQuota = IgniteUtils.parseBytes((String)"60%");
        SqlStatisticsMemoryQuotaTest.assertTrue((boolean)this.almostEquals(dfltSqlGlobQuota, this.longMetricValue(0, "maxMem"), (long)((double)dfltSqlGlobQuota * 0.05)));
        SqlStatisticsMemoryQuotaTest.assertTrue((boolean)this.almostEquals(dfltSqlGlobQuota, this.longMetricValue(1, "maxMem"), (long)((double)dfltSqlGlobQuota * 0.05)));
        SqlStatisticsMemoryQuotaTest.assertEquals((long)this.longMetricValue(0, "maxMem"), (long)this.longMetricValue(0, "freeMem"));
        SqlStatisticsMemoryQuotaTest.assertEquals((long)this.longMetricValue(1, "maxMem"), (long)this.longMetricValue(1, "freeMem"));
    }

    @Test
    public void testRequestsMetricIsUpdatedAfterDistributedAndLocalQueries() throws Exception {
        this.startGrids(2);
        int connNodeIdx = 1;
        int otherNodeIdx = 0;
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(connNodeIdx));
        int runCnt = 10;
        String scanQry = "SELECT * FROM TAB WHERE ID <> 5";
        for (int i = 0; i < runCnt; ++i) {
            cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> 5").setLazy(false)).getAll();
        }
        long otherCntAfterDistQry = this.longMetricValue(otherNodeIdx, "requests");
        long connCntAfterDistQry = this.longMetricValue(connNodeIdx, "requests");
        SqlStatisticsMemoryQuotaTest.assertTrue((otherCntAfterDistQry >= (long)runCnt ? 1 : 0) != 0);
        SqlStatisticsMemoryQuotaTest.assertTrue((connCntAfterDistQry >= (long)runCnt ? 1 : 0) != 0);
        for (int i = 0; i < runCnt; ++i) {
            cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> 5").setLocal(true).setLazy(false)).getAll();
        }
        long otherCntAfterLocQry = this.longMetricValue(otherNodeIdx, "requests");
        long connCntAfterLocQry = this.longMetricValue(connNodeIdx, "requests");
        SqlStatisticsMemoryQuotaTest.assertTrue((otherCntAfterLocQry == otherCntAfterDistQry ? 1 : 0) != 0);
        SqlStatisticsMemoryQuotaTest.assertTrue((connCntAfterLocQry >= connCntAfterDistQry + (long)runCnt ? 1 : 0) != 0);
    }

    @Test
    public void testMemoryIsTrackedWhenDistributedQueryIsRunningAndReleasedOnFinish() throws Exception {
        this.startGrids(2);
        int connNodeIdx = 1;
        int otherNodeIdx = 0;
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(connNodeIdx));
        String scanQry = "SELECT * FROM TAB WHERE ID <> suspendHook(5)";
        IgniteInternalFuture distQryIsDone = this.runAsyncX(() -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> suspendHook(5)").setLazy(false)).getAll());
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.awaitQueryStopsInTheMiddle();
        this.validateMemoryUsageOn(connNodeIdx, MEMORY_IS_USED);
        this.validateMemoryUsageOn(otherNodeIdx, MEMORY_IS_USED);
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.resumeQueryExecution();
        distQryIsDone.get(15L, TimeUnit.SECONDS);
        this.validateMemoryUsageOn(connNodeIdx, MEMORY_IS_FREE);
        this.validateMemoryUsageOn(otherNodeIdx, MEMORY_IS_FREE);
    }

    @Test
    public void testMemoryIsTrackedWhenLocalQueryIsRunningAndReleasedOnFinish() throws Exception {
        this.startGrids(2);
        int connNodeIdx = 1;
        int otherNodeIdx = 0;
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(connNodeIdx));
        String scanQry = "SELECT * FROM TAB WHERE ID <> suspendHook(5)";
        IgniteInternalFuture locQryIsDone = this.runAsyncX(() -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> suspendHook(5)").setLocal(true).setLazy(false)).getAll());
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.awaitQueryStopsInTheMiddle();
        this.validateMemoryUsageOn(connNodeIdx, MEMORY_IS_USED);
        this.validateMemoryUsageOn(otherNodeIdx, MEMORY_IS_FREE);
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.resumeQueryExecution();
        locQryIsDone.get(15L, TimeUnit.SECONDS);
        this.validateMemoryUsageOn(connNodeIdx, MEMORY_IS_FREE);
        this.validateMemoryUsageOn(otherNodeIdx, MEMORY_IS_FREE);
    }

    @Test
    public void testMaxMemMetricShowCustomMaxMemoryValuesForDifferentNodes() throws Exception {
        int oneMaxMem = 524288;
        int otherMaxMem = 0x100000;
        boolean unlimMaxMem = false;
        boolean oneNodeIdx = false;
        boolean otherNodeIdx = true;
        int unlimNodeIdx = 2;
        this.startGridWithMaxMem(0, 524288L);
        this.startGridWithMaxMem(1, 0x100000L);
        this.startGridWithMaxMem(2, 0L);
        SqlStatisticsMemoryQuotaTest.assertEquals((long)524288L, (long)this.longMetricValue(0, "maxMem"));
        SqlStatisticsMemoryQuotaTest.assertEquals((long)0x100000L, (long)this.longMetricValue(1, "maxMem"));
        SqlStatisticsMemoryQuotaTest.assertEquals((long)0L, (long)this.longMetricValue(2, "maxMem"));
    }

    @Test
    public void testAllMetricsIfMemoryQuotaIsUnlimited() throws Exception {
        SqlStatisticsAbstractTest.MemValidator quotaUnlim = (free, max) -> {
            SqlStatisticsMemoryQuotaTest.assertEquals((long)0L, (long)max);
            SqlStatisticsMemoryQuotaTest.assertTrue((0L >= free ? 1 : 0) != 0);
        };
        int connNodeIdx = 1;
        int otherNodeIdx = 0;
        this.startGridWithMaxMem(connNodeIdx, 0L);
        this.startGridWithMaxMem(otherNodeIdx, 0L);
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(connNodeIdx));
        SqlFieldsQuery scanQry = new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> suspendHook(5)");
        IgniteInternalFuture distQryIsDone = this.runAsyncX(() -> cache.query(scanQry).getAll());
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.awaitQueryStopsInTheMiddle();
        this.validateMemoryUsageOn(connNodeIdx, quotaUnlim);
        this.validateMemoryUsageOn(otherNodeIdx, quotaUnlim);
        SqlStatisticsMemoryQuotaTest.assertEquals((long)(scanQry.isLazy() ? 0L : 1L), (long)this.longMetricValue(connNodeIdx, "requests"));
        SqlStatisticsMemoryQuotaTest.assertEquals((long)(scanQry.isLazy() ? 0L : 1L), (long)this.longMetricValue(otherNodeIdx, "requests"));
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.resumeQueryExecution();
        distQryIsDone.get(15L, TimeUnit.SECONDS);
        this.validateMemoryUsageOn(connNodeIdx, quotaUnlim);
        this.validateMemoryUsageOn(otherNodeIdx, quotaUnlim);
        SqlStatisticsMemoryQuotaTest.assertEquals((long)(scanQry.isLazy() ? 0L : 3L), (long)this.longMetricValue(connNodeIdx, "requests"));
        SqlStatisticsMemoryQuotaTest.assertEquals((long)(scanQry.isLazy() ? 0L : 3L), (long)this.longMetricValue(otherNodeIdx, "requests"));
    }

    private void validateMemoryUsageOn(int nodeIdx, SqlStatisticsAbstractTest.MemValidator validator) {
        long maxMem;
        long free = this.longMetricValue(nodeIdx, "freeMem");
        if (free > (maxMem = this.longMetricValue(nodeIdx, "maxMem"))) {
            SqlStatisticsMemoryQuotaTest.fail((String)String.format("Illegal state: there's more free memory (%s) than maximum available for sql (%s) on the node %d", free, maxMem, nodeIdx));
        }
        validator.validate(free, maxMem);
    }

    private long longMetricValue(int gridIdx, String metricName) {
        MetricRegistry sqlMemReg = this.grid(gridIdx).context().metric().registry("sql.memory.quotas");
        Metric metric = sqlMemReg.findMetric(metricName);
        Assert.assertNotNull((String)("Didn't find metric " + metricName), (Object)metric);
        Assert.assertTrue((String)("Expected long metric, but got " + metric.getClass()), (boolean)(metric instanceof LongMetric));
        return ((LongMetric)metric).value();
    }

    private boolean almostEquals(long l1, long l2, long error) {
        return Math.max(l1, l2) - Math.min(l1, l2) <= Math.abs(error);
    }
}

