/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;

class IndexPageCounter {
    private final IgniteEx grid;
    private final boolean persistenceEnabled;
    private final Map<Long, Long> pageIdToRotationId = new HashMap<Long, Long>();

    IndexPageCounter(IgniteEx grid, boolean persistenceEnabled) {
        this.grid = grid;
        this.persistenceEnabled = persistenceEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long countIdxPagesInMemory(int grpId) throws IgniteCheckedException {
        DataRegion dataRegion = this.grid.context().cache().context().database().dataRegion(null);
        PageMemory pageMemory = dataRegion.pageMemory();
        long idxPageCnt = 0L;
        int i = 0;
        while ((long)i < pageMemory.loadedPages()) {
            PageMemoryImpl pageMemoryImpl;
            long pageId = PageIdUtils.pageId((int)65535, (byte)0, (int)i);
            if (!this.persistenceEnabled || (pageMemoryImpl = (PageMemoryImpl)dataRegion.pageMemory()).hasLoadedPage(new FullPageId(pageId, grpId))) {
                long pageAddr = pageMemory.acquirePage(grpId, pageId);
                try {
                    long pageReadAddr = pageMemory.readLockForce(grpId, pageId, pageAddr);
                    try {
                        long rotationId = PageIdUtils.rotationId((long)PageIO.getPageId((long)pageReadAddr));
                        long prevRotationId = this.pageIdToRotationId.computeIfAbsent(pageId, id -> rotationId);
                        if (prevRotationId == rotationId && PageIO.isIndexPage((int)PageIO.getType((long)pageReadAddr))) {
                            ++idxPageCnt;
                        }
                    }
                    finally {
                        pageMemory.readUnlock(grpId, pageId, pageAddr);
                    }
                }
                finally {
                    pageMemory.releasePage(grpId, pageId, pageAddr);
                }
            }
            ++i;
        }
        return idxPageCnt;
    }
}

