/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Objects;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexQueryLocalTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String IDX = "PERSON_ID_IDX";
    private static final int CNT = 10000;
    private static Ignite crd;

    protected void beforeTestsStarted() throws Exception {
        crd = this.startGrids(4);
    }

    protected void afterTest() throws Exception {
        crd.cache(CACHE).destroy();
    }

    @Test
    public void testServerNodeReplicatedCache() {
        IgniteCache cache = crd.createCache(this.ccfg(CacheMode.REPLICATED));
        this.insertData(crd, (IgniteCache<Long, Person>)cache);
        IndexQuery qry = new IndexQuery(Person.class, IDX).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)5000)});
        for (int i = 0; i < 4; ++i) {
            cache = this.grid(i).cache(CACHE);
            int result = cache.query(qry.setLocal(true)).getAll().size();
            IndexQueryLocalTest.assertEquals((int)5000, (int)result);
        }
    }

    @Test
    public void testServerNodePartitionedCache() {
        IgniteCache cache = crd.createCache(this.ccfg(CacheMode.PARTITIONED));
        this.insertData(crd, (IgniteCache<Long, Person>)cache);
        IndexQuery qry = new IndexQuery(Person.class, IDX).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)5000)});
        int resultSize = 0;
        for (int i = 0; i < 4; ++i) {
            cache = this.grid(i).cache(CACHE);
            int result = cache.query(qry.setLocal(true)).getAll().size();
            resultSize += result;
            IndexQueryLocalTest.assertTrue((5000 > result ? 1 : 0) != 0);
        }
        IndexQueryLocalTest.assertEquals((int)5000, (int)resultSize);
    }

    @Test
    public void testClientNodeReplicatedCache() throws Exception {
        IgniteEx cln = this.startClientGrid(5);
        IgniteCache cache = cln.createCache(this.ccfg(CacheMode.REPLICATED));
        this.insertData((Ignite)cln, (IgniteCache<Long, Person>)cache);
        IndexQuery qry = new IndexQuery(Person.class, IDX).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)5000)});
        GridTestUtils.assertThrows(null, () -> cache.query(qry.setLocal(true)).getAll(), CacheException.class, (String)"Execution of local IndexQuery on client node disallowed.");
    }

    private void insertData(Ignite ignite, IgniteCache<Long, Person> cache) {
        try (IgniteDataStreamer streamer = ignite.dataStreamer(cache.getName());){
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)new Person(i));
            }
        }
    }

    private CacheConfiguration<Long, Person> ccfg(CacheMode cacheMode) {
        return new CacheConfiguration().setName(CACHE).setIndexedTypes(new Class[]{Long.class, Person.class}).setCacheMode(cacheMode).setBackups(2);
    }

    private static class Person {
        @QuerySqlField(index=true)
        final int id;

        Person(int id) {
            this.id = id;
        }

        public String toString() {
            return "Person[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

