/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.cache.CacheException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexQueryCacheKeyValueFieldsTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final int CNT = 10000;

    protected boolean escape() {
        return false;
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(2);
        try (IgniteDataStreamer streamer = crd.dataStreamer(CACHE);){
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)IndexQueryCacheKeyValueFieldsTest.key(i), (Object)i);
            }
        }
    }

    protected IgniteConfiguration getConfiguration(String instanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("f1", "java.lang.String");
        fields.put("f2", "java.lang.Integer");
        QueryEntity qryEntity = new QueryEntity().setKeyFieldName("f1").setValueFieldName("f2").setTableName("TEST").setKeyType(String.class.getName()).setValueType(Integer.class.getName()).setFields(fields).setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("f1"), new QueryIndex("f2"), new QueryIndex("_VAL")}));
        return cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(CACHE).setSqlEscapeAll(this.escape()).setQueryEntities((Collection)F.asList((Object)qryEntity))});
    }

    @Test
    public void testValueAliasField() {
        this.check("f2", false);
    }

    @Test
    public void testValueAliasUpperField() {
        if (this.escape()) {
            this.failOnEscape("F2", false);
        } else {
            this.check("F2", false);
        }
    }

    @Test
    public void testValueField() {
        this.check("_VAL", false);
    }

    @Test
    public void testValueLowerField() {
        this.check("_val", false);
    }

    @Test
    public void testKeyAliasField() {
        this.check("f1", true);
    }

    @Test
    public void testKeyAliasUpperField() {
        if (this.escape()) {
            this.failOnEscape("F1", true);
        } else {
            this.check("F1", true);
        }
    }

    @Test
    public void testKeyField() {
        this.check("_KEY", true);
    }

    @Test
    public void testKeyLowerField() {
        this.check("_key", true);
    }

    private void check(String fld, boolean key) {
        int pivot = new Random().nextInt(5000);
        QueryCursor cursor = this.grid(0).cache(CACHE).query((Query)new IndexQuery(Integer.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)fld, (Object)(key ? IndexQueryCacheKeyValueFieldsTest.key(pivot) : Integer.valueOf(pivot)))}));
        IndexQueryCacheKeyValueFieldsTest.assertEquals((int)(10000 - pivot - 1), (int)cursor.getAll().size());
    }

    private void failOnEscape(String fld, boolean key) {
        GridTestUtils.assertThrows(null, () -> this.grid(0).cache(CACHE).query((Query)new IndexQuery(Integer.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)fld, (Object)(key ? IndexQueryCacheKeyValueFieldsTest.key(0) : Integer.valueOf(0)))})).getAll(), CacheException.class, (String)("Column \"" + fld + "\" not found"));
    }

    private static String key(int val) {
        return String.format("key_%1$5s", val).replace(' ', '0');
    }
}

