/*
 * Copyright 2021 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnPartitionDataView;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link StatisticsColumnPartitionDataView} attributes walker.
 * 
 * @see StatisticsColumnPartitionDataView
 */
public class StatisticsColumnPartitionDataViewWalker implements SystemViewRowAttributeWalker<StatisticsColumnPartitionDataView> {
    /** Filter key for attribute "schema" */
    public static final String SCHEMA_FILTER = "schema";

    /** Filter key for attribute "type" */
    public static final String TYPE_FILTER = "type";

    /** Filter key for attribute "name" */
    public static final String NAME_FILTER = "name";

    /** Filter key for attribute "column" */
    public static final String COLUMN_FILTER = "column";

    /** Filter key for attribute "partition" */
    public static final String PARTITION_FILTER = "partition";

    /** List of filtrable attributes. */
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(
        "schema", "type", "name", "column", "partition"
    ));

    /** {@inheritDoc} */
    @Override public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "schema", String.class);
        v.accept(1, "type", String.class);
        v.accept(2, "name", String.class);
        v.accept(3, "column", String.class);
        v.accept(4, "partition", int.class);
        v.accept(5, "rowsCount", long.class);
        v.accept(6, "updateCounter", long.class);
        v.accept(7, "distinct", long.class);
        v.accept(8, "nulls", long.class);
        v.accept(9, "total", long.class);
        v.accept(10, "size", int.class);
        v.accept(11, "version", long.class);
        v.accept(12, "lastUpdateTime", long.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(StatisticsColumnPartitionDataView row, AttributeWithValueVisitor v) {
        v.accept(0, "schema", String.class, row.schema());
        v.accept(1, "type", String.class, row.type());
        v.accept(2, "name", String.class, row.name());
        v.accept(3, "column", String.class, row.column());
        v.acceptInt(4, "partition", row.partition());
        v.acceptLong(5, "rowsCount", row.rowsCount());
        v.acceptLong(6, "updateCounter", row.updateCounter());
        v.acceptLong(7, "distinct", row.distinct());
        v.acceptLong(8, "nulls", row.nulls());
        v.acceptLong(9, "total", row.total());
        v.acceptInt(10, "size", row.size());
        v.acceptLong(11, "version", row.version());
        v.acceptLong(12, "lastUpdateTime", row.lastUpdateTime());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 13;
    }
}
