/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.cache.CacheException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.F;

public abstract class TopologyLock {
    protected final GridKernalContext ctx;

    public static TopologyLock forCaches(GridKernalContext ctx, List<Integer> cacheIds) {
        assert (!F.isEmpty(cacheIds));
        if (cacheIds.size() == 1) {
            return new SingleGroupTopologyLock(ctx, TopologyLock.cacheContext(ctx, cacheIds.get(0)).groupId());
        }
        TreeSet<Integer> sortedGroupIdSet = new TreeSet<Integer>();
        for (int cacheId : cacheIds) {
            sortedGroupIdSet.add(TopologyLock.cacheContext(ctx, cacheId).groupId());
        }
        if (sortedGroupIdSet.size() == 1) {
            return new SingleGroupTopologyLock(ctx, (Integer)sortedGroupIdSet.first());
        }
        return new MultiGroupTopologyLock(ctx, sortedGroupIdSet);
    }

    public abstract void lock();

    public abstract void unlock();

    protected TopologyLock(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    private static GridCacheContext<Object, Object> cacheContext(GridKernalContext ctx, Integer cacheId) {
        GridCacheContext cctx = ctx.cache().context().cacheContext(cacheId.intValue());
        if (cctx != null) {
            return cctx;
        }
        throw new CacheException(String.format("Cache not found on local node (was concurrently destroyed?) [cacheId=%d]", cacheId));
    }

    private static CacheGroupContext groupContext(GridKernalContext ctx, int groupId) {
        CacheGroupContext grp = ctx.cache().cacheGroup(groupId);
        if (grp != null) {
            return grp;
        }
        throw new CacheException(String.format("CacheGroup not found on local node (was concurrently destroyed?) [groupId=%d]", groupId));
    }

    private static class MultiGroupTopologyLock
    extends TopologyLock {
        private final Collection<Integer> groupIds;
        private final List<Integer> locked;

        MultiGroupTopologyLock(GridKernalContext ctx, Collection<Integer> groupIds) {
            super(ctx);
            this.groupIds = groupIds;
            this.locked = new ArrayList<Integer>(groupIds.size());
        }

        @Override
        public void lock() {
            try {
                for (int id : this.groupIds) {
                    CacheGroupContext grp = TopologyLock.groupContext(this.ctx, id);
                    grp.topology().readLock();
                    this.locked.add(id);
                }
            }
            catch (Throwable th) {
                this.unlock();
                throw th;
            }
        }

        @Override
        public void unlock() {
            for (int id : this.locked) {
                CacheGroupContext grp = this.ctx.cache().cacheGroup(id);
                if (grp == null) continue;
                grp.topology().readUnlock();
            }
            this.locked.clear();
        }
    }

    private static class SingleGroupTopologyLock
    extends TopologyLock {
        private final int groupId;

        SingleGroupTopologyLock(GridKernalContext ctx, int groupId) {
            super(ctx);
            this.groupId = groupId;
        }

        @Override
        public void lock() {
            TopologyLock.groupContext(this.ctx, this.groupId).topology().readLock();
        }

        @Override
        public void unlock() {
            TopologyLock.groupContext(this.ctx, this.groupId).topology().readUnlock();
        }
    }
}

