/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.SqlBuilderContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.gridgain.internal.h2.table.Column;

class IndexQuerySqlBuilderContext
implements SqlBuilderContext {
    private final List<Object> arguments;
    private final GridH2Table table;

    IndexQuerySqlBuilderContext(GridH2Table table, List<Object> arguments) {
        this.arguments = arguments;
        this.table = table;
    }

    public void addArgument(Object arg) {
        this.arguments.add(arg);
    }

    public SqlBuilderContext.ColumnDescriptor resolveColumn(String name) {
        Column column = this.resolveH2Column(name, this.table);
        return new ColumnDescriptorImpl("\"" + column.getName() + "\"", column.isNullable());
    }

    private Column resolveH2Column(String name, GridH2Table table) {
        String upperName = name.toUpperCase();
        if (table.doesColumnExist(name)) {
            return table.getColumn(name);
        }
        if (table.doesColumnExist(upperName)) {
            return table.getColumn(upperName);
        }
        throw new IgniteException("Column \"" + upperName + "\" not found.");
    }

    private static class ColumnDescriptorImpl
    implements SqlBuilderContext.ColumnDescriptor {
        private final String name;
        private final boolean nullable;

        private ColumnDescriptorImpl(String name, boolean nullable) {
            this.name = name;
            this.nullable = nullable;
        }

        public String name() {
            return this.name;
        }

        public boolean nullable() {
            return this.nullable;
        }
    }
}

