/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2QueryFetchSizeInterceptor;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.jdbc.JdbcResultSet;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;

public abstract class H2ResultSetIterator<T>
extends GridIteratorAdapter<T>
implements GridCloseableIterator<T> {
    private static final Field RESULT_FIELD;
    private static final long serialVersionUID = 0L;
    private ResultInterface res;
    private ResultSet data;
    protected Object[] row;
    private List<Object[]> page;
    private boolean hasRow;
    private int pageSize;
    private final int colCnt;
    private Iterator<Object[]> rowIter;
    private final Session ses;
    private boolean closed;
    private boolean canceled;
    final H2QueryFetchSizeInterceptor fetchSizeInterceptor;
    protected final Tracing tracing;
    private final H2QueryInfo qryInfo;
    final IgniteH2Indexing h2;

    protected H2ResultSetIterator(ResultSet data, int pageSize, IgniteLogger log, IgniteH2Indexing h2, H2QueryInfo qryInfo, Tracing tracing) throws IgniteCheckedException {
        this.data = data;
        this.pageSize = pageSize;
        this.tracing = tracing;
        this.qryInfo = qryInfo;
        this.h2 = h2;
        try {
            this.res = (ResultInterface)RESULT_FIELD.get(data);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (data != null) {
            try {
                this.colCnt = data.getMetaData().getColumnCount();
                this.ses = H2Utils.session(data.getStatement().getConnection());
                this.page = new ArrayList<Object[]>(pageSize);
            }
            catch (SQLException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        } else {
            this.colCnt = 0;
            this.page = null;
            this.row = null;
            this.ses = null;
        }
        assert (log != null);
        assert (h2 != null);
        assert (qryInfo != null);
        this.fetchSizeInterceptor = new H2QueryFetchSizeInterceptor(h2, qryInfo, log);
    }

    /*
     * Exception decompiling
     */
    private boolean fetchPage() throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 29[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void readRow() throws SQLException {
        if (this.res != null) {
            Value[] values = this.res.currentRow();
            for (int c = 0; c < this.row.length; ++c) {
                Value val = values[c];
                if (val instanceof GridH2ValueCacheObject) {
                    GridH2ValueCacheObject valCacheObj = (GridH2ValueCacheObject)values[c];
                    this.row[c] = valCacheObj.getObject(true);
                    continue;
                }
                this.row[c] = DataType.isIntervalType((int)val.getValueType()) ? Long.valueOf(val.getLong()) : val.getObject();
            }
        } else {
            for (int c = 0; c < this.row.length; ++c) {
                this.row[c] = this.data.getObject(c + 1);
            }
        }
    }

    public void lockTables() {
        if (this.ses.isLazyQueryExecution() && !this.isClosed()) {
            GridH2Table.readLockTables(this.ses);
        }
    }

    public void unlockTables() {
        if (this.ses.isLazyQueryExecution()) {
            GridH2Table.unlockTables(this.ses);
        }
    }

    private synchronized boolean fetchNext() throws IgniteCheckedException {
        if (this.canceled) {
            throw new QueryCancelledException();
        }
        if (this.rowIter != null && this.rowIter.hasNext()) {
            this.row = this.rowIter.next();
            this.fetchSizeInterceptor.checkOnFetchNext();
            return true;
        }
        if (!this.fetchPage()) {
            this.closeInternal();
            return false;
        }
        if (this.rowIter != null && this.rowIter.hasNext()) {
            this.row = this.rowIter.next();
            this.fetchSizeInterceptor.checkOnFetchNext();
            return true;
        }
        return false;
    }

    protected abstract T createRow();

    public void onClose() throws IgniteCheckedException {
        if (this.data == null) {
            return;
        }
        this.lockTables();
        if (this.qryInfo != null) {
            this.h2.longRunningQueries().unregisterQuery(this.qryInfo, null);
        }
        try {
            this.fetchSizeInterceptor.checkOnClose();
            this.data.close();
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
        finally {
            this.res = null;
            this.data = null;
            this.page = null;
            this.unlockTables();
        }
    }

    public synchronized void close() throws IgniteCheckedException {
        if (this.closed) {
            return;
        }
        this.canceled = true;
        this.closeInternal();
    }

    private synchronized void closeInternal() throws IgniteCheckedException {
        if (this.closed) {
            return;
        }
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.tracing.create(SpanType.SQL_ITER_CLOSE, MTC.span()));){
            this.closed = true;
            this.onClose();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean hasNextX() throws IgniteCheckedException {
        if (this.canceled) {
            throw new QueryCancelledException();
        }
        if (this.closed) {
            return false;
        }
        return this.hasRow || (this.hasRow = ((Boolean)this.h2.executeWithResumableTimeTracking(this::fetchNext, this.qryInfo)).booleanValue());
    }

    public T nextX() throws IgniteCheckedException {
        if (!this.hasNextX()) {
            throw new NoSuchElementException();
        }
        this.hasRow = false;
        return this.createRow();
    }

    public void removeX() throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(H2ResultSetIterator.class, (Object)((Object)this));
    }

    private /* synthetic */ String lambda$fetchPage$0() {
        return Integer.toString(this.page.size());
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }
}

