/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.io.Serializable;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;

public abstract class StatisticsStorageAbstractTest
extends StatisticsAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true));
        cfg.setDataStorageConfiguration(memCfg);
        return cfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGrid(0);
        this.startGrid(1);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.grid(0).getOrCreateCache("default");
        this.sql("DROP TABLE IF EXISTS small");
        this.sql("CREATE TABLE small (a INT PRIMARY KEY, b INT, c INT)");
        this.sql("CREATE INDEX small_b ON small(b)");
        this.sql("CREATE INDEX small_c ON small(c)");
        for (int i = 0; i < 100; ++i) {
            this.sql("INSERT INTO small(a, b, c) VALUES(" + i + "," + i + "," + i % 10 + ")");
        }
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }
}

