/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.io.Serializable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.util.typedef.internal.U;

public class StatisticsRestartAbstractTest
extends StatisticsAbstractTest {
    protected StatisticsTarget SMALL_TARGET = new StatisticsTarget("PUBLIC", "SMALL", new String[0]);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true));
        cfg.setDataStorageConfiguration(memCfg);
        return cfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.startGrids(this.nodes());
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        U.sleep((long)100L);
        this.grid(0).getOrCreateCache("default");
        this.createStatisticTarget(null);
        this.collectStatistics(this.SMALL_TARGET);
    }

    protected StatisticsTarget createStatisticTarget(Integer idx) {
        String strIdx = idx == null ? "" : String.valueOf(idx);
        this.createSmallTable(strIdx);
        return new StatisticsTarget("PUBLIC", "SMALL" + strIdx, new String[0]);
    }

    protected void beforeTest() throws IgniteCheckedException {
        this.updateStatistics(this.SMALL_TARGET);
    }

    public int nodes() {
        return 1;
    }
}

