/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PSUValueDistributionTableStatisticsUsageTest
extends StatisticsAbstractTest {
    @Parameterized.Parameter(value=0)
    public CacheMode cacheMode;

    @Parameterized.Parameters(name="cacheMode={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({CacheMode.REPLICATED}, {CacheMode.PARTITIONED});
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        Ignite node = this.startGridsMultiThreaded(2);
        node.getOrCreateCache("default");
    }

    protected void beforeTest() throws Exception {
        this.sql("DROP TABLE IF EXISTS sized");
        this.sql("CREATE TABLE sized (ID INT PRIMARY KEY, small VARCHAR, small_nulls VARCHAR, big VARCHAR, big_nulls VARCHAR) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.sql("CREATE INDEX sized_small ON sized(small)");
        this.sql("CREATE INDEX sized_small_nulls ON sized(small_nulls)");
        this.sql("CREATE INDEX sized_big ON sized(big)");
        this.sql("CREATE INDEX sized_big_nulls ON sized(big_nulls)");
        String bigVal = "someBigLongValueWithTheSameTextAtFirst";
        for (int i = 0; i < 1000; ++i) {
            int valAdd;
            String bigNulls;
            String smallNulls;
            if ((i & 1) == 0) {
                smallNulls = "null";
                bigNulls = null;
                valAdd = 0;
            } else {
                smallNulls = String.format("'small%d'", i);
                bigNulls = String.format("'%s%d'", bigVal, i);
                valAdd = 1;
            }
            String sql = String.format("INSERT INTO sized(id, small, small_nulls, big, big_nulls) VALUES(%d,'small%d', %s, '%s%d', %s)", i, i + valAdd, smallNulls, bigVal, i + valAdd, bigNulls);
            this.sql(sql);
        }
        this.sql("INSERT INTO sized(id, small, big) VALUES(1000, null, null)");
        this.collectStatistics("sized");
    }

    @Test
    public void selectNullCond() {
        String sql = "select count(*) from sized i1 where small is null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"SIZED_SMALL"}, sql, new String[1][]);
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-31183")
    @Test
    public void selectNotNullCond() {
        String sql = "select count(*) from sized i1 where small is not null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"SIZED_SMALL"}, sql, new String[1][]);
    }

    @Test
    public void selectWithNullsDistributionCond() {
        String sql = "select * from sized i1 where small is null and small_nulls is null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"SIZED_SMALL"}, sql, new String[1][]);
    }

    @Test
    public void selectWithValueNullsDistributionCond() {
        String sql = "select * from sized i1 where small = '1'";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"SIZED_SMALL"}, sql, new String[1][]);
        String sql2 = "select * from sized i1 where small = '1' and small_nulls = '1'";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"SIZED_SMALL_NULLS"}, sql2, new String[1][]);
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-31184")
    @Test
    public void selectWithValueSizeCond() {
        String sql = "select * from sized i1 where big = '1' and small = '1'";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"SIZED_SMALL"}, sql, new String[1][]);
        String sql2 = "select * from sized i1 where big_nulls = '1' and small_nulls = '1'";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"SIZED_SMALL_NULLS"}, sql2, new String[1][]);
    }
}

