/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.metastorage.persistence.ReadWriteMetaStorageMock;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsInMemoryStoreImpl;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsPersistenceStoreImpl;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsRepository;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsObsolescence;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.logger.GridTestLog4jLogger;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class IgniteStatisticsRepositoryTest
extends StatisticsAbstractTest {
    protected static final StatisticsKey K1 = new StatisticsKey("PUBLIC", "tab1");
    protected static final StatisticsKey K2 = new StatisticsKey("PUBLIC", "tab2");
    protected ColumnStatistics cs1 = new ColumnStatistics(null, null, 100L, 0L, 100L, 0, new byte[0], 0L, U.currentTimeMillis());
    protected ColumnStatistics cs2 = new ColumnStatistics((Value)ValueInt.get((int)0), (Value)ValueInt.get((int)100), 0L, 100L, 100L, 4, new byte[0], 0L, U.currentTimeMillis());
    protected ColumnStatistics cs3 = new ColumnStatistics(null, null, 0L, 0L, 0L, 0, new byte[0], 0L, U.currentTimeMillis());
    protected ColumnStatistics cs4 = new ColumnStatistics((Value)ValueInt.get((int)0), (Value)ValueInt.get((int)10), 0L, 10L, 100L, 4, new byte[0], 0L, U.currentTimeMillis());
    @Parameterized.Parameter(value=0)
    public boolean persist;
    @Parameterized.Parameter(value=1)
    public IgniteStatisticsRepository repo;

    @Parameterized.Parameters(name="persist={0}")
    public static List<Object[]> parameters() throws IgniteCheckedException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        IgniteStatisticsInMemoryStoreImpl storeInMemory = new IgniteStatisticsInMemoryStoreImpl(IgniteStatisticsRepositoryTest::getLogger);
        GridSystemViewManager sysViewMgr = (GridSystemViewManager)Mockito.mock(GridSystemViewManager.class);
        IgniteStatisticsRepository inMemRepo = new IgniteStatisticsRepository((IgniteStatisticsStore)storeInMemory, sysViewMgr, null, IgniteStatisticsRepositoryTest::getLogger);
        params.add(new Object[]{false, inMemRepo});
        MetastorageLifecycleListener[] lsnr = new MetastorageLifecycleListener[1];
        GridInternalSubscriptionProcessor subscriptionProcessor = (GridInternalSubscriptionProcessor)Mockito.mock(GridInternalSubscriptionProcessor.class);
        ((GridInternalSubscriptionProcessor)Mockito.doAnswer(invocation -> {
            lsnr[0] = (MetastorageLifecycleListener)invocation.getArgument(0);
            return lsnr[0];
        }).when((Object)subscriptionProcessor)).registerMetastorageListener((MetastorageLifecycleListener)Mockito.any(MetastorageLifecycleListener.class));
        IgniteCacheDatabaseSharedManager db = (IgniteCacheDatabaseSharedManager)Mockito.mock(IgniteCacheDatabaseSharedManager.class);
        IgniteStatisticsRepository[] statsRepos = new IgniteStatisticsRepository[1];
        IgniteStatisticsPersistenceStoreImpl storePersistent = new IgniteStatisticsPersistenceStoreImpl(subscriptionProcessor, db, IgniteStatisticsRepositoryTest::getLogger);
        IgniteStatisticsHelper helper = (IgniteStatisticsHelper)Mockito.mock(IgniteStatisticsHelper.class);
        statsRepos[0] = new IgniteStatisticsRepository((IgniteStatisticsStore)storePersistent, sysViewMgr, helper, IgniteStatisticsRepositoryTest::getLogger);
        ReadWriteMetaStorageMock metastorage = new ReadWriteMetaStorageMock();
        lsnr[0].onReadyForReadWrite((ReadWriteMetastorage)metastorage);
        params.add(new Object[]{true, statsRepos[0]});
        return params;
    }

    private static IgniteLogger getLogger(Class cls) {
        return new GridTestLog4jLogger();
    }

    @Test
    public void testRepositoryPartitions() {
        ObjectPartitionStatisticsImpl stat1 = this.getPartitionStatistics(1);
        ObjectPartitionStatisticsImpl stat10 = this.getPartitionStatistics(10);
        ObjectPartitionStatisticsImpl stat1_2 = this.getPartitionStatistics(1);
        IgniteStatisticsRepositoryTest.assertTrue((boolean)this.repo.getLocalPartitionsStatistics(K1).isEmpty());
        IgniteStatisticsRepositoryTest.assertTrue((boolean)this.repo.getLocalPartitionsStatistics(K2).isEmpty());
        IgniteStatisticsStore store = this.repo.statisticsStore();
        store.saveLocalPartitionStatistics(K1, stat1);
        store.saveLocalPartitionStatistics(K1, stat10);
        store.saveLocalPartitionStatistics(K2, stat1_2);
        ObjectPartitionStatisticsImpl stat1Readed = this.repo.getLocalPartitionStatistics(K1, 1);
        IgniteStatisticsRepositoryTest.assertNotNull((Object)stat1Readed);
        IgniteStatisticsRepositoryTest.assertEquals((int)1, (int)stat1Readed.partId());
        ObjectPartitionStatisticsImpl stat10Readed = this.repo.getLocalPartitionStatistics(K1, 10);
        IgniteStatisticsRepositoryTest.assertNotNull((Object)stat10Readed);
        IgniteStatisticsRepositoryTest.assertEquals((int)10, (int)stat10Readed.partId());
        IgniteStatisticsRepositoryTest.assertNull((Object)this.repo.getLocalPartitionStatistics(K1, 2));
        IgniteStatisticsRepositoryTest.assertEquals((int)2, (int)this.repo.getLocalPartitionsStatistics(K1).size());
        IgniteStatisticsRepositoryTest.assertEquals((int)1, (int)this.repo.getLocalPartitionsStatistics(K2).size());
    }

    @Test
    public void testClearLocalPartitionIdsStatistics() {
        ObjectPartitionStatisticsImpl stat1 = this.getPartitionStatistics(1);
        ObjectPartitionStatisticsImpl stat10 = this.getPartitionStatistics(10);
        ObjectPartitionStatisticsImpl stat100 = this.getPartitionStatistics(100);
        IgniteStatisticsStore store = this.repo.statisticsStore();
        store.saveLocalPartitionStatistics(K1, stat1);
        store.saveLocalPartitionStatistics(K1, stat10);
        store.saveLocalPartitionStatistics(K1, stat100);
        IgniteStatisticsRepositoryTest.assertNotNull((Object)this.repo.getLocalPartitionStatistics(K1, 10));
        this.repo.clearLocalPartitionsStatistics(K1, IgniteStatisticsRepositoryTest.setOf(1, 2, 10));
        IgniteStatisticsRepositoryTest.assertNull((Object)this.repo.getLocalPartitionStatistics(K1, 10));
        IgniteStatisticsRepositoryTest.assertNotNull((Object)this.repo.getLocalPartitionStatistics(K1, 100));
    }

    @Test
    public void testLocalStatistics() {
        ObjectStatisticsImpl stat1 = this.getStatistics();
        ObjectStatisticsImpl stat2 = this.getStatistics();
        this.repo.saveLocalStatistics(K1, stat1);
        this.repo.saveLocalStatistics(K2, stat2);
        IgniteStatisticsRepositoryTest.assertEquals((Object)stat1, (Object)this.repo.getLocalStatistics(K1));
        IgniteStatisticsRepositoryTest.assertEquals((Object)stat1, (Object)this.repo.getLocalStatistics(K2));
        this.repo.clearLocalPartitionsStatistics(K1, null);
        IgniteStatisticsRepositoryTest.assertNull((Object)this.repo.getLocalStatistics(K1));
        IgniteStatisticsRepositoryTest.assertEquals((Object)stat2, (Object)this.repo.getLocalStatistics(K2));
    }

    @Test
    public void testRefreshObsolescence() {
        IgniteStatisticsStore store = this.repo.statisticsStore();
        this.repo.stop();
        store.clearAllStatistics();
        this.repo.start();
        this.repo.refreshObsolescence(K1, 1);
        List keys = this.repo.getObsolescenceKeys();
        IgniteStatisticsRepositoryTest.assertEquals((int)1, (int)keys.size());
        Map allObs = store.loadAllObsolescence();
        IgniteStatisticsRepositoryTest.assertNotNull(allObs.get(K1));
        this.repo.getObsolescence(K1, 1).onModified(new byte[]{1, 2, 3});
        this.repo.saveObsolescenceInfo(K1);
        allObs = store.loadAllObsolescence();
        IgniteStatisticsRepositoryTest.assertEquals((long)1L, (long)((ObjectPartitionStatisticsObsolescence)((IntMap)allObs.get(K1)).get(1)).modified());
        IgniteStatisticsRepositoryTest.assertFalse((boolean)this.repo.getObsolescence(K1, 1).dirty());
    }

    @Test
    public void testSaveObsolescenceInfo() {
        IgniteStatisticsStore store = this.repo.statisticsStore();
        Map statObs = (Map)GridTestUtils.getFieldValue((Object)this.repo, (String[])new String[]{"statObs"});
        this.repo.refreshObsolescence(K1, 2);
        this.repo.saveObsolescenceInfo(K1);
        IgniteStatisticsRepositoryTest.assertNotNull((Object)((IntMap)statObs.get(K1)).get(2));
    }
}

