/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionDataTypeUtils;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterType;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.message.DbException;
import org.junit.Test;

public class SqlDataTypeConversionTest
extends GridCommonAbstractTest {
    private static final Map<PartitionParameterType, Class<?>> PARAMETER_TYPE_TO_JAVA_CLASS;
    private static final Map<PartitionParameterType, Integer> IGNITE_PARAMETER_TYPE_TO_H2_PARAMETER_TYPE;
    private static IgniteH2Indexing idx;

    protected void beforeTestsStarted() throws Exception {
        idx = (IgniteH2Indexing)this.startGrid(0).context().query().getIndexing();
    }

    @Test
    public void convertNull() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(null, new PartitionParameterType[0]);
    }

    @Test
    public void convertBoolean() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Boolean.TRUE, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Boolean.FALSE, new PartitionParameterType[0]);
    }

    @Test
    public void convertByte() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((byte)42, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((byte)0, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((byte)-128, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((byte)127, PartitionParameterType.UUID);
        SqlDataTypeConversionTest.assertEquals((Object)PartitionDataTypeUtils.CONVERTATION_FAILURE, (Object)PartitionDataTypeUtils.convert((Object)42, (PartitionParameterType)PartitionParameterType.UUID));
    }

    @Test
    public void convertShort() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((short)42, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((short)0, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((short)Short.MIN_VALUE, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2((short)Short.MAX_VALUE, PartitionParameterType.UUID);
        SqlDataTypeConversionTest.assertEquals((Object)PartitionDataTypeUtils.CONVERTATION_FAILURE, (Object)PartitionDataTypeUtils.convert((Object)42, (PartitionParameterType)PartitionParameterType.UUID));
    }

    @Test
    public void convertInteger() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(42, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(0, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Integer.MIN_VALUE, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Integer.MAX_VALUE, PartitionParameterType.UUID);
        SqlDataTypeConversionTest.assertEquals((Object)PartitionDataTypeUtils.CONVERTATION_FAILURE, (Object)PartitionDataTypeUtils.convert((Object)42, (PartitionParameterType)PartitionParameterType.UUID));
    }

    @Test
    public void convertLong() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(42L, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(0L, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Long.MIN_VALUE, PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Long.MAX_VALUE, PartitionParameterType.UUID);
        SqlDataTypeConversionTest.assertEquals((Object)PartitionDataTypeUtils.CONVERTATION_FAILURE, (Object)PartitionDataTypeUtils.convert((Object)42L, (PartitionParameterType)PartitionParameterType.UUID));
    }

    @Test
    public void convertFloat() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(42.1f), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(0.1f), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(0.0f), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(1.2345678E7f), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(Float.POSITIVE_INFINITY), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(Float.NEGATIVE_INFINITY), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(Float.NaN), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(Float.MIN_VALUE), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Float.valueOf(Float.MAX_VALUE), new PartitionParameterType[0]);
    }

    @Test
    public void convertDouble() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(42.2, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(0.2, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(0.0, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(1.2345678E7, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Double.POSITIVE_INFINITY, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Double.NEGATIVE_INFINITY, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Double.NaN, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Double.MIN_VALUE, new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(Double.MAX_VALUE, new PartitionParameterType[0]);
    }

    @Test
    public void convertString() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("42", PartitionParameterType.BOOLEAN);
        SqlDataTypeConversionTest.assertEquals((Object)PartitionDataTypeUtils.CONVERTATION_FAILURE, (Object)PartitionDataTypeUtils.convert((Object)"42", (PartitionParameterType)PartitionParameterType.BOOLEAN));
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("0", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("1", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("42.3", PartitionParameterType.BOOLEAN);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("0.3", PartitionParameterType.BOOLEAN);
        SqlDataTypeConversionTest.assertEquals((Object)PartitionDataTypeUtils.CONVERTATION_FAILURE, (Object)PartitionDataTypeUtils.convert((Object)"0.3", (PartitionParameterType)PartitionParameterType.BOOLEAN));
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("42.4f", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("0.4d", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("12345678901234567890.123456789012345678901d", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("04d17cf3-bc20-4e3d-9ff7-72437cdae227", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("04d17cf3bc204e3d9ff772437cdae227", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("a", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("aaa", PartitionParameterType.BOOLEAN);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(" aaa ", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("true", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("t", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("yes", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("y", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("false", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("f", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("no", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("n", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(" true ", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("null", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("NULL", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("2000-01-02", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("10:00:00", new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2("2001-01-01 23:59:59.123456", new PartitionParameterType[0]);
    }

    @Test
    public void convertDecimal() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(new BigDecimal(42.5), PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(new BigDecimal(0.5), PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(new BigDecimal(0), PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(new BigDecimal(1.2345678E7), PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(BigDecimal.valueOf(1.23345353454567E16), PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(new BigDecimal(Double.MIN_VALUE), PartitionParameterType.UUID);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(new BigDecimal(Double.MAX_VALUE), PartitionParameterType.UUID);
        SqlDataTypeConversionTest.assertEquals((Object)PartitionDataTypeUtils.CONVERTATION_FAILURE, (Object)PartitionDataTypeUtils.convert((Object)new BigDecimal(42.5), (PartitionParameterType)PartitionParameterType.UUID));
    }

    @Test
    public void convertUUID() throws Exception {
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(UUID.randomUUID(), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(UUID.fromString("00000000-0000-0000-0000-00000000000a"), new PartitionParameterType[0]);
        this.makeSureThatConvertationResultsExactTheSameAsWithinH2(new UUID(0L, 1L), new PartitionParameterType[0]);
    }

    @Test
    public void stringToUUIDConvertation() {
        UUID expUuid = UUID.fromString("273ded0d-86de-432e-b252-54c06ec22927");
        SqlDataTypeConversionTest.assertEquals((Object)expUuid, (Object)PartitionDataTypeUtils.stringToUUID((String)"273ded0d-86de-432e-b252-54c06ec22927"));
        SqlDataTypeConversionTest.assertEquals((Object)expUuid, (Object)PartitionDataTypeUtils.stringToUUID((String)"273ded0d86de432eb25254c06ec22927"));
        SqlDataTypeConversionTest.assertEquals((Object)expUuid, (Object)PartitionDataTypeUtils.stringToUUID((String)"273ded0d86de432e-b25254c06ec22927"));
        SqlDataTypeConversionTest.assertEquals((Object)expUuid, (Object)PartitionDataTypeUtils.stringToUUID((String)"273dED0D-86DE-432E-B25254C06EC22927"));
        SqlDataTypeConversionTest.assertEquals((Object)expUuid, (Object)PartitionDataTypeUtils.stringToUUID((String)"273dED0D86DE432Eb252-54c06ec22927"));
    }

    private void makeSureThatConvertationResultsExactTheSameAsWithinH2(Object arg, PartitionParameterType ... excludedTargetTypesFromCheck) throws Exception {
        EnumSet<PartitionParameterType> targetTypes = excludedTargetTypesFromCheck.length > 0 ? EnumSet.complementOf(EnumSet.of(excludedTargetTypesFromCheck[0], excludedTargetTypesFromCheck)) : EnumSet.allOf(PartitionParameterType.class);
        for (PartitionParameterType targetType : targetTypes) {
            Object convertationRes = PartitionDataTypeUtils.convert((Object)arg, (PartitionParameterType)targetType);
            if (PartitionDataTypeUtils.CONVERTATION_FAILURE == convertationRes) {
                try {
                    H2Utils.convert((Object)arg, (IgniteH2Indexing)idx, (int)IGNITE_PARAMETER_TYPE_TO_H2_PARAMETER_TYPE.get(targetType));
                    SqlDataTypeConversionTest.fail((String)"Data conversion failed in Ignite but not in H2.");
                }
                catch (DbException h2Exception) {
                    SqlDataTypeConversionTest.assertTrue((h2Exception.getMessage().contains("Numeric value out of range") || h2Exception.getMessage().contains("Data conversion error") ? 1 : 0) != 0);
                }
                continue;
            }
            Object convertationH2Res = H2Utils.convert((Object)arg, (IgniteH2Indexing)idx, (int)IGNITE_PARAMETER_TYPE_TO_H2_PARAMETER_TYPE.get(targetType));
            if (convertationRes == null) {
                SqlDataTypeConversionTest.assertNull((Object)convertationH2Res);
                continue;
            }
            SqlDataTypeConversionTest.assertEquals(PARAMETER_TYPE_TO_JAVA_CLASS.get(targetType), convertationRes.getClass());
            SqlDataTypeConversionTest.assertEquals(convertationH2Res.getClass(), convertationRes.getClass());
            SqlDataTypeConversionTest.assertEquals((Object)convertationH2Res, (Object)convertationRes);
        }
    }

    static {
        EnumMap<PartitionParameterType, Class> paramTypeToJavaCls = new EnumMap<PartitionParameterType, Class>(PartitionParameterType.class);
        paramTypeToJavaCls.put(PartitionParameterType.BOOLEAN, Boolean.class);
        paramTypeToJavaCls.put(PartitionParameterType.BYTE, Byte.class);
        paramTypeToJavaCls.put(PartitionParameterType.SHORT, Short.class);
        paramTypeToJavaCls.put(PartitionParameterType.INT, Integer.class);
        paramTypeToJavaCls.put(PartitionParameterType.LONG, Long.class);
        paramTypeToJavaCls.put(PartitionParameterType.FLOAT, Float.class);
        paramTypeToJavaCls.put(PartitionParameterType.DOUBLE, Double.class);
        paramTypeToJavaCls.put(PartitionParameterType.STRING, String.class);
        paramTypeToJavaCls.put(PartitionParameterType.DECIMAL, BigDecimal.class);
        paramTypeToJavaCls.put(PartitionParameterType.UUID, UUID.class);
        PARAMETER_TYPE_TO_JAVA_CLASS = Collections.unmodifiableMap(paramTypeToJavaCls);
        EnumMap<PartitionParameterType, Integer> igniteParamTypeToH2ParamType = new EnumMap<PartitionParameterType, Integer>(PartitionParameterType.class);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.BOOLEAN, 1);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.BYTE, 2);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.SHORT, 3);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.INT, 4);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.LONG, 5);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.FLOAT, 8);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.DOUBLE, 7);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.STRING, 13);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.DECIMAL, 6);
        igniteParamTypeToH2ParamType.put(PartitionParameterType.UUID, 20);
        IGNITE_PARAMETER_TYPE_TO_H2_PARAMETER_TYPE = Collections.unmodifiableMap(igniteParamTypeToH2ParamType);
    }
}

