/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.H2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceIndexIterator;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class NoneOrSinglePartitionsQueryOptimizationsTest
extends GridCommonAbstractTest {
    private static final int RES_RETRIEVAL_TIMEOUT = 5000;
    private static final int NODES_COUNT = 2;
    private static final int ORG_COUNT = 100;
    private static final String ORG_CACHE_NAME = "org";
    public static final String PERS_CACHE_NAME = "pers";
    private static IgniteCache<Integer, JoinSqlTestHelper.Organization> orgCache;
    private static IgniteCache<Integer, JoinSqlTestHelper.Person> persCache;
    private boolean clientMode;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TestCommunicationSpi());
        cfg.setClientMode(this.clientMode);
        return cfg;
    }

    private static Collection<QueryEntity> organizationQueryEntity() {
        QueryEntity entity = new QueryEntity(Integer.class, JoinSqlTestHelper.Organization.class);
        entity.setKeyFieldName("ID");
        entity.getFields().put("ID", String.class.getName());
        return Collections.singletonList(entity);
    }

    private static Collection<QueryEntity> personQueryEntity() {
        QueryEntity entity = new QueryEntity(Integer.class, JoinSqlTestHelper.Person.class);
        entity.setKeyFieldName("ID");
        entity.getFields().put("ID", String.class.getName());
        return Collections.singletonList(entity);
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(1, false);
        this.clientMode = true;
        this.startGrid(2);
        orgCache = this.ignite(2).getOrCreateCache(new CacheConfiguration(ORG_CACHE_NAME).setCacheMode(CacheMode.PARTITIONED).setQueryEntities(NoneOrSinglePartitionsQueryOptimizationsTest.organizationQueryEntity()));
        persCache = this.ignite(2).getOrCreateCache(new CacheConfiguration(PERS_CACHE_NAME).setCacheMode(CacheMode.PARTITIONED).setSqlSchema(PERS_CACHE_NAME).setIndexedTypes(new Class[]{Integer.class, JoinSqlTestHelper.Person.class}).setQueryEntities(NoneOrSinglePartitionsQueryOptimizationsTest.personQueryEntity()));
        this.awaitPartitionMapExchange();
        this.populateDataIntoOrg();
    }

    protected void afterTestsStopped() throws Exception {
        orgCache = null;
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-11019")
    @Test
    public void testQueryWithMultiplePartitions() throws Exception {
        this.runQuery("select * from Organization org where org._KEY = 1 or org._KEY = 2", 2, false, false, 1, new Object[0]);
    }

    @Test
    public void testQueryWithMultiplePartitionsOrderBy() throws Exception {
        this.runQuery("select * from Organization org where org._KEY = 1 or org._KEY = 2 order by org._KEY", 2, true, false, 2, new Object[0]);
    }

    @Test
    public void testQueryWithMultiplePartitionsGroupBy() throws Exception {
        this.runQuery("select * from Organization org where org._KEY  between 10 and 20  group by org._KEY", 11, true, false, 2, new Object[0]);
    }

    @Test
    public void testQueryWithMultiplePartitionsHaving() throws Exception {
        this.runQuery("select org.debtCapital, count(*) from Organization org group by org.debtCapital having count(*) < 10", 100, true, false, 2, new Object[0]);
    }

    @Test
    public void testQueryWithSinglePartition() throws Exception {
        this.runQuery("select * from Organization org where org._KEY = 1 order by org._KEY", 1, false, true, 1, new Object[0]);
    }

    @Test
    public void testQueryWithSinglePartitionOrderBy() throws Exception {
        this.runQuery("select * from Organization org where org._KEY = 1 order by org._KEY", 1, false, true, 1, new Object[0]);
    }

    @Test
    public void testQueryWithSinglePartitionGroupBy() throws Exception {
        this.runQuery("select * from Organization org where org._KEY  between 10 and 10 group by org._KEY", 1, false, true, 1, new Object[0]);
    }

    @Test
    public void testQueryWithSinglePartitionHaving() throws Exception {
        this.runQuery("select org.debtCapital, count(*) from Organization org where org._KEY = 1 group by org.debtCapital having count(*) < 10", 1, false, true, 1, new Object[0]);
    }

    @Test
    public void testQueryWithNonePartititons() throws Exception {
        TestCommunicationSpi commSpi = (TestCommunicationSpi)this.grid(2).configuration().getCommunicationSpi();
        commSpi.resetQueries();
        IgniteInternalFuture res = GridTestUtils.runAsync(() -> orgCache.query(new SqlFieldsQuery("select * from Organization org where org._KEY = 1 and org._KEY = 2 order by org._KEY")).getAll());
        List rows = (List)res.get(5000L);
        NoneOrSinglePartitionsQueryOptimizationsTest.assertNotNull((Object)rows);
        NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((int)0, (int)rows.size());
        NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((int)0, (int)commSpi.mapQueries.size());
    }

    @Test
    public void testQueryWithNonePartititonsAndParams() throws Exception {
        TestCommunicationSpi commSpi = (TestCommunicationSpi)this.grid(2).configuration().getCommunicationSpi();
        commSpi.resetQueries();
        IgniteInternalFuture res = GridTestUtils.runAsync(() -> orgCache.query(new SqlFieldsQuery("select * from Organization org where org._KEY = ? and org._KEY = ? order by org._KEY").setArgs(new Object[]{1, 2})).getAll());
        List rows = (List)res.get(5000L);
        NoneOrSinglePartitionsQueryOptimizationsTest.assertNotNull((Object)rows);
        NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((int)0, (int)rows.size());
        NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((int)0, (int)commSpi.mapQueries.size());
    }

    @Test
    public void testQueryWithSinglePartitionAndParams() throws Exception {
        this.runQuery("select * from Organization org where org._KEY = ? order by org._KEY", 1, false, true, 1, 1);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-11019")
    @Test
    public void testQueryWithMultiplePartitionsAndParams() throws Exception {
        this.runQuery("select * from Organization org where org._KEY = ? or org._KEY = ? ", 2, false, false, 1, 1, 2);
    }

    @Test
    public void testQueryWithMixedPartitionsAndParams() throws Exception {
        this.runQuery("select * from Organization org where org._KEY = ? or org._KEY = ? order by org._KEY", 1, false, true, 1, 1, 1);
        this.runQuery("select * from Organization org where org._KEY = ? or org._KEY = ? order by org._KEY", 2, true, false, 2, 1, 2);
    }

    @Test
    public void testQueryWithMultipleMapQueriesAndMixedPartitionsAndParams() throws Exception {
        this.runQuery("select org._KEY from Organization org where org._KEY = ? or org._KEY = ? union select org._KEY from Organization org where org._KEY = ? or org._KEY = ?", 1, false, true, 1, 1, 1, 1, 1);
        this.runQuery("select org._KEY from Organization org where org._KEY = ? or org._KEY = ? union select org._KEY from Organization org where org._KEY = ? or org._KEY = ?", 4, true, false, 3, 1, 2, 3, 4);
    }

    @Test
    public void testJoinQueriesWithMixedMapQueriesAndMixedPartitionsAndParams() throws Exception {
        this.runQuery("select o.id, sum(o._KEY) FROM Organization o LEFT JOIN (select distinct orgId from pers.Person where _KEY = ? or _KEY = ?) as p on p.orgId=o.id where o._KEY = 1 GROUP BY o.id", 1, false, true, 1, 1, 1);
        this.runQuery("select o.id, sum(o._KEY) FROM Organization o LEFT JOIN (select distinct orgId from pers.Person where _KEY = ? or _KEY = ?) as p on p.orgId=o.id where o._KEY = 1 GROUP BY o.id", 1, true, false, 3, 1, 2);
    }

    @Test
    public void testQueryWithSubqueryWithinFromWithSingleMapQueryAndMultiplePartitons() throws Exception {
        this.runQuery("select _KEY from (select org._KEY, org.debtCapital from Organization org where org._KEY between ? and ?) where debtCapital > ? order by _KEY", 9, true, false, 2, 2, 10, 0);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-11019")
    @Test
    public void testSimpleQueryWithSubqueryWithinFromWithSingleMapQueryAndMultiplePartitons() throws Exception {
        this.runQuery("select _KEY from (select org._KEY, org.debtCapital from Organization org where org._KEY between ? and ?) where debtCapital > ?", 9, false, false, 1, 2, 10, 0);
    }

    @Test
    public void testQueryWithSubqueryWithinWhereClauseWithSingleMapQueryAndMultiplePartitons() throws Exception {
        this.runQuery("select _key from Organization where _key = (select MAX(org._KEY) from Organization org where org._key between ? and ?) group by _key", 1, true, false, 2, 12, 20);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-11019")
    @Test
    public void testSimpleQueryWithSubqueryWithinWhereClauseWithSingleMapQueryAndMultiplePartitons() throws Exception {
        this.runQuery("select _key from Organization where _key = (select MAX(org._KEY) from Organization org where org._key between ? and ?)", 1, false, false, 1, 13, 20);
    }

    @Test
    public void testQueryWithSubqueryAsColumnWithSingleMapQueryAndMultiplePartitons() throws Exception {
        this.runQuery("select debtCapital, select max(_KEY) from Organization where _key > ? as maxKey from Organization order by _key", 100, true, false, 2, 50);
    }

    private void runQuery(String sqlQry, int expResCnt, boolean expMergeTbl, boolean expOriginalQry, int explainSize, Object ... args) throws Exception {
        TestCommunicationSpi commSpi = (TestCommunicationSpi)this.grid(2).configuration().getCommunicationSpi();
        commSpi.resetQueries();
        IgniteInternalFuture res = GridTestUtils.runAsync(() -> {
            FieldsQueryCursor cursor = orgCache.query(new SqlFieldsQuery(sqlQry).setArgs(args));
            Iterable iter = (Iterable)U.field((Object)cursor, (String)"iterExec");
            Iterator innerIter = (Iterator)U.field(iter.iterator(), (String)"iter");
            if (expMergeTbl) {
                NoneOrSinglePartitionsQueryOptimizationsTest.assertTrue((boolean)(innerIter instanceof H2ResultSetIterator));
            } else {
                NoneOrSinglePartitionsQueryOptimizationsTest.assertTrue((boolean)(innerIter instanceof ReduceIndexIterator));
            }
            ArrayList<List> all = new ArrayList<List>();
            while (innerIter.hasNext()) {
                all.add((List)innerIter.next());
            }
            return all;
        });
        List rows = (List)res.get(5000L);
        NoneOrSinglePartitionsQueryOptimizationsTest.assertNotNull((Object)rows);
        NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((int)expResCnt, (int)rows.size());
        int mapQueriesCnt = commSpi.mapQueries.size();
        if (expOriginalQry) {
            NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((int)1, (int)mapQueriesCnt);
            NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((String)sqlQry, (String)commSpi.mapQueries.get(0));
        } else {
            for (String mapQry : commSpi.mapQueries) {
                Assert.assertNotEquals((Object)sqlQry, (Object)mapQry);
            }
        }
        FieldsQueryCursor explainCursor = orgCache.query(new SqlFieldsQuery("explain " + sqlQry).setArgs(args));
        List explainRes = explainCursor.getAll();
        NoneOrSinglePartitionsQueryOptimizationsTest.assertEquals((int)explainSize, (int)explainRes.size());
        if (expMergeTbl) {
            NoneOrSinglePartitionsQueryOptimizationsTest.assertTrue((boolean)((String)((List)explainRes.get(explainRes.size() - 1)).get(0)).contains(GridSqlQuerySplitter.mergeTableIdentifier((int)0)));
        }
    }

    private void populateDataIntoOrg() {
        int i;
        for (i = 0; i < 100; ++i) {
            JoinSqlTestHelper.Organization org = new JoinSqlTestHelper.Organization();
            org.setName("Organization #" + i);
            org.debtCapital(i);
            orgCache.put((Object)i, (Object)org);
        }
        for (i = 0; i < 200; ++i) {
            JoinSqlTestHelper.Person pers = new JoinSqlTestHelper.Person();
            pers.setOrgId(String.valueOf(i / 2));
            pers.setName("Person #" + i);
            persCache.put((Object)i, (Object)pers);
        }
    }

    private static class TestCommunicationSpi
    extends TcpCommunicationSpi {
        List<String> mapQueries = new CopyOnWriteArrayList<String>();

        private TestCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            if (((GridIoMessage)msg).message() instanceof GridH2QueryRequest) {
                GridH2QueryRequest gridH2QryReq = (GridH2QueryRequest)((GridIoMessage)msg).message();
                for (GridCacheSqlQuery qry : gridH2QryReq.queries()) {
                    this.mapQueries.add(qry.query());
                }
            }
            super.sendMessage(node, msg, ackC);
        }

        void resetQueries() {
            this.mapQueries.clear();
        }
    }
}

