/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class QueryParserMetricsHolderSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static IgniteEx ignite;
    private static IgniteCache<Integer, Integer> cache;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        ignite = this.startGrid();
        cache = ignite.getOrCreateCache(new CacheConfiguration(CACHE_NAME));
    }

    @Test
    public void testParserCacheHits() {
        LongMetric hits = (LongMetric)ignite.context().metric().registry("sql.parser.cache").findMetric("hits");
        Assert.assertNotNull((String)"Unable to find metric with name sql.parser.cache.hits", (Object)hits);
        hits.reset();
        cache.query(new SqlFieldsQuery("CREATE TABLE tbl_hits (id LONG PRIMARY KEY, val LONG)"));
        Assert.assertEquals((long)0L, (long)hits.value());
        for (int i = 0; i < 10; ++i) {
            cache.query(new SqlFieldsQuery("INSERT INTO tbl_hits (id, val) values (?, ?)").setArgs(new Object[]{i, i}));
        }
        Assert.assertEquals((long)9L, (long)hits.value());
        cache.query(new SqlFieldsQuery("SELECT * FROM tbl_hits"));
        Assert.assertEquals((long)9L, (long)hits.value());
        cache.query(new SqlFieldsQuery("SELECT * FROM tbl_hits"));
        Assert.assertEquals((long)10L, (long)hits.value());
        cache.query(new SqlFieldsQuery("SELECT * FROM tbl_hits").setLabel("test-label"));
        Assert.assertEquals((long)11L, (long)hits.value());
    }

    @Test
    public void testParserCacheMisses() {
        LongMetric misses = (LongMetric)ignite.context().metric().registry("sql.parser.cache").findMetric("misses");
        Assert.assertNotNull((String)"Unable to find metric with name sql.parser.cache.misses", (Object)misses);
        misses.reset();
        cache.query(new SqlFieldsQuery("CREATE TABLE tbl_misses (id LONG PRIMARY KEY, val LONG)"));
        Assert.assertEquals((long)1L, (long)misses.value());
        for (int i = 0; i < 10; ++i) {
            cache.query(new SqlFieldsQuery("INSERT INTO tbl_misses (id, val) values (?, ?)").setArgs(new Object[]{i, i}));
        }
        Assert.assertEquals((long)2L, (long)misses.value());
        cache.query(new SqlFieldsQuery("SELECT * FROM tbl_misses"));
        Assert.assertEquals((long)3L, (long)misses.value());
        cache.query(new SqlFieldsQuery("SELECT * FROM tbl_misses"));
        Assert.assertEquals((long)3L, (long)misses.value());
        cache.query(new SqlFieldsQuery("SELECT * FROM tbl_misses").setLabel("test"));
        Assert.assertEquals((long)3L, (long)misses.value());
    }
}

