/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class H2ColumnTypeConversionCheckSelfTest
extends GridCommonAbstractTest {
    @Test
    public void testConversions() throws Exception {
        this.startGrid(0);
        this.grid(0).context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE TBL (id INT PRIMARY KEY, timestamp TIMESTAMP, date DATE, time TIME)"), false);
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("TIMESTAMP", Timestamp.class));
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("TIMESTAMP", java.sql.Date.class));
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("TIMESTAMP", Date.class));
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("TIMESTAMP", LocalDateTime.class));
        H2ColumnTypeConversionCheckSelfTest.assertFalse((boolean)this.isConvertible("TIMESTAMP", Integer.class));
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("DATE", java.sql.Date.class));
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("DATE", LocalDate.class));
        H2ColumnTypeConversionCheckSelfTest.assertFalse((boolean)this.isConvertible("DATE", Integer.class));
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("TIME", Time.class));
        H2ColumnTypeConversionCheckSelfTest.assertTrue((boolean)this.isConvertible("TIME", LocalTime.class));
        H2ColumnTypeConversionCheckSelfTest.assertFalse((boolean)this.isConvertible("TIME", Integer.class));
    }

    private boolean isConvertible(String colName, Class<?> cls) {
        return this.grid(0).context().query().getIndexing().isConvertibleToColumnType("PUBLIC", "TBL", colName, cls);
    }
}

