/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class SqlSchemaSelfTest
extends AbstractIndexingCommonTest {
    private static final String CACHE_PERSON = "PersonCache";
    private static final String CACHE_PERSON_2 = "PersonCache2";
    private IgniteEx node;

    protected void beforeTest() throws Exception {
        this.node = this.startGrid();
        this.startGrid(2);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.node = null;
    }

    @Test
    public void testQueryWithoutCacheOnPublicSchema() throws Exception {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT 1").setSchema("PUBLIC");
        List res = qryProc.querySqlFields(qry, true).getAll();
        SqlSchemaSelfTest.assertEquals((int)1, (int)res.size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)((List)res.get(0)).size());
        SqlSchemaSelfTest.assertEquals((Object)1, ((List)res.get(0)).get(0));
        Iterator iter = qryProc.querySqlFields(qry, true).iterator();
        SqlSchemaSelfTest.assertTrue((boolean)iter.hasNext());
        List row = (List)iter.next();
        SqlSchemaSelfTest.assertEquals((int)1, (int)row.size());
        SqlSchemaSelfTest.assertEquals((Object)1, row.get(0));
        SqlSchemaSelfTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testQueryWithoutCacheOnCacheSchema() throws Exception {
        this.node.createCache(new CacheConfiguration().setName(CACHE_PERSON).setIndexedTypes(new Class[]{PersonKey.class, Person.class}));
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT 1").setSchema(CACHE_PERSON);
        List res = qryProc.querySqlFields(qry, true).getAll();
        SqlSchemaSelfTest.assertEquals((int)1, (int)res.size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)((List)res.get(0)).size());
        SqlSchemaSelfTest.assertEquals((Object)1, ((List)res.get(0)).get(0));
        Iterator iter = qryProc.querySqlFields(qry, true).iterator();
        SqlSchemaSelfTest.assertTrue((boolean)iter.hasNext());
        List row = (List)iter.next();
        SqlSchemaSelfTest.assertEquals((int)1, (int)row.size());
        SqlSchemaSelfTest.assertEquals((Object)1, row.get(0));
        SqlSchemaSelfTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testSchemaChange() throws Exception {
        IgniteCache cache = this.node.createCache(new CacheConfiguration().setName(CACHE_PERSON).setIndexedTypes(new Class[]{PersonKey.class, Person.class}));
        this.node.createCache(new CacheConfiguration().setName(CACHE_PERSON_2).setIndexedTypes(new Class[]{PersonKey.class, Person.class}));
        cache.put((Object)new PersonKey(1L), (Object)new Person("Vasya", 2L));
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM Person")).getAll().size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM Person").setSchema(CACHE_PERSON)).getAll().size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM \"PersonCache\".Person")).getAll().size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM \"PersonCache\".Person").setSchema("PUBLIC")).getAll().size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM \"PersonCache\".Person").setSchema(CACHE_PERSON_2)).getAll().size());
    }

    @Test
    public void testSchemaChangeOnCacheWithPublicSchema() throws Exception {
        IgniteCache cache = this.node.createCache(new CacheConfiguration().setName(CACHE_PERSON).setIndexedTypes(new Class[]{PersonKey.class, Person.class}).setSqlSchema("PUBLIC"));
        this.node.createCache(new CacheConfiguration().setName(CACHE_PERSON_2).setIndexedTypes(new Class[]{PersonKey.class, Person.class}));
        cache.put((Object)new PersonKey(1L), (Object)new Person("Vasya", 2L));
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM Person")).getAll().size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM Person").setSchema("PUBLIC")).getAll().size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM public.Person").setSchema(CACHE_PERSON_2)).getAll().size());
        SqlSchemaSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery("SELECT id, name, orgId FROM \"PUBLIC\".Person").setSchema(CACHE_PERSON_2)).getAll().size());
    }

    @Test
    public void testCustomSchemaName() throws Exception {
        IgniteCache<Long, Person> cache = this.registerQueryEntity("Person", CACHE_PERSON);
        this.testQueryEntity(cache, "Person");
    }

    @Test
    public void testCustomSchemaMultipleCaches() throws Exception {
        int i;
        for (i = 1; i <= 3; ++i) {
            String tbl = "Person" + i;
            IgniteCache<Long, Person> cache = this.registerQueryEntity(tbl, CACHE_PERSON + i);
            this.testQueryEntity(cache, tbl);
        }
        for (i = 1; i < 3; ++i) {
            IgniteCache cache = this.node.cache(CACHE_PERSON + i);
            this.testQueryEntity((IgniteCache<Long, Person>)cache, "Person" + i);
        }
    }

    @Test
    public void testCustomSchemaConcurrentUse() throws Exception {
        final AtomicInteger maxIdx = new AtomicInteger();
        GridTestUtils.runMultiThreaded((Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < GridTestUtils.SF.applyLB((int)100, (int)20); ++i) {
                    int idx = maxIdx.incrementAndGet();
                    String tbl = "Person" + idx;
                    IgniteCache cache = SqlSchemaSelfTest.this.registerQueryEntity(tbl, SqlSchemaSelfTest.CACHE_PERSON + idx);
                    SqlSchemaSelfTest.this.testQueryEntity((IgniteCache<Long, Person>)cache, tbl);
                    cache.destroy();
                }
            }
        }, (int)4, (String)"schema-test");
    }

    private IgniteCache<Long, Person> registerQueryEntity(String tbl, String cacheName) {
        QueryEntity qe = new QueryEntity().setValueType(Person.class.getName()).setKeyType(Long.class.getName()).setValueFieldName("_value").setKeyFieldName("id").addQueryField("id", Long.class.getName(), null).addQueryField("_value", Person.class.getName(), null).addQueryField("name", String.class.getName(), null).addQueryField("orgId", Long.class.getName(), null);
        qe.setTableName(tbl);
        return this.node.createCache(new CacheConfiguration().setName(cacheName).setQueryEntities(Collections.singletonList(qe)).setSqlSchema("TEST"));
    }

    private void testQueryEntity(IgniteCache<Long, Person> cache, String tbl) {
        cache.put((Object)1L, (Object)new Person("Vasya", 2L));
        SqlSchemaSelfTest.assertEquals((int)1, (int)this.node.context().query().querySqlFields(new SqlFieldsQuery(String.format("SELECT id, name, orgId FROM TEST.%s where (id = %d)", tbl, 1)), false).getAll().size());
    }

    @Test
    public void testTypeConflictInPublicSchema() throws Exception {
        this.node.createCache(new CacheConfiguration().setName(CACHE_PERSON).setIndexedTypes(new Class[]{PersonKey.class, Person.class}).setSqlSchema("PUBLIC"));
        Throwable th = GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.node.createCache(new CacheConfiguration().setName(CACHE_PERSON_2).setIndexedTypes(new Class[]{PersonKey.class, Person.class}).setSqlSchema("PUBLIC"));
            return null;
        }, CacheException.class, null);
        SchemaOperationException e = (SchemaOperationException)X.cause((Throwable)th, SchemaOperationException.class);
        SqlSchemaSelfTest.assertEquals((int)3, (int)e.code());
    }

    @Test
    public void testImplicitSchema() {
        IgniteCache c = this.node.getOrCreateCache("testCache1");
        c.query(new SqlFieldsQuery("CREATE TABLE TEST1 (ID LONG PRIMARY KEY, VAL LONG) WITH \"template=replicated\";")).getAll();
        c.query(new SqlFieldsQuery("SELECT * FROM TEST1")).getAll();
    }

    public static class Person {
        @QuerySqlField
        public String name;
        @QuerySqlField(index=true)
        public long orgId;

        public Person(String name, long orgId) {
            this.name = name;
            this.orgId = orgId;
        }
    }

    public static class PersonKey {
        @QuerySqlField
        public long id;

        PersonKey(long id) {
            this.id = id;
        }

        public int hashCode() {
            return (int)this.id;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof PersonKey && F.eq((Object)this.id, (Object)((PersonKey)obj).id);
        }
    }
}

