/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.math.BigDecimal;
import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.junit.Test;

public class SqlResultSetMetaSelfTest
extends AbstractIndexingCommonTest {
    private IgniteEx node;

    protected void beforeTest() throws Exception {
        this.node = this.startGrid();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.node = null;
    }

    @Test
    public void testDecimalColumnScaleAndPrecision() throws Exception {
        GridQueryProcessor qryProc = this.node.context().query();
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE Person(id int, age decimal(3,0), primary key (id))").setSchema("PUBLIC"), true);
        qryProc.querySqlFields(new SqlFieldsQuery("INSERT INTO Person(id, age) VALUES(?, ?)").setSchema("PUBLIC").setArgs(new Object[]{1, new BigDecimal(160)}), true);
        QueryCursorImpl cursor = (QueryCursorImpl)qryProc.querySqlFields(new SqlFieldsQuery("SELECT age FROM Person").setSchema("PUBLIC"), true);
        List fieldsMeta = cursor.fieldsMeta();
        SqlResultSetMetaSelfTest.assertEquals((int)1, (int)fieldsMeta.size());
        GridQueryFieldMetadata meta = (GridQueryFieldMetadata)fieldsMeta.get(0);
        SqlResultSetMetaSelfTest.assertEquals((int)3, (int)meta.precision());
        SqlResultSetMetaSelfTest.assertEquals((int)0, (int)meta.scale());
    }
}

