/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.H2LocalResultFactory;
import org.apache.ignite.internal.processors.query.h2.H2ManagedLocalResult;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.LocalResultImpl;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

@RunWith(value=Parameterized.class)
public class LazyOnDmlTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 3000;
    static final List<H2ManagedLocalResult> localResults = Collections.synchronizedList(new ArrayList());
    @Parameterized.Parameter
    public CacheAtomicityMode atomicityMode;
    @Parameterized.Parameter(value=1)
    public CacheMode cacheMode;

    @Parameterized.Parameters(name="atomicityMode={0}, cacheMode={1}")
    public static Collection parameters() {
        LinkedHashSet<Object[]> paramsSet = new LinkedHashSet<Object[]>();
        Object[] paramTemplate = new Object[2];
        for (CacheAtomicityMode atomicityMode : CacheAtomicityMode.values()) {
            paramTemplate = Arrays.copyOf(paramTemplate, paramTemplate.length);
            paramTemplate[0] = atomicityMode;
            for (CacheMode cacheMode : new CacheMode[]{CacheMode.PARTITIONED, CacheMode.REPLICATED}) {
                Object[] params = Arrays.copyOf(paramTemplate, paramTemplate.length);
                params[1] = cacheMode;
                paramsSet.add(params);
            }
        }
        return paramsSet;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        System.setProperty("IGNITE_H2_LOCAL_RESULT_FACTORY", TestH2LocalResultFactory.class.getName());
        this.startGrids(3);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        System.clearProperty("IGNITE_H2_LOCAL_RESULT_FACTORY");
        super.afterTestsStopped();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        IgniteCache c = this.grid(0).createCache(new CacheConfiguration().setName("test").setSqlSchema("TEST").setAtomicityMode(this.atomicityMode).setCacheMode(this.cacheMode).setQueryEntities(Collections.singleton(new QueryEntity(Long.class.getName(), "testVal").setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val0", Long.class.getName(), null).addQueryField("val1", Long.class.getName(), null).addQueryField("val2", Long.class.getName(), null).setKeyFieldName("id").setIndexes(Collections.singletonList(new QueryIndex(Arrays.asList("val0", "val1"), QueryIndexType.SORTED))))).setBackups(1).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)));
        try (IgniteDataStreamer streamer = this.grid(0).dataStreamer("test");){
            for (long i = 0L; i < 3000L; ++i) {
                BinaryObjectBuilder bob = this.grid(0).binary().builder("testVal");
                bob.setField("val0", (Object)i);
                bob.setField("val1", (Object)i);
                bob.setField("val2", (Object)i);
                streamer.addData((Object)i, (Object)bob.build());
            }
        }
        this.sql("CREATE TABLE table1 (id INT PRIMARY KEY, col0 INT, col1 VARCHAR (100))", new Object[0]);
        this.sql("INSERT INTO table1 (id, col0, col1) SELECT 1, 11, 'FIRST' UNION ALL SELECT 11,12, 'SECOND' UNION ALL SELECT 21, 13, 'THIRD' UNION ALL SELECT 31, 14, 'FOURTH'", new Object[0]);
        this.sql("CREATE TABLE  table2 (id INT PRIMARY KEY, col0 INT, col1 VARCHAR (100))", new Object[0]);
        this.sql("INSERT INTO table2 (id, col0, col1) SELECT 1, 21, 'TWO-ONE' UNION ALL SELECT 11, 22, 'TWO-TWO' UNION ALL SELECT 21, 23, 'TWO-THREE' UNION ALL SELECT 31, 24, 'TWO-FOUR'", new Object[0]);
        for (H2ManagedLocalResult res : localResults) {
            if (res.memoryTracker() == null) continue;
            res.memoryTracker().close();
        }
        localResults.clear();
    }

    protected void afterTest() throws Exception {
        for (String cache : this.grid(0).cacheNames()) {
            this.grid(0).cache(cache).destroy();
        }
        super.afterTest();
    }

    @Test
    public void testUpdateNotLazy() {
        this.checkUpdateNotLazy("UPDATE test SET val0 = val0 + 1 WHERE val0 >= 0");
        this.checkUpdateNotLazy("UPDATE test SET val1 = val1 + 1 WHERE val0 >= 0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpdateNotLazy(String sql) {
        try {
            List res = this.sql(sql, new Object[0]).getAll();
            LazyOnDmlTest.assertEquals((Object)3000L, ((List)res.get(0)).get(0));
            if (this.atomicityMode == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
                LazyOnDmlTest.assertEquals((int)0, (int)localResults.size());
            } else if (this.cacheMode == CacheMode.REPLICATED) {
                LazyOnDmlTest.assertEquals((int)1, (int)localResults.size());
            } else {
                LazyOnDmlTest.assertEquals((int)3, (int)localResults.size());
            }
        }
        finally {
            for (H2ManagedLocalResult res : localResults) {
                if (res.memoryTracker() == null) continue;
                res.memoryTracker().close();
            }
            localResults.clear();
        }
    }

    @Test
    public void testUpdateLazy() {
        this.checkUpdateLazy("UPDATE test SET val0 = val0 + 1");
        this.checkUpdateLazy("UPDATE test SET val2 = val2 + 1 WHERE val2 >= 0");
        this.checkUpdateLazy("UPDATE test SET val0 = val0 + 1 WHERE val1 >= 0");
    }

    public void checkUpdateLazy(String sql) {
        List res = this.sql(sql, new Object[0]).getAll();
        LazyOnDmlTest.assertEquals((Object)3000L, ((List)res.get(0)).get(0));
        LazyOnDmlTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testDeleteWithoutReduce() {
        List res = this.sql("DELETE FROM test WHERE val0 >= 0", new Object[0]).getAll();
        LazyOnDmlTest.assertEquals((Object)3000L, ((List)res.get(0)).get(0));
        LazyOnDmlTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-27502")
    public void testUpdateWithReduce() {
        List res = this.sql("UPDATE test SET val0 = val0 + AVG(val0)", new Object[0]).getAll();
        LazyOnDmlTest.assertEquals((Object)3000L, ((List)res.get(0)).get(0));
        LazyOnDmlTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testUpdateFromSubqueryLazy() {
        List res = this.sql("UPDATE table1 SET (col0, col1) =    (SELECT table2.col0, table2.col1 FROM table2 WHERE table2.id = table1.id)WHERE table1.id in (21, 31)", new Object[0]).getAll();
        LazyOnDmlTest.assertEquals((Object)2L, ((List)res.get(0)).get(0));
        LazyOnDmlTest.assertEquals((int)0, (int)localResults.size());
        res = this.sql("UPDATE table1 SET (col0, col1) =    (SELECT table2.col0, table2.col1 FROM table2 WHERE table2.id = table1.id) WHERE exists (select * from table2 where table2.id = table1.id) AND table1.id in (21, 31)", new Object[0]).getAll();
        LazyOnDmlTest.assertEquals((Object)2L, ((List)res.get(0)).get(0));
        LazyOnDmlTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testUpdateValueField() {
        this.sql("CREATE TABLE TEST2 (id INT PRIMARY KEY, val INT) WITH\"WRAP_VALUE=false\"", new Object[0]);
        this.sql("INSERT INTO TEST2  VALUES (0, 0), (1, 1), (2, 2)", new Object[0]);
        List res = this.sql("UPDATE TEST2 SET _val = _val + 1 WHERE val >=0", new Object[0]).getAll();
        LazyOnDmlTest.assertEquals((Object)3L, ((List)res.get(0)).get(0));
        LazyOnDmlTest.assertFalse((boolean)localResults.isEmpty());
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.sql(this.grid(0), sql, args);
    }

    private FieldsQueryCursor<List<?>> sql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setLazy(true).setSchema("TEST").setPageSize(1).setArgs(args), false);
    }

    public static class TestH2LocalResultFactory
    extends H2LocalResultFactory {
        public LocalResult create(Session ses, Expression[] expressions, int visibleColCnt, boolean system) {
            if (system) {
                return new LocalResultImpl(ses, expressions, visibleColCnt);
            }
            H2ManagedLocalResult res = ses.memoryTracker() != null ? new H2ManagedLocalResult(ses, expressions, visibleColCnt){

                public void onClose() {
                }
            } : new H2ManagedLocalResult(ses, expressions, visibleColCnt);
            localResults.add(res);
            return res;
        }

        public LocalResult create() {
            throw new NotImplementedException();
        }
    }
}

