/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteSqlDefaultValueTest
extends GridCommonAbstractTest {
    private static final String NODE_CLIENT = "client";
    private static final int NODE_COUNT = 2;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        ((TcpDiscoverySpi)c.getDiscoverySpi()).setForceServerMode(true);
        if (gridName.equals(NODE_CLIENT)) {
            c.setClientMode(true);
        }
        return c;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(2);
        this.startGrid(NODE_CLIENT);
    }

    protected void afterTest() throws Exception {
        ArrayList<String> tblNames = new ArrayList<String>();
        for (String cacheName : this.grid(0).context().cache().publicCacheNames()) {
            for (GridQueryTypeDescriptor table : this.grid(0).context().query().types(cacheName)) {
                tblNames.add(table.tableName());
            }
        }
        for (String tbl : tblNames) {
            this.sql("DROP TABLE " + tbl, new Object[0]);
        }
        super.afterTest();
    }

    @Test
    public void testDefaultValueColumn() {
        this.sql("CREATE TABLE TEST (id int, val0 varchar DEFAULT 'default-val', primary key (id))", new Object[0]);
        this.sql("INSERT INTO TEST (id) VALUES (?)", 1);
        this.sql("INSERT INTO TEST (id, val0) VALUES (?, ?)", 2, null);
        this.sql("INSERT INTO TEST (id, val0) VALUES (?, ?)", 3, "test-val");
        List<List<Object>> exp = Arrays.asList(Arrays.asList(1, "default-val"), Arrays.asList(2, null), Arrays.asList(3, "test-val"));
        List<List<?>> res = this.sql("select id, val0 from TEST", new Object[0]);
        this.checkResults(exp, res);
    }

    @Test
    public void testDefaultValueColumnAfterUpdate() {
        this.sql("CREATE TABLE TEST (id int, val0 varchar DEFAULT 'default-val', val1 varchar, primary key (id))", new Object[0]);
        this.sql("INSERT INTO TEST (id, val1) VALUES (?, ?)", 1, "val-10");
        this.sql("INSERT INTO TEST (id, val1) VALUES (?, ?)", 2, "val-20");
        this.sql("INSERT INTO TEST (id, val1) VALUES (?, ?)", 3, "val-30");
        List<List<Object>> exp = Arrays.asList(Arrays.asList(1, "default-val", "val-10"), Arrays.asList(2, "default-val", "val-20"), Arrays.asList(3, "default-val", "val-30"));
        List<List<?>> res = this.sql("select id, val0, val1 from TEST", new Object[0]);
        this.checkResults(exp, res);
        this.sql("UPDATE TEST SET val1=? where id=?", "val-21", 2);
        List<List<Object>> expAfterUpdate = Arrays.asList(Arrays.asList(1, "default-val", "val-10"), Arrays.asList(2, "default-val", "val-21"), Arrays.asList(3, "default-val", "val-30"));
        List<List<?>> resAfterUpdate = this.sql("select id, val0, val1 from TEST", new Object[0]);
        this.checkResults(expAfterUpdate, resAfterUpdate);
    }

    @Test
    public void testEmptyValueNullDefaults() {
        this.sql("CREATE TABLE TEST (id int, val0 varchar, primary key (id))", new Object[0]);
        this.sql("INSERT INTO TEST (id) VALUES (?)", 1);
        this.sql("INSERT INTO TEST (id, val0) VALUES (?, ?)", 2, "test-val");
        List<List<Object>> expected = Arrays.asList(Arrays.asList(1, null), Arrays.asList(2, "test-val"));
        List<List<?>> res = this.sql("select id, val0 from TEST", new Object[0]);
        this.checkResults(expected, res);
    }

    @Test
    public void testAddColumnWithDefaults() {
        this.sql("CREATE TABLE TEST (id int, val0 varchar, primary key (id))", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                IgniteSqlDefaultValueTest.this.sql("ALTER TABLE TEST ADD COLUMN val1 varchar DEFAULT 'default-val'", new Object[0]);
                return null;
            }
        }, IgniteSQLException.class, (String)"ALTER TABLE ADD COLUMN with DEFAULT value is not supported");
    }

    @Test
    public void testDefaultTypes() {
        IgniteSqlDefaultValueTest.assertEquals((String)"Check tinyint", (Object)28, (Object)this.getDefaultObject("TINYINT", "28"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check smallint", (Object)28, (Object)this.getDefaultObject("SMALLINT", "28"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check int", (Object)28, (Object)this.getDefaultObject("INT", "28"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check double", (Object)28.25, (Object)this.getDefaultObject("DOUBLE", "28.25"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check float", (Object)28.25, (Object)this.getDefaultObject("FLOAT", "28.25"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check decimal", (Object)BigDecimal.valueOf(28.25), (Object)this.getDefaultObject("DECIMAL", "28.25"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check varchar", (Object)"test value", (Object)this.getDefaultObject("VARCHAR", "'test value'"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check time", (Object)Time.valueOf("14:01:01"), (Object)this.getDefaultObject("TIME", "'14:01:01'"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check date", (Object)Date.valueOf("2017-12-29"), (Object)this.getDefaultObject("DATE", "'2017-12-29'"));
        IgniteSqlDefaultValueTest.assertEquals((String)"Check timestamp", (Object)Timestamp.valueOf("2017-12-29 14:01:01"), (Object)this.getDefaultObject("TIMESTAMP", "'2017-12-29 14:01:01'"));
    }

    private Object getDefaultObject(String sqlType, String dfltVal) {
        this.sql(String.format("CREATE TABLE TEST (id int, val %s default %s, primary key (id))", sqlType, dfltVal), new Object[0]);
        this.sql("INSERT INTO TEST (id) VALUES (1)", new Object[0]);
        List<List<?>> res = this.sql("SELECT val FROM TEST WHERE id=1", new Object[0]);
        this.sql("DROP TABLE TEST", new Object[0]);
        return res.get(0).get(0);
    }

    private void checkResults(Collection<List<Object>> exp, Collection<List<?>> actual) {
        IgniteSqlDefaultValueTest.assertEquals((int)exp.size(), (int)actual.size());
        for (List<?> row : actual) {
            if (exp.contains(row)) continue;
            IgniteSqlDefaultValueTest.fail((String)("Unexpected results: [row=" + row + ']'));
        }
    }

    private List<List<?>> sql(String sql, Object ... args) {
        return this.grid(NODE_CLIENT).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false).getAll();
    }
}

