/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class IgniteSqlCustomSchemaWithPdsEnabled
extends AbstractIndexingCommonTest {
    private static final String CACHE_NAME = "cache_4";
    private static final String SCHEMA_NAME_1 = "SCHEMA_1";
    private static final String SCHEMA_NAME_2 = "SCHEMA_2";
    private static final String SCHEMA_NAME_3 = "ScHeMa3";
    private static final String SCHEMA_NAME_4 = "SCHEMA_4";
    private static final String TABLE_NAME = "T1";
    private static final String[] ALL_SCHEMAS = new String[]{"SCHEMA_1", "SCHEMA_2", "ScHeMa3", "SCHEMA_4"};

    private static String t(String schema, String tbl) {
        return schema + "." + tbl;
    }

    private static String q(String str) {
        return "\"" + str + "\"";
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{SCHEMA_NAME_1, SCHEMA_NAME_2, IgniteSqlCustomSchemaWithPdsEnabled.q(SCHEMA_NAME_3)})).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    @After
    public void tearDown() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testSimpleRestart() throws Exception {
        this.startAndActivate().createCache(new CacheConfiguration(CACHE_NAME).setSqlSchema(SCHEMA_NAME_4));
        for (String schemaName : ALL_SCHEMAS) {
            this.execSql("CREATE TABLE " + IgniteSqlCustomSchemaWithPdsEnabled.t(IgniteSqlCustomSchemaWithPdsEnabled.q(schemaName), TABLE_NAME) + "(id INT PRIMARY KEY, val VARCHAR)");
            for (int i = 0; i < 10; ++i) {
                this.execSql("INSERT INTO " + IgniteSqlCustomSchemaWithPdsEnabled.t(IgniteSqlCustomSchemaWithPdsEnabled.q(schemaName), TABLE_NAME) + "(id, val) VALUES (" + i + ", '" + schemaName + "')");
            }
        }
        this.stopGrid(0);
        this.startGrid(0).cluster().active(true);
        for (String schemaName : ALL_SCHEMAS) {
            List<List<?>> act = this.execSql("SELECT COUNT(*) FROM " + IgniteSqlCustomSchemaWithPdsEnabled.t(IgniteSqlCustomSchemaWithPdsEnabled.q(schemaName), TABLE_NAME) + " WHERE val = '" + schemaName + "'");
            Assert.assertEquals((Object)10L, act.get(0).get(0));
        }
    }

    @Test
    public void testRecreateAfterRestart() throws Exception {
        IgniteCache cache = this.startAndActivate().createCache(new CacheConfiguration(CACHE_NAME).setSqlSchema(SCHEMA_NAME_4));
        this.verifyCacheInSchema(CACHE_NAME, SCHEMA_NAME_4);
        cache.destroy();
        this.stopGrid(0);
        this.startAndActivate().createCache(new CacheConfiguration(CACHE_NAME).setSqlSchema(SCHEMA_NAME_4));
        this.verifyCacheInSchema(CACHE_NAME, SCHEMA_NAME_4);
    }

    private void verifyCacheInSchema(String cacheName, String expSchema) {
        Object actSchema = this.execSql("SELECT SQL_SCHEMA FROM " + IgniteSqlCustomSchemaWithPdsEnabled.t(QueryUtils.sysSchemaName(), "CACHES") + " WHERE CACHE_NAME = '" + cacheName + "'").get(0).get(0);
        Assert.assertEquals((Object)expSchema, actSchema);
    }

    private IgniteEx startAndActivate() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        return ignite;
    }

    private List<List<?>> execSql(String qry) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(qry).setLazy(true), false).getAll();
    }
}

