/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class CreateIndexOnInvalidDataTypeTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 10;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setFailureHandler((FailureHandler)new StopNodeFailureHandler()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testCreateIndexOnInvalidData() throws Exception {
        this.startGrid();
        this.grid().cluster().state(ClusterState.ACTIVE);
        IgniteCache c = this.grid().createCache(new CacheConfiguration().setName("test").setSqlSchema("PUBLIC").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, Value.class).setTableName("TEST"))).setBackups(1).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)));
        for (int i = 0; i < 10; ++i) {
            c.put((Object)i, (Object)new Value(i));
        }
        this.sql("ALTER TABLE TEST ADD COLUMN (VAL_DATE DATE)", new Object[0]);
        this.sql("CREATE INDEX TEST_VAL_INT_IDX ON TEST(VAL_INT)", new Object[0]);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
            this.sql("CREATE INDEX TEST_VAL_DATE_IDX ON TEST(VAL_DATE)", new Object[0]);
            return null;
        }, IgniteSQLException.class, (String)"java.util.Date cannot be cast to java.sql.Date");
        U.sleep((long)1000L);
        List res = this.sql("SELECT val_int FROM TEST where val_int > -1", new Object[0]).getAll();
        CreateIndexOnInvalidDataTypeTest.assertEquals((int)10, (int)res.size());
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
            this.sql("DROP INDEX TEST_VAL_DATE_IDX", new Object[0]);
            return null;
        }, IgniteSQLException.class, (String)"Index doesn't exist: TEST_VAL_DATE_IDX");
    }

    @Test
    public void testAddInvalidDataToIndex() throws Exception {
        this.startGrid();
        this.grid().cluster().state(ClusterState.ACTIVE);
        this.sql("CREATE TABLE TEST (ID INT PRIMARY KEY, VAL_INT INT, VAL_DATE DATE) WITH \"CACHE_NAME=test,VALUE_TYPE=ValueType0\"", new Object[0]);
        this.sql("CREATE INDEX TEST_0_VAL_DATE_IDX ON TEST(VAL_DATE)", new Object[0]);
        this.sql("CREATE INDEX TEST_1_VAL_INT_IDX ON TEST(VAL_INT)", new Object[0]);
        BinaryObjectBuilder bob = this.grid().binary().builder("ValueType0");
        bob.setField("VAL_INT", (Object)10);
        bob.setField("VAL_DATE", (Object)new Date());
        GridTestUtils.assertThrowsWithCause(() -> this.grid().cache("test").put((Object)0, (Object)bob.build()), IgniteSQLException.class);
        CreateIndexOnInvalidDataTypeTest.assertNull((Object)this.grid().cache("test").get((Object)0));
        this.sql("DROP INDEX TEST_0_VAL_DATE_IDX", new Object[0]);
        this.grid().cache("test").put((Object)1, (Object)bob.build());
        List res = this.sql("SELECT VAL_INT FROM TEST WHERE VAL_INT > 0", new Object[0]).getAll();
        CreateIndexOnInvalidDataTypeTest.assertEquals((int)1, (int)res.size());
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid().context().query().querySqlFields(new SqlFieldsQuery(sql).setLazy(true).setArgs(args), false);
    }

    private static class Value {
        @QuerySqlField
        int val_int;
        Date val_date;

        public Value(int val) {
            this.val_int = val;
            this.val_date = new Date(val);
        }
    }
}

