/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database.baseline;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteCacheQueryNodeRestartSelfTest;

public class IgniteStableBaselineCacheQueryNodeRestartsSelfTest
extends IgniteCacheQueryNodeRestartSelfTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.cleanPersistenceDir();
        this.startGrids(this.gridCount() + 1);
        this.initStoreStrategy();
        this.grid(0).cluster().active(true);
        this.stopGrid(this.gridCount());
        this.startGrid(this.gridCount() + 1);
        this.awaitPartitionMapExchange();
    }

    @Override
    protected IgniteInternalFuture createRestartAction(final AtomicBoolean done, final AtomicInteger restartCnt) throws Exception {
        return this.multithreadedAsync(new Callable<Object>(){
            private final int logFreq = 50;

            @Override
            public Object call() throws Exception {
                while (!done.get()) {
                    int idx = IgniteStableBaselineCacheQueryNodeRestartsSelfTest.this.gridCount();
                    IgniteStableBaselineCacheQueryNodeRestartsSelfTest.this.startGrid(idx);
                    IgniteStableBaselineCacheQueryNodeRestartsSelfTest.this.stopGrid(idx);
                    int c = restartCnt.incrementAndGet();
                    if (c % 50 != 0) continue;
                    IgniteStableBaselineCacheQueryNodeRestartsSelfTest.this.info("Node restarts: " + c);
                }
                return true;
            }
        }, 1, "restart-thread");
    }

    @Override
    protected int countRebalances(int nodes, int restarts) {
        return 0;
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }
}

